/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.bo;

import cn.com.duiba.stock.service.api.remoteservice.RemoteStockBackendService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.api.enums.ErpErrorCodeReturnEnum;
import com.qiho.center.biz.model.AckErpStock;
import com.qiho.center.biz.model.ErpResponse;
import com.qiho.center.biz.model.ErpStock;
import com.qiho.center.biz.service.impl.OrderStockService;
import com.qiho.center.common.util.ERPClientUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SyncStockBo {
    private static final Logger logger = LoggerFactory.getLogger(SyncStockBo.class);
    @Autowired
    private RemoteStockBackendService remoteStockBackendService;
    @Autowired
    private OrderStockService orderStockService;
    private static final String limit = "100";
    @Value(value="${qiho.erp.shop.no}")
    private String shopNo;
    @Value(value="${qiho.stock.change.query.url}")
    private String erpStockChangeQueryUrl;
    @Value(value="${qiho.stock.change.ack.url}")
    private String stockChangeAckUrl;

    public void syncStock() {
        Map<String, String> params;
        String result;
        ErpResponse erpResponse;
        List resultStocks;
        ArrayList increaseStock = Lists.newArrayList();
        ArrayList decreaseStock = Lists.newArrayList();
        while (!(resultStocks = JSONArray.parseArray((String)(erpResponse = (ErpResponse)JSON.parseObject((String)(result = ERPClientUtil.execute((String)this.erpStockChangeQueryUrl, params = this.getParams())), ErpResponse.class)).getStockChangeList(), ErpStock.class)).isEmpty() && ErpErrorCodeReturnEnum.SUCCESS.getCode().equals(erpResponse.getCode())) {
            ArrayList<ErpStock> stocks = new ArrayList<ErpStock>(new HashSet(resultStocks));
            this.orderStockService.handlerErpStocks(increaseStock, decreaseStock, stocks);
            this.ackStock(resultStocks);
        }
        DubboResult incResult = this.remoteStockBackendService.increaseItemStockBatch((List)increaseStock);
        DubboResult desResult = this.remoteStockBackendService.decreaseItemStockBatch((List)decreaseStock);
        if (!incResult.isSuccess() || !desResult.isSuccess()) {
            logger.warn("\u5e93\u5b58\u540c\u6b65\u5931\u8d25\uff1a{},{}", (Object)incResult.getMsg(), (Object)desResult.getMsg());
        }
    }

    private void ackStock(List<ErpStock> stocks) {
        HashMap<String, String> ackParam = new HashMap<String, String>();
        List ackErpStock = BeanUtils.copyList(stocks, AckErpStock.class);
        ackParam.put("stock_sync_list", JSONObject.toJSON((Object)ackErpStock).toString());
        try {
            ERPClientUtil.execute((String)this.stockChangeAckUrl, ackParam);
        }
        catch (Exception e) {
            logger.error("\u8fd4\u56deERP\u7cfb\u7edf\u540c\u6b65\u5e93\u5b58\u4fe1\u606f\u5904\u7406\u7ed3\u679c\uff0c\u8bf7\u6c42\u5931\u8d25", (Throwable)e);
        }
    }

    private Map<String, String> getParams() {
        HashMap params = Maps.newHashMap();
        params.put("shop_no", this.shopNo);
        params.put("limit", limit);
        return params;
    }
}

