/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.engine.coupon.astrict;

import com.qiho.center.api.enums.coupon.AstrictMark;
import com.qiho.center.api.enums.coupon.CouponAstrictEnum;
import com.qiho.center.api.params.AstrictCouponParams;
import com.qiho.center.biz.engine.coupon.AstrictContextDecider;
import com.qiho.center.biz.engine.coupon.AstrictInterface;
import com.qiho.center.biz.engine.coupon.AstrictTemplate;
import com.qiho.center.common.entity.coupon.QihoCouponConsumerEntity;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component
public class BuyNumAstrictTemplate
implements AstrictTemplate<AstrictCouponParams, QihoCouponConsumerEntity> {
    @PostConstruct
    public void init() {
        AstrictContextDecider.registPaychannel(this.getAstrictMarkEnum(), this);
    }

    @Override
    public Boolean astrictProcess(AstrictInterface<AstrictCouponParams, QihoCouponConsumerEntity> context) {
        AstrictCouponParams astrictVal = context.getAstrictVal();
        QihoCouponConsumerEntity entity = context.getVerifyModle();
        Integer buyNum = astrictVal.getBuyNum();
        Integer employConditThreshold = entity.getEmployConditThreshold();
        return buyNum >= employConditThreshold;
    }

    @Override
    public AstrictMark getAstrictMarkEnum() {
        return CouponAstrictEnum.ITEM_NUM;
    }
}

