/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.engine.coupon.astrict;

import com.qiho.center.api.enums.OrderStatusEnum;
import com.qiho.center.api.enums.coupon.ActiveRuleEnum;
import com.qiho.center.api.enums.coupon.AstrictMark;
import com.qiho.center.api.params.AstrictCouponParams;
import com.qiho.center.biz.engine.coupon.AstrictContextDecider;
import com.qiho.center.biz.engine.coupon.AstrictInterface;
import com.qiho.center.biz.engine.coupon.AstrictTemplate;
import com.qiho.center.common.dao.QihoOrderSnapshotDAO;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class NewConsumerAstrictTemplate
implements AstrictTemplate<AstrictCouponParams, Object> {
    @Resource
    private QihoOrderSnapshotDAO snapshotDAO;

    @PostConstruct
    public void init() {
        AstrictContextDecider.registPaychannel(this.getAstrictMarkEnum(), this);
    }

    @Override
    public Boolean astrictProcess(AstrictInterface<AstrictCouponParams, Object> context) {
        AstrictCouponParams astrictVal = context.getAstrictVal();
        String mobile = astrictVal.getMobile();
        List orderStatus = Arrays.stream(OrderStatusEnum.values()).map(OrderStatusEnum::getCode).collect(Collectors.toList());
        List orderSnapshots = this.snapshotDAO.findByMobile(mobile, orderStatus);
        return CollectionUtils.isEmpty((Collection)orderSnapshots);
    }

    @Override
    public AstrictMark getAstrictMarkEnum() {
        return ActiveRuleEnum.NEW_CONSUMER;
    }
}

