/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.engine.impl;

import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.dto.OrderStrategyDto;
import com.qiho.center.api.dto.StrategyRuleDto;
import com.qiho.center.api.dto.resultbase.ResultBase;
import com.qiho.center.api.enums.ShotOrder.OrderProcessWayEnum;
import com.qiho.center.api.enums.ShotOrder.ShotOrderHandlerEnum;
import com.qiho.center.api.enums.ShotOrder.StrategyType;
import com.qiho.center.api.params.OrderGainParams;
import com.qiho.center.biz.bo.NoteGainBo;
import com.qiho.center.biz.engine.BaseEngine;
import com.qiho.center.biz.engine.BaseHandler;
import com.qiho.center.biz.engine.Factory.ProcessFaceory;
import com.qiho.center.biz.engine.ProcessContext;
import com.qiho.center.biz.engine.impl.BaseOrderEngine;
import com.qiho.center.biz.service.order.OrderSnapshotService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.apache.commons.collections.comparators.FixedOrderComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShotOrderEngine
extends BaseOrderEngine
implements BaseEngine<OrderSnapshotDto> {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, BaseEngine> strategyTask;
    private BaseHandler baseHandler;
    @Resource
    private NoteGainBo noteGainBo;
    @Resource
    private OrderSnapshotService orderSnapshotService;

    @Override
    public OrderSnapshotDto process(OrderSnapshotDto valuteData) {
        if (null == valuteData) {
            return valuteData;
        }
        try {
            List<OrderStrategyDto> orderStrategyDtos = this.getOrderStrategyList(StrategyType.SHOT_ORDER);
            if (CollectionUtils.isEmpty(orderStrategyDtos)) {
                this.auditOrderPass(valuteData.getOrderId());
                return valuteData;
            }
            this.sortList(orderStrategyDtos);
            boolean isHit = this.checkStrategy(valuteData, orderStrategyDtos);
            if (!isHit) {
                this.auditOrderPass(valuteData.getOrderId());
            }
        }
        catch (Exception e) {
            this.logger.error("\u7b56\u7565\u8fc7\u6ee4\u94fe\u8def\u5931\u8d25, data={}", (Object)valuteData.toString(), (Object)e);
        }
        return valuteData;
    }

    private boolean checkStrategy(OrderSnapshotDto valuteData, List<OrderStrategyDto> orderStrategyDtos) {
        ArrayList<String> handlerNames = new ArrayList<String>();
        boolean isHit = false;
        for (OrderStrategyDto orderStrategyDto : orderStrategyDtos) {
            ResultBase<List<StrategyRuleDto>> resultBase = this.validateorderStrategyDto(orderStrategyDto);
            if (!resultBase.hasSuccessValue()) {
                this.logger.warn(resultBase.getErrorMsg());
                continue;
            }
            List strategyRuleDtos = (List)resultBase.getValue();
            ProcessContext processContext = ProcessFaceory.createProcessContext(valuteData, null, orderStrategyDto);
            Boolean flag = this.checkStrategyDetail(valuteData, strategyRuleDtos, orderStrategyDto);
            if (!flag.booleanValue() || null == this.strategyTask || null == this.strategyTask.get(orderStrategyDto.getHandlerName())) continue;
            handlerNames.add(orderStrategyDto.getHandlerName());
            BaseEngine baseEngine = this.strategyTask.get(orderStrategyDto.getHandlerName());
            baseEngine.process(processContext);
            isHit = true;
            if (!processContext.getNeedBroken().booleanValue()) continue;
            return isHit;
        }
        this.processByHandlerName(handlerNames, valuteData);
        return isHit;
    }

    private boolean checkStrategyDetail(OrderSnapshotDto valuteData, List<StrategyRuleDto> strategyRuleDtos, OrderStrategyDto orderStrategyDto) {
        Boolean flag = Boolean.TRUE;
        for (StrategyRuleDto strategyRuleDto : strategyRuleDtos) {
            ProcessContext processContext = ProcessFaceory.createProcessContext(valuteData, strategyRuleDto, orderStrategyDto);
            ResultBase<Boolean> checkResult = this.baseHandler.handleRequest(processContext);
            if (checkResult.hasSuccessValue()) {
                flag = flag != false && (Boolean)checkResult.getValue() != false;
                continue;
            }
            flag = Boolean.FALSE;
            this.logger.warn("\u672c\u6761\u7b56\u7565\u89c4\u5219\u6821\u9a8c\u5931\u8d25 msg={} strategyName={} ruleName={} fieldName={}", new Object[]{checkResult.getErrorMsg(), orderStrategyDto.getStrategyName(), strategyRuleDto.getRuleName(), strategyRuleDto.getFieldName()});
            break;
        }
        return flag;
    }

    private void processByHandlerName(List<String> handlerNames, OrderSnapshotDto orderSnapshotDto) {
        if (CollectionUtils.isNotEmpty(handlerNames)) {
            int noteGainIndex = handlerNames.indexOf(ShotOrderHandlerEnum.NOTE_GAIN.getVal());
            int stampIndex = handlerNames.indexOf(ShotOrderHandlerEnum.STAMP.getVal());
            OrderGainParams orderGainParams = new OrderGainParams();
            orderGainParams.setOrderId(orderSnapshotDto.getOrderId());
            if (noteGainIndex > -1) {
                orderGainParams.setOrderProcessWayEnum(OrderProcessWayEnum.NOTE_GAIN);
                orderGainParams.setProcessTime(new Date());
                this.noteGainBo.sendGainNote(orderSnapshotDto);
            }
            if (noteGainIndex == -1 && stampIndex > -1) {
                orderGainParams.setOrderProcessWayEnum(OrderProcessWayEnum.MANUAL_CHECK);
            }
            this.orderSnapshotService.updateOrderProcessWayByOrderId(orderGainParams);
        }
    }

    private void sortList(List<OrderStrategyDto> orderStrategyDtos) {
        Object[] shotOrderHandler = new String[]{ShotOrderHandlerEnum.AUDIT_REJECT.getVal(), ShotOrderHandlerEnum.NOTE_GAIN.getVal(), ShotOrderHandlerEnum.STAMP.getVal()};
        FixedOrderComparator typeComparator = new FixedOrderComparator(shotOrderHandler);
        ComparatorChain moInfoComparator = new ComparatorChain();
        moInfoComparator.addComparator((Comparator)new BeanComparator("handlerName", (Comparator)typeComparator));
        Collections.sort(orderStrategyDtos, moInfoComparator);
    }

    public BaseHandler getBaseHandler() {
        return this.baseHandler;
    }

    public void setBaseHandler(BaseHandler baseHandler) {
        this.baseHandler = baseHandler;
    }

    public Map<String, BaseEngine> getStrategyTask() {
        return this.strategyTask;
    }

    public void setStrategyTask(Map<String, BaseEngine> strategyTask) {
        this.strategyTask = strategyTask;
    }
}

