/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.job;

import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.qiho.center.api.dto.AfterSaleStageDto;
import com.qiho.center.api.enums.AfterSaleOrderStageEnum;
import com.qiho.center.api.enums.AfterSaleOrderStatusEnum;
import com.qiho.center.api.enums.FundStatusEnum;
import com.qiho.center.api.enums.OrderStatusEnum;
import com.qiho.center.api.params.AfterSaleQueryParams;
import com.qiho.center.api.util.JSONUtil;
import com.qiho.center.biz.job.AbstractQihoSimpleElasticJob;
import com.qiho.center.common.dao.QihoAfterSaleOrderDAO;
import com.qiho.center.common.dao.QihoFundOrderDAO;
import com.qiho.center.common.dao.QihoOrderDAO;
import com.qiho.center.common.dao.QihoOrderSnapshotDAO;
import com.qiho.center.common.entity.order.QihoOrderEntity;
import com.qiho.center.common.entity.order.QihoOrderSnapshotEntity;
import com.qiho.center.common.util.AppLogUtil;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class AftersaleSuccessJob
extends AbstractQihoSimpleElasticJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(AftersaleSuccessJob.class);
    @Resource
    private QihoAfterSaleOrderDAO afterSaleOrderDAO;
    @Resource
    private QihoFundOrderDAO qihoFundOrderDAO;
    @Resource
    private QihoOrderDAO qihoOrderDAO;
    @Resource
    private QihoOrderSnapshotDAO qihoOrderSnapshotDAO;

    @Override
    protected void doProcess(JobExecutionMultipleShardingContext shardingContext) {
        LOGGER.warn("\u81ea\u5b9a\u66f4\u65b0\u4ed8\u6b3e\u6210\u529f\u72b6\u6001\u7684\u552e\u540e\u5b50\u8ba2\u5355\u7684\u5b9a\u65f6\u4efb\u52a1 start");
        StopWatch times = new StopWatch();
        times.start();
        Boolean resultBase = this.aftersaleSuccessJob();
        times.stop();
        LOGGER.warn("\u81ea\u5b9a\u66f4\u65b0\u4ed8\u6b3e\u6210\u529f\u72b6\u6001\u7684\u552e\u540e\u5b50\u8ba2\u5355\u7684\u5b9a\u65f6\u4efb\u52a1 end wasteTime={} result={}", (Object)times.getTime(), (Object)resultBase);
    }

    @Transactional(value="QIHO")
    public Boolean aftersaleSuccessJob() {
        AfterSaleQueryParams params = new AfterSaleQueryParams();
        params.setOffset(Integer.valueOf(0));
        params.setMax(Integer.valueOf(200));
        params.setAfterSaleStatus(AfterSaleOrderStatusEnum.AFTER_SALEING.getCode());
        try {
            List entities = this.afterSaleOrderDAO.findAfterSaleByQuery(params);
            if (CollectionUtils.isEmpty((Collection)entities)) {
                return Boolean.TRUE;
            }
            entities.forEach(e -> {
                String afterSaleId = e.getAfterSaleId();
                String metaVal = e.getMetaValue();
                List saleStageDtos = JSONUtil.parseJSONStrToList((String)"detailStage", (String)metaVal, AfterSaleStageDto.class);
                List fundEntities = this.qihoFundOrderDAO.findByAfterSaleId(afterSaleId);
                Long failFundCount = fundEntities.stream().filter(f -> FundStatusEnum.getEnumByCode((String)f.getFundStatus()) != FundStatusEnum.SUCCESS).count();
                if (0L == failFundCount) {
                    AfterSaleStageDto saleStageDto = new AfterSaleStageDto();
                    saleStageDto.setType(AfterSaleOrderStageEnum.REFUND_SUCCESS.getCode());
                    saleStageDto.setUpdateTime(DateUtils.getSecondStr((Date)new Date()));
                    saleStageDtos.add(saleStageDto);
                    JSONObject metaValueJson = new JSONObject();
                    metaValueJson.put("detailStage", (Object)JSON.toJSONString((Object)saleStageDtos));
                    e.setAfterSaleStatus(AfterSaleOrderStatusEnum.SUCCESS.getCode());
                    e.setMetaValue(metaValueJson.toJSONString());
                    this.afterSaleOrderDAO.updateAfterSaleOrder(e);
                    String orderId = e.getOrderId();
                    QihoOrderEntity qihoOrderEntity = new QihoOrderEntity();
                    qihoOrderEntity.setOrderId(orderId);
                    qihoOrderEntity.setOrderStatus(OrderStatusEnum.CLOSED.getCode());
                    qihoOrderEntity.setRemark("\u9000\u8d27\u5b8c\u6210");
                    this.qihoOrderDAO.updateByOrderId(qihoOrderEntity);
                    QihoOrderSnapshotEntity qihoOrderSnapshotEntity = new QihoOrderSnapshotEntity();
                    qihoOrderSnapshotEntity.setOrderId(orderId);
                    qihoOrderSnapshotEntity.setOrderStatus(OrderStatusEnum.CLOSED.getCode());
                    qihoOrderSnapshotEntity.setRemark("\u9000\u8d27\u5b8c\u6210");
                    this.qihoOrderSnapshotDAO.updateByOrderId(qihoOrderSnapshotEntity);
                }
            });
        }
        catch (Exception e2) {
            AppLogUtil.error((Logger)LOGGER, (String)"\u81ea\u5b9a\u66f4\u65b0\u552e\u540e\u5b50\u8ba2\u5355\u4efb\u52a1\u5931\u8d25", (Object[])new Object[]{e2});
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

