/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.job;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.api.enums.AreaEnum;
import com.qiho.center.api.enums.LogisticsNameEnum;
import com.qiho.center.api.enums.OrderStatusEnum;
import com.qiho.center.biz.job.AbstractQihoSimpleElasticJob;
import com.qiho.center.biz.service.LogisticsOrderService;
import com.qiho.center.biz.service.monitor.LogisticsMonitorPlanService;
import com.qiho.center.biz.service.monitor.MonitorReportService;
import com.qiho.center.biz.service.order.OrderService;
import com.qiho.center.common.entityd.qiho.monitor.LogisticsMonitorPlanEntity;
import com.qiho.center.common.entityd.qiho.monitor.LogisticsMonitorReportEntity;
import com.qiho.center.common.entityd.qiho.monitor.LogisticsMonitorStrategyEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LogisticsMonitorJob
extends AbstractQihoSimpleElasticJob {
    @Resource
    LogisticsMonitorPlanService logisticsMonitorPlanService;
    @Resource
    OrderService orderService;
    @Resource
    MonitorReportService monitorReportService;
    @Resource
    LogisticsOrderService logisticsOrderService;
    Logger logger = LoggerFactory.getLogger(LogisticsMonitorJob.class);

    @Override
    protected void doProcess(JobExecutionMultipleShardingContext shardingContext) {
        for (LogisticsNameEnum enumVal : LogisticsNameEnum.values()) {
            LogisticsMonitorPlanEntity planEntity = this.logisticsMonitorPlanService.queryValidMonitorPlan(enumVal.getCode());
            if (null == planEntity) {
                return;
            }
            List<LogisticsMonitorStrategyEntity> strategyEntityList = this.logisticsMonitorPlanService.selectStrategyListByPlanId(planEntity.getId());
            if (CollectionUtils.isEmpty(strategyEntityList)) {
                return;
            }
            this.dealWithStrategy(planEntity, strategyEntityList);
        }
    }

    private void dealWithStrategy(LogisticsMonitorPlanEntity planEntity, List<LogisticsMonitorStrategyEntity> strategyEntityList) {
        for (LogisticsMonitorStrategyEntity strategy : strategyEntityList) {
            try {
                if (strategy.getNextExecuteTime().after(new Date())) continue;
                Map<String, Long> param = null;
                param = StringUtils.equals((CharSequence)strategy.getMonitorStatus(), (CharSequence)OrderStatusEnum.TO_SEND.getCode()) ? this.dealWithOrderMonitor(strategy) : this.dealWithLogisticsOrderMonitor(strategy, planEntity.getLogisticsCode());
                this.insertReport(strategy, planEntity, param);
                strategy.setLastExecuteTime(new Date());
                strategy.setNextExecuteTime(DateUtils.addMinutes((Date)new Date(), (int)strategy.getIntervalNum()));
                this.logisticsMonitorPlanService.updateStrategyExecuteTime(strategy);
            }
            catch (Exception e) {
                this.logger.info("LogisticsMonitorJob run error,param = {}", (Object)strategy.toString(), (Object)e);
            }
        }
    }

    private void insertReport(LogisticsMonitorStrategyEntity strategy, LogisticsMonitorPlanEntity planEntity, Map<String, Long> param) {
        LogisticsMonitorReportEntity entity = new LogisticsMonitorReportEntity();
        entity.setLogisticsCode(planEntity.getLogisticsCode());
        entity.setPlanId(planEntity.getId());
        entity.setMonitorStatus(strategy.getMonitorStatus());
        entity.setWarehouseId(strategy.getWarehouseId());
        entity.setStrategyId(strategy.getId());
        entity.setOrderCountTotal(param.get("orderCountTotal"));
        entity.setOrderCountNormal(param.get("orderCountNormal"));
        entity.setOrderCountYellow(param.get("orderCountYellow"));
        entity.setOrderCountRed(param.get("orderCountRed"));
        entity.setOrderCountCrash(Long.valueOf(0L));
        this.monitorReportService.insert(entity);
    }

    private Map<String, Long> dealWithOrderMonitor(LogisticsMonitorStrategyEntity strategy) {
        Date now = new Date();
        HashMap maps = Maps.newHashMap();
        List<String> provinceList = this.transfromAreaToList(strategy.getAreaInfo());
        Long orderCountTotal = this.orderService.queryMonitorOrderCount(strategy.getMonitorStatus(), null, null, provinceList);
        maps.put("orderCountTotal", orderCountTotal);
        Long orderCountNormal = this.orderService.queryMonitorOrderCount(strategy.getMonitorStatus(), DateUtils.addHours((Date)now, (int)(-strategy.getGeneralLimit().intValue())), null, provinceList);
        maps.put("orderCountNormal", orderCountNormal);
        Long orderCountYellow = this.orderService.queryMonitorOrderCount(strategy.getMonitorStatus(), DateUtils.addHours((Date)now, (int)(-strategy.getDeadlineLimit().intValue())), DateUtils.addHours((Date)now, (int)(-strategy.getGeneralLimit().intValue())), provinceList);
        maps.put("orderCountYellow", orderCountYellow);
        Long orderCountRed = this.orderService.queryMonitorOrderCount(strategy.getMonitorStatus(), null, DateUtils.addHours((Date)now, (int)(-strategy.getDeadlineLimit().intValue())), provinceList);
        maps.put("orderCountRed", orderCountRed);
        return maps;
    }

    private List<String> transfromAreaToList(String areaInfo) {
        ArrayList result = Lists.newArrayList();
        List areaCodeList = Splitter.on((String)",").trimResults().splitToList((CharSequence)areaInfo);
        if (CollectionUtils.isEmpty((Collection)areaCodeList)) {
            return result;
        }
        areaCodeList.stream().forEach(code -> {
            AreaEnum areaEnum = AreaEnum.getAreaEnumByCode((String)code);
            if (null != areaEnum) {
                result.add(areaEnum.getName());
            }
        });
        return result;
    }

    private Map<String, Long> dealWithLogisticsOrderMonitor(LogisticsMonitorStrategyEntity strategy, String logisticsCode) {
        Date now = new Date();
        HashMap maps = Maps.newHashMap();
        List<String> provinceList = this.transfromAreaToList(strategy.getAreaInfo());
        Long orderCountTotal = this.logisticsOrderService.queryMonitorLogisticsOrderCount(strategy.getMonitorStatus(), logisticsCode, null, null, provinceList);
        maps.put("orderCountTotal", orderCountTotal);
        Long orderCountNormal = this.logisticsOrderService.queryMonitorLogisticsOrderCount(strategy.getMonitorStatus(), logisticsCode, DateUtils.addHours((Date)now, (int)(-strategy.getGeneralLimit().intValue())), null, provinceList);
        maps.put("orderCountNormal", orderCountNormal);
        Long orderCountYellow = this.logisticsOrderService.queryMonitorLogisticsOrderCount(strategy.getMonitorStatus(), logisticsCode, DateUtils.addHours((Date)now, (int)(-strategy.getDeadlineLimit().intValue())), DateUtils.addHours((Date)now, (int)(-strategy.getGeneralLimit().intValue())), provinceList);
        maps.put("orderCountYellow", orderCountYellow);
        Long orderCountRed = this.logisticsOrderService.queryMonitorLogisticsOrderCount(strategy.getMonitorStatus(), logisticsCode, null, DateUtils.addHours((Date)now, (int)(-strategy.getDeadlineLimit().intValue())), provinceList);
        maps.put("orderCountRed", orderCountRed);
        return maps;
    }
}

