/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.job;

import cn.com.duiba.wolf.utils.DateUtils;
import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.google.common.collect.Maps;
import com.qiho.center.biz.job.AbstractQihoSimpleElasticJob;
import com.qiho.center.biz.service.homepage.TabItemService;
import com.qiho.center.biz.service.order.OrderSnapshotService;
import com.qiho.center.common.entity.homepage.QihoTabItemEntity;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TabItemSaleNumSyncJob
extends AbstractQihoSimpleElasticJob {
    private static Logger logger = LoggerFactory.getLogger(TabItemSaleNumSyncJob.class);
    @Resource
    private TabItemService tabItemService;
    @Resource
    private OrderSnapshotService orderSnapshotService;
    private int pageSize = 100;

    @Override
    protected void doProcess(JobExecutionMultipleShardingContext shardingContext) {
        List<QihoTabItemEntity> list;
        logger.warn("TabItemSaleNumSyncJob start");
        int pageNum = 1;
        HashMap saleNumMap = Maps.newHashMap();
        Date startTime = DateUtils.getStartTime((Date)DateUtils.daysAddOrSub((Date)new Date(), (int)-3));
        Date endTime = DateUtils.getStartTime((Date)new Date());
        while (!CollectionUtils.isEmpty(list = this.tabItemService.queryAllItemListByPage((pageNum - 1) * this.pageSize, this.pageSize))) {
            for (QihoTabItemEntity entity : list) {
                Integer saleNum = (Integer)saleNumMap.get(entity.getItemId());
                if (null == saleNum) {
                    saleNum = this.orderSnapshotService.queryItemSaleCount(entity.getItemId(), startTime, endTime);
                    saleNumMap.put(entity.getItemId(), saleNum);
                }
                entity.setRecentlySaleNum(saleNum);
                this.tabItemService.updateTabItem(entity);
            }
            ++pageNum;
        }
        logger.warn("TabItemSaleNumSyncJob success");
    }
}

