/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.paychannel.pay;

import cn.com.duibaboot.ext.autoconfigure.accesslog.MD5;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.qiho.center.api.dto.FundOrderDto;
import com.qiho.center.api.dto.PayDto;
import com.qiho.center.api.enums.PayTypeEnum;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.api.util.StringRandUtil;
import com.qiho.center.api.util.WechatPayAppUtil;
import com.qiho.center.api.util.XmlTranformUtil;
import com.qiho.center.biz.model.RefundResult;
import com.qiho.center.biz.paychannel.pay.PayChannelProcessor;
import com.qiho.center.common.util.AppLogUtil;
import com.qiho.center.common.util.HttpClientUtil;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WechatPayBaseProcessor
extends PayChannelProcessor {
    private Logger logger = LoggerFactory.getLogger(WechatPayBaseProcessor.class);
    public static final String UTF_8 = "utf-8";

    @Override
    public boolean verify(Map<String, String> params) {
        String sign = params.get("sign");
        return StringUtils.equals((String)sign, (String)this.sign(params, WechatPayAppUtil.getSecret()));
    }

    @Override
    public String payExecute(String orderId, Map<String, String> params) {
        return null;
    }

    @Override
    public void refund(String orderId, String fundId, Integer refundAmt) {
        try {
            FundOrderDto dto = this.fundOrderService.findByFundId(fundId);
            Map<String, String> dataMap = this.buildRefundParams(orderId, fundId, refundAmt);
            String paramstr = XmlTranformUtil.mapToXml(dataMap);
            String httpResultStr = this.postData("https://api.mch.weixin.qq.com/secapi/pay/refund", paramstr);
            Map resultMap = XmlTranformUtil.xmlToMap((String)httpResultStr);
            if ("FAIL".equals(resultMap.get("return_code"))) {
                AppLogUtil.error((Logger)this.logger, (String)"\u5fae\u4fe1\u53d1\u8d77\u9000\u6b3e\u7f51\u7edc\u901a\u4fe1\u5f02\u5e38,orderId={},msg={}", (Object[])new Object[]{orderId, resultMap.get("return_msg")});
                return;
            }
            if ("FAIL".equals(resultMap.get("result_code"))) {
                AppLogUtil.error((Logger)this.logger, (String)"\u5fae\u4fe1\u53d1\u8d77\u9000\u6b3e\u8bf7\u6c42\u5931\u8d25,orderId={},msg={}", (Object[])new Object[]{orderId, resultMap.get("err_code_des")});
                return;
            }
            dto.setOutSeqNo((String)resultMap.get("refund_id"));
            this.fundOrderService.update(dto);
        }
        catch (Exception e) {
            AppLogUtil.error((Logger)this.logger, (String)"\u5fae\u4fe1\u53d1\u8d77\u9000\u6b3e\u8bf7\u6c42\u5931\u8d25,orderId={}", (Object[])new Object[]{orderId, e});
        }
    }

    @Override
    public RefundResult refundQuery(String orderId, String fundId) {
        RefundResult result = new RefundResult();
        try {
            Map<String, String> dataMap = this.buildQueryRefundParams(orderId, fundId);
            String paramstr = XmlTranformUtil.mapToXml(dataMap);
            String httpResultStr = HttpClientUtil.postData((String)"https://api.mch.weixin.qq.com/pay/refundquery", (String)paramstr);
            Map resultMap = XmlTranformUtil.xmlToMap((String)httpResultStr);
            if ("FAIL".equals(resultMap.get("return_code")) || "FAIL".equals(resultMap.get("result_code"))) {
                result.setIsSuccess(false);
                return result;
            }
            result.setIsSuccess(true);
            String refundStatus = (String)resultMap.get("refund_status_0");
            if (StringUtils.equals((String)"SUCCESS", (String)refundStatus)) {
                result.setRefundStatus("success");
            } else if (StringUtils.equals((String)"PROCESSING", (String)refundStatus)) {
                result.setRefundStatus("processing");
            } else if (StringUtils.equals((String)"REFUNDCLOSE", (String)refundStatus) || StringUtils.equals((String)"CHANGE", (String)refundStatus)) {
                result.setRefundStatus("fail");
            }
        }
        catch (Exception e) {
            AppLogUtil.error((Logger)this.logger, (String)"\u67e5\u8be2\u9000\u6b3e\u8bf7\u6c42\u5931\u8d25,orderId={},fundId={}", (Object[])new Object[]{orderId, fundId, e});
        }
        return result;
    }

    @Override
    PayTypeEnum getPayType() {
        return null;
    }

    @Override
    public PayDto queryPayResult(String orderId) {
        PayDto payDto = new PayDto();
        payDto.setSuccess(false);
        try {
            Map<String, String> map = this.buildQueryPayParams(orderId);
            String paramstr = XmlTranformUtil.mapToXml(map);
            String httpResultStr = HttpClientUtil.postData((String)"https://api.mch.weixin.qq.com/pay/orderquery", (String)paramstr);
            Map resultMap = XmlTranformUtil.xmlToMap((String)httpResultStr);
            if (StringUtils.equals((String)"FAIL", (String)((String)resultMap.get("return_code")))) {
                AppLogUtil.error((Logger)this.logger, (String)"\u5fae\u4fe1\u67e5\u8be2\u8ba2\u5355\u652f\u4ed8\u72b6\u6001\u5931\u8d25,orderId={},msg={}", (Object[])new Object[]{orderId, resultMap.get("return_msg")});
                return payDto;
            }
            if (StringUtils.equals((String)"FAIL", (String)((String)resultMap.get("result_code")))) {
                AppLogUtil.error((Logger)this.logger, (String)"\u5fae\u4fe1\u67e5\u8be2\u8ba2\u5355\u652f\u4ed8\u72b6\u6001\u5931\u8d25,orderId={},msg={}", (Object[])new Object[]{orderId, resultMap.get("err_code_des")});
                return payDto;
            }
            if (StringUtils.equals((String)"SUCCESS", (String)((String)resultMap.get("trade_state")))) {
                payDto.setSuccess(true);
                payDto.setOutTradeNo((String)resultMap.get("transaction_id"));
                payDto.setPayAmt(Integer.valueOf((String)resultMap.get("cash_fee")));
                payDto.setPayerId((String)resultMap.get("openid"));
            }
        }
        catch (Exception e) {
            AppLogUtil.error((Logger)this.logger, (String)"\u5fae\u4fe1\u67e5\u8be2\u8ba2\u5355\u652f\u4ed8\u72b6\u6001\u5f02\u5e38,orderId={}", (Object[])new Object[]{orderId, e});
        }
        return payDto;
    }

    protected String sign(Map<String, String> dataMap, String secret) {
        ArrayList<String> keyList = new ArrayList<String>(dataMap.keySet());
        Collections.sort(keyList);
        StringBuilder toMD5StringBuilder = new StringBuilder();
        for (String key : keyList) {
            String value;
            if (StringUtils.equals((String)key, (String)"sign") || (value = dataMap.get(key)) == null || value.length() <= 0) continue;
            toMD5StringBuilder.append(key + "=" + value + "&");
        }
        toMD5StringBuilder.append("key=").append(secret);
        try {
            return MD5.md5((String)toMD5StringBuilder.toString()).toUpperCase();
        }
        catch (Exception e) {
            AppLogUtil.error((Logger)this.logger, (String)"MD5\u52a0\u5bc6\u5f02\u5e38", (Object[])new Object[]{e});
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String postData(String refundUrl, String paramstr) throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        try (InputStream instream = this.getClass().getResourceAsStream("/apiclient_cert.p12");){
            keyStore.load(instream, WechatPayAppUtil.getMchId().toCharArray());
        }
        SSLContext sslcontext = null;
        try {
            sslcontext = SSLContexts.custom().loadKeyMaterial(keyStore, WechatPayAppUtil.getMchId().toCharArray()).build();
        }
        catch (KeyManagementException e) {
            AppLogUtil.info((Logger)this.logger, (String)"\u52a0\u8f7dssl\u8bc1\u4e66\u5f02\u5e38", (Object[])new Object[]{e});
        }
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, new String[]{"TLSv1"}, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
        CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        HttpPost httpPost = new HttpPost(refundUrl);
        StringEntity strEntity = new StringEntity(paramstr, UTF_8);
        strEntity.setContentEncoding(UTF_8);
        httpPost.setEntity((HttpEntity)strEntity);
        CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
        HttpEntity entity = response.getEntity();
        return EntityUtils.toString((HttpEntity)entity, (String)UTF_8).trim();
    }

    private Map<String, String> buildRefundParams(String orderId, String fundId, Integer refundAmt) {
        HashMap dataMap = Maps.newHashMap();
        dataMap.put("appid", WechatPayAppUtil.getAppId());
        dataMap.put("mch_id", WechatPayAppUtil.getMchId());
        dataMap.put("nonce_str", StringRandUtil.getRandomString((int)32));
        dataMap.put("out_trade_no", orderId);
        dataMap.put("out_refund_no", fundId);
        dataMap.put("total_fee", refundAmt.toString());
        dataMap.put("refund_fee", refundAmt.toString());
        dataMap.put("sign", this.sign(dataMap, WechatPayAppUtil.getSecret()));
        return dataMap;
    }

    private Map<String, String> buildQueryRefundParams(String orderId, String fundId) {
        HashMap dataMap = Maps.newHashMap();
        dataMap.put("appid", WechatPayAppUtil.getAppId());
        dataMap.put("mch_id", WechatPayAppUtil.getMchId());
        dataMap.put("nonce_str", StringRandUtil.getRandomString((int)32));
        dataMap.put("out_refund_no", fundId);
        dataMap.put("out_trade_no", orderId);
        dataMap.put("sign", this.sign(dataMap, WechatPayAppUtil.getSecret()));
        return dataMap;
    }

    private Map<String, String> buildQueryPayParams(String orderId) {
        HashMap dataMap = Maps.newHashMap();
        dataMap.put("appid", WechatPayAppUtil.getAppId());
        dataMap.put("mch_id", WechatPayAppUtil.getMchId());
        dataMap.put("out_trade_no", orderId);
        dataMap.put("nonce_str", StringRandUtil.getRandomString((int)32));
        dataMap.put("sign", this.sign(dataMap, WechatPayAppUtil.getSecret()));
        return dataMap;
    }

    @Override
    public String getOpenIdByCode(String code) {
        String url = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=" + WechatPayAppUtil.getAppId() + "&secret=" + WechatPayAppUtil.getAppSecret() + "&code=" + code + "&grant_type=authorization_code";
        String resultStr = HttpClientUtil.sendGet((String)url);
        Map map = (Map)JSONObject.parse((String)resultStr);
        String openId = (String)map.get("openid");
        if (StringUtils.isBlank((String)openId)) {
            AppLogUtil.warn((Logger)this.logger, (String)"\u83b7\u53d6\u7528\u6237openId\u5931\u8d25,code = {} ,\u8fd4\u56de\u62a5\u6587 = {}", (Object[])new Object[]{code, resultStr});
        }
        return openId;
    }

    @Override
    public void transAccount(String account, String fundId, Integer amount) {
        throw new QihoException("\u5fae\u4fe1\u652f\u4ed8\u6682\u4e0d\u652f\u6301\u8f6c\u8d26");
    }
}

