/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.remoteservice.impl;

import cn.com.duiba.wolf.dubbo.DubboResult;
import com.google.common.base.Objects;
import com.qiho.center.api.dto.BandDto;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.api.params.BandParams;
import com.qiho.center.api.remoteservice.RemoteBandService;
import com.qiho.center.biz.service.BandService;
import com.qiho.center.common.support.ValidatorTool;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemoteBandServiceImpl
implements RemoteBandService {
    private Logger logger = LoggerFactory.getLogger(RemoteBandServiceImpl.class);
    @Autowired
    private BandService bandService;

    public DubboResult<List<BandDto>> findAllBand() {
        return DubboResult.successResult(this.bandService.findAllBand());
    }

    public DubboResult<Integer> saveBand(BandParams params) {
        try {
            ValidatorTool.valid((Object)params);
            if (Objects.equal(null, (Object)params.getId()) && StringUtils.isBlank((String)params.getUrl())) {
                throw new QihoException("Band\u521b\u5efa\u7684\u65f6\u5019\u5fc5\u987b\u8bbe\u7f6e\u94fe\u63a5");
            }
            this.bandService.saveBand(params);
            return DubboResult.successResult((Object)1);
        }
        catch (Exception e) {
            this.logger.info("Band\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> changeBandShowEnable(Long id) {
        return DubboResult.successResult((Object)this.bandService.changeBandShowEnable(id));
    }

    public DubboResult<Integer> sortBand(List<Long> bandIds) {
        return DubboResult.successResult((Object)this.bandService.sortBand(bandIds));
    }

    public DubboResult<Integer> deleteBand(Long id) {
        return DubboResult.successResult((Object)this.bandService.deleteBand(id));
    }
}

