/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.remoteservice.impl;

import cn.com.duiba.wolf.dubbo.DubboResult;
import com.qiho.center.api.dto.CategoryDto;
import com.qiho.center.api.remoteservice.RemoteCategoryService;
import com.qiho.center.biz.service.CategoryService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemoteCategoryServiceImpl
implements RemoteCategoryService {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteCategoryServiceImpl.class);
    @Autowired
    private CategoryService categoryService;

    public DubboResult<Void> sortByRange(Long pid, Integer startPayload, Integer endPayload) {
        try {
            this.categoryService.sortByRange(pid, startPayload, endPayload);
            return DubboResult.successResult(null);
        }
        catch (Exception e) {
            LOG.error("invoke RemoteCategoryService.sortByRange failed, pid={}, startPayload={}, endPayload={}", new Object[]{pid, startPayload, endPayload, e});
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<CategoryDto>> getCategoryByPid(Long pid) {
        try {
            List<CategoryDto> list = this.categoryService.getCategoryByPid(pid);
            return DubboResult.successResult(list);
        }
        catch (Exception e) {
            LOG.error("invoke RemoteCategoryService.getCategoryByPid failed, pid={}", (Object)pid, (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Void> deleteCategoryById(Long categoryId) {
        try {
            this.categoryService.deleteCategoryById(categoryId);
            return DubboResult.successResult(null);
        }
        catch (Exception e) {
            LOG.error("invoke RemoteCategoryService.deleteCategoryById failed, categoryId={}", (Object)categoryId, (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Void> updateCategoryById(Long categoryId, String categoryName) {
        try {
            this.categoryService.updateCategoryById(categoryId, categoryName);
            return DubboResult.successResult(null);
        }
        catch (Exception e) {
            LOG.error("invoke RemoteCategoryService.updateCategoryById failed, categoryId={}, categoryName={}", new Object[]{categoryId, categoryName, e});
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<CategoryDto>> saveCategory(Long pid, List<String> categoryList) {
        try {
            List<CategoryDto> list = this.categoryService.saveCategory(pid, categoryList);
            return DubboResult.successResult(list);
        }
        catch (Exception e) {
            LOG.error("invoke RemoteCategoryService.saveCategory failed, pid={}, categoryList={}", new Object[]{pid, categoryList, e});
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

