/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.remoteservice.impl;

import cn.com.duiba.wolf.dubbo.DubboResult;
import com.qiho.center.api.dto.DetailRecommendDto;
import com.qiho.center.api.dto.ItemSimpleDto;
import com.qiho.center.api.remoteservice.RemoteDetailRecommendService;
import com.qiho.center.biz.service.DetailRecommendService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemoteDetailRecommendServiceImpl
implements RemoteDetailRecommendService {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteDetailRecommendServiceImpl.class);
    @Autowired
    private DetailRecommendService detailRecommendService;

    public DubboResult<List<DetailRecommendDto>> findByItemId(Long itemId) {
        try {
            return DubboResult.successResult(this.detailRecommendService.findListByItemId(itemId));
        }
        catch (Exception e) {
            LOG.error("invoke RemoteDetailRecommendServiceImpl.findByItemId failed, itemId={}", (Object)itemId, (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<DetailRecommendDto>> queryDetailRecommend(Long itemId) {
        try {
            return DubboResult.successResult(this.detailRecommendService.queryDetailRecommend(itemId));
        }
        catch (Exception e) {
            LOG.error("invoke RemoteDetailRecommendServiceImpl.queryDetailRecommed failed, itemId={}", (Object)itemId, (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> saveDetailRecommend(List<DetailRecommendDto> dtos) {
        try {
            boolean result = this.detailRecommendService.saveDetailRecommend(dtos);
            if (result) {
                return DubboResult.successResult((Object)result);
            }
            return DubboResult.failResult((String)"\u4fdd\u5b58\u5931\u8d25");
        }
        catch (Exception e) {
            LOG.error("invoke RemoteDetailRecommendServiceImpl.saveDetailRecommed failed, dtos={}", dtos, (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<ItemSimpleDto> queryItemDetail(Long itemId) {
        try {
            return DubboResult.successResult((Object)this.detailRecommendService.queryItemDetail(itemId));
        }
        catch (Exception e) {
            LOG.error("invoke RemoteDetailRecommendServiceImpl.queryItemDetail failed, itemId={}", (Object)itemId, (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

