/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.remoteservice.impl;

import cn.com.duiba.wolf.dubbo.DubboResult;
import com.qiho.center.api.dto.ItemAdvertDto;
import com.qiho.center.api.dto.ItemDetailDto;
import com.qiho.center.api.dto.ItemDto;
import com.qiho.center.api.dto.ItemSimpleDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.params.item.ItemPageParams;
import com.qiho.center.api.remoteservice.RemoteItemService;
import com.qiho.center.biz.service.ItemRecommendService;
import com.qiho.center.biz.service.ItemService;
import com.qiho.center.biz.service.SkuPropertyService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemoteItemServiceImpl
implements RemoteItemService {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteItemServiceImpl.class);
    @Autowired
    private ItemService itemService;
    @Autowired
    private ItemRecommendService itemRecommendService;
    @Autowired
    private SkuPropertyService skuPropertyService;

    public DubboResult<PagenationDto<ItemDto>> queryItemPage(ItemDto queryItem, Integer pageNum, Integer pageSize) {
        try {
            PagenationDto<ItemDto> page = this.itemService.queryItemPage(queryItem, pageNum, pageSize);
            return DubboResult.successResult(page);
        }
        catch (Exception e) {
            LOG.error("invoke RemoteItemService.queryItemPage failed, queryItem={}, pageNum={}, pageSize={}", new Object[]{queryItem, pageNum, pageSize, e});
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Long> createItem(ItemDetailDto itemDetail) {
        try {
            Long itemId = this.itemService.createItem(itemDetail);
            return DubboResult.successResult((Object)itemId);
        }
        catch (Exception e) {
            LOG.error("invoke RemoteItemService.createItem failed, itemDetail={}", (Object)itemDetail, (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Void> updateItem(ItemDetailDto itemDetail) {
        try {
            this.itemService.updateItem(itemDetail);
            return DubboResult.successResult(null);
        }
        catch (Exception e) {
            LOG.error("invoke RemoteItemService.updateItem failed, itemDetail={}", (Object)itemDetail, (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<ItemDetailDto> queryItemDetail(Long itemId) {
        try {
            ItemDetailDto itemDetailDto = this.itemService.queryItemDetail(itemId);
            return DubboResult.successResult((Object)itemDetailDto);
        }
        catch (Exception e) {
            LOG.error("invoke RemoteItemService.queryItemDetail failed, itemId={}", (Object)itemId, (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Void> updateStatus(List<Long> itemIds, String status) {
        try {
            this.itemService.updateStatus(itemIds, status);
            return DubboResult.successResult(null);
        }
        catch (Exception e) {
            LOG.error("invoke RemoteItemService.updateStatus failed, itemIds={}, status={}", new Object[]{itemIds, status, e});
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Void> deleteBatch(List<Long> itemIds) {
        try {
            this.itemService.deleteBatch(itemIds);
            return DubboResult.successResult(null);
        }
        catch (Exception e) {
            LOG.error("invoke RemoteItemService.deleteBatch failed, itemIds={}", itemIds, (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<ItemSimpleDto> queryItemSimpleDto(Long itemId) {
        try {
            ItemSimpleDto dto = this.itemService.queryItemSimpleDto(itemId);
            return DubboResult.successResult((Object)dto);
        }
        catch (Exception e) {
            LOG.error("invoke RemoteItemService.queryItemSimpleDto failed, itemId={}", (Object)itemId, (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<ItemSimpleDto>> queryItemSimpleList(ItemDto queryItem) {
        try {
            return DubboResult.successResult(this.itemService.queryItemSimpleList(queryItem));
        }
        catch (Exception e) {
            LOG.error("RemoteItemServiceImpl call queryItemSimpleList error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> updateExtParamByItemId(ItemAdvertDto dto) {
        try {
            this.itemService.updateExtParamByItemId(dto);
            return DubboResult.successResult((Object)Boolean.TRUE);
        }
        catch (Exception e) {
            LOG.error("RemoteItemServiceImpl call updateExtParamByItemId error msg={}", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<ItemAdvertDto> queryExtParamByItemId(Long itemId) {
        try {
            return DubboResult.successResult((Object)this.itemService.queryExtParamByItemId(itemId));
        }
        catch (Exception e) {
            LOG.error("RemoteItemServiceImpl call queryExtParamByItemId error msg={}", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public Long queryItemStockByItemId(Long itemId) {
        return this.itemService.queryItemStockByItemId(itemId);
    }

    public Long updateVirtailStock(Long itemId) {
        return this.itemService.updateVirtailStock(itemId);
    }

    public PagenationDto<ItemDto> queryMerchantItemPage(ItemPageParams params) {
        return this.itemService.queryItemPage(params);
    }
}

