/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.remoteservice.impl;

import cn.com.duiba.wolf.dubbo.DubboResult;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.logistics.LogisticsOrderDto;
import com.qiho.center.api.dto.logistics.LogisticsProcessDto;
import com.qiho.center.api.dto.logistics.QueryLogisticsOrderDto;
import com.qiho.center.api.enums.DeliveryEnum;
import com.qiho.center.api.enums.ErpManufacturerType;
import com.qiho.center.api.enums.LogisticsNameEnum;
import com.qiho.center.api.remoteservice.RemoteLogisticsOrderService;
import com.qiho.center.biz.bo.KuaiDi100Bo;
import com.qiho.center.biz.bo.LogisticsOrderBo;
import com.qiho.center.biz.job.JDLogisticsSyncJob;
import com.qiho.center.biz.service.ConfigService;
import com.qiho.center.biz.service.LogisticsOrderService;
import com.qiho.center.biz.service.logistics.LogisticsQueryDecider;
import com.qiho.center.biz.service.logistics.LogisticsQueryProcessor;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemoteLogisticsOrderServiceImpl
implements RemoteLogisticsOrderService {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteLogisticsOrderServiceImpl.class);
    @Autowired
    private LogisticsOrderService logisticsOrderService;
    @Autowired
    private LogisticsOrderBo logisticsOrderBo;
    @Autowired
    private LogisticsQueryDecider logisticsQueryDecider;
    @Autowired
    JDLogisticsSyncJob jdLogisticsSyncJob;
    @Resource
    private ConfigService configService;
    @Resource
    private KuaiDi100Bo kuaiDi100Bo;

    public DubboResult<PagenationDto<LogisticsOrderDto>> queryLogisticsOrderPage(QueryLogisticsOrderDto queryItem, Integer pageNum, Integer pageSize) {
        try {
            PagenationDto<LogisticsOrderDto> page = this.logisticsOrderService.queryLogisticsOrderPage(queryItem, pageNum, pageSize);
            return DubboResult.successResult(page);
        }
        catch (Exception e) {
            LOG.error("invoke RemoteLogisticsOrderService.queryLogisticsOrderPage failed, queryItem={}, pageNum={}, pageSize={}", new Object[]{queryItem, pageNum, pageSize, e});
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Integer> updateBylogisticsId(String logisticsId, String orderStatus) {
        try {
            return DubboResult.successResult((Object)this.logisticsOrderService.updateBylogisticsId(logisticsId, orderStatus));
        }
        catch (Exception e) {
            LOG.error("invoke RemoteLogisticsOrderService.updateLogisticsOrderStatusBatch failed, logisticsId={}, orderStatus={}", new Object[]{logisticsId, orderStatus, e});
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<LogisticsOrderDto>> findByOrderId(String orderId) {
        try {
            return DubboResult.successResult(this.logisticsOrderService.findByOrderId(orderId));
        }
        catch (Exception e) {
            LOG.error("invoke RemoteLogisticsOrderService.findByOrderId failed, orderId={}", (Object)orderId, (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Integer> updateLogisticsOrderStatus(LogisticsOrderDto logisticsOrderDto) {
        try {
            return DubboResult.successResult((Object)this.logisticsOrderService.update(logisticsOrderDto));
        }
        catch (Exception e) {
            LOG.error("invoke RemoteLogisticsOrderService.updateLogisticsOrderStatus failed, logisticsOrderDto={}", (Object)logisticsOrderDto, (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<LogisticsProcessDto>> queryYTOLogisticsProcessByPostId(String postId) {
        try {
            LogisticsQueryProcessor processor = this.logisticsQueryDecider.decideLogisticsQueryProcessor(LogisticsNameEnum.YTO);
            return DubboResult.successResult(processor.queryWaybillTrace(postId));
        }
        catch (Exception e) {
            LOG.error("invoke RemoteLogisticsOrderService.queryLogisticsProcessByPostId failed, postId={}", (Object)postId, (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<LogisticsProcessDto>> queryWaybillTrace(String logisticsCode, String postId) {
        try {
            String delivery = this.logisticsOrderService.findDeliveryByPostId(postId);
            if (!DeliveryEnum.ERP.getCode().equals(delivery)) {
                return DubboResult.successResult(this.kuaiDi100Bo.queryWaybillTrace(logisticsCode, postId));
            }
            LogisticsQueryProcessor processor = this.logisticsQueryDecider.decideLogisticsQueryProcessor(LogisticsNameEnum.getByCode((String)logisticsCode));
            List<LogisticsProcessDto> list = null;
            if (processor != null) {
                list = processor.queryWaybillTrace(postId);
            }
            return DubboResult.successResult(list);
        }
        catch (Exception e) {
            LOG.error("invoke RemoteLogisticsOrderService.queryWaybillTrace failed, logisticsCode={}, postId={}", new Object[]{logisticsCode, postId, e});
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Integer> batchSignOrder(String progressKey, List<LogisticsOrderDto> paramList) {
        try {
            return DubboResult.successResult((Object)this.logisticsOrderBo.batchSignOrder(progressKey, paramList));
        }
        catch (Exception e) {
            LOG.error("invoke RemoteLogisticsOrderService.batchSignOrder failed, progressKey={}, paramList={}", new Object[]{progressKey, paramList, e});
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> manualErpLogisticsSyncQueryJob() {
        try {
            ErpManufacturerType erpType = this.configService.findErpSwitchesType();
            if (erpType == ErpManufacturerType.EDB) {
                this.logisticsOrderBo.edbErpLogisticsSyncQuery();
            } else {
                this.logisticsOrderBo.erpLogisticsSyncQuery();
            }
            return DubboResult.successResult((Object)true);
        }
        catch (Exception e) {
            LOG.error("invoke RemoteLogisticsOrderService.batchSignOrder failed", (Throwable)e);
            return DubboResult.failResult((String)"\u624b\u52a8\u89e6\u53d1\u5931\u8d25");
        }
    }

    public DubboResult<Void> syncLogisticsStatus(String logisticsOrderStatus) {
        try {
            new Thread(() -> this.logisticsOrderService.syncLogisticsStatus(logisticsOrderStatus)).start();
            return DubboResult.successResult(null);
        }
        catch (Exception e) {
            LOG.error("invoke RemoteLogisticsOrderService.syncLogisticsStatus failed", (Throwable)e);
            return DubboResult.failResult((String)"\u540c\u6b65\u7269\u6d41\u72b6\u6001\u5931\u8d25");
        }
    }

    public int queryDistributeOverTimeNum() {
        return this.logisticsOrderService.queryDistributeOverTimeNum();
    }

    public List<LogisticsOrderDto> queryDistributeOverTimePage(Integer pageNum, Integer pageSize) {
        return this.logisticsOrderService.queryDistributeOverTimePage(pageNum, pageSize);
    }

    public Boolean updateLogisticsOrderRemark(LogisticsOrderDto param) {
        this.logisticsOrderService.updateLogisticsOrderRemark(param);
        return Boolean.TRUE;
    }

    public PagenationDto<LogisticsOrderDto> queryServiceLogisticsOrder(QueryLogisticsOrderDto queryItem, Integer pageNum, Integer pageSize) {
        return this.logisticsOrderService.queryServiceLogisticsOrder(queryItem, pageNum, pageSize);
    }

    public void syncLogisticsOrderStatus() {
        this.jdLogisticsSyncJob.process(null);
    }

    public Boolean dealKuaiDi100Status(String com, String postId, String status, String condition) {
        return this.kuaiDi100Bo.dealKuaiDi100Status(com, postId, status, condition);
    }
}

