/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.remoteservice.impl.agent;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.SimpleIdAndNameDto;
import com.qiho.center.api.dto.agent.BaiqiAgentDto;
import com.qiho.center.api.dto.agent.BaiqiAgentSaveDto;
import com.qiho.center.api.dto.merchant.MerchantSimpleDto;
import com.qiho.center.api.enums.account.BaiqiAccountTypeEnum;
import com.qiho.center.api.params.PageQueryParams;
import com.qiho.center.api.remoteservice.agent.RemoteBaiqiAgentBackendService;
import com.qiho.center.biz.service.account.BaiqiAccountService;
import com.qiho.center.biz.service.agent.BaiqiAgentMerchantService;
import com.qiho.center.biz.service.agent.BaiqiAgentService;
import com.qiho.center.biz.service.merchant.MerchantService;
import com.qiho.center.common.entityd.qiho.agent.BaiqiAgentEntity;
import com.qiho.center.common.entityd.qiho.agent.BaiqiAgentMerchantRelationEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemoteBaiqiAgentBackendServiceImpl
implements RemoteBaiqiAgentBackendService {
    @Resource
    private BaiqiAgentService baiqiAgentService;
    @Resource
    private BaiqiAccountService baiqiAccountService;
    @Resource
    private BaiqiAgentMerchantService baiqiAgentMerchantService;
    @Resource
    private MerchantService merchantService;

    public List<SimpleIdAndNameDto> findAgentSimple() {
        return this.baiqiAgentService.findSimpleAll();
    }

    public List<SimpleIdAndNameDto> findAgentIdAndName() {
        List<BaiqiAgentEntity> agentEntities = this.baiqiAgentService.findAll();
        if (CollectionUtils.isEmpty(agentEntities)) {
            return Collections.emptyList();
        }
        List<Long> relationIds = this.baiqiAccountService.findRelationIdsByAccountType(BaiqiAccountTypeEnum.AGENT_ACCOUNT.getCode());
        ArrayList<SimpleIdAndNameDto> idAndNameDtos = new ArrayList<SimpleIdAndNameDto>();
        for (BaiqiAgentEntity entity : agentEntities) {
            Long id = entity.getId();
            if (relationIds.contains(id)) continue;
            SimpleIdAndNameDto dto = new SimpleIdAndNameDto();
            dto.setId(id);
            dto.setName(entity.getAgentName());
            idAndNameDtos.add(dto);
        }
        return idAndNameDtos;
    }

    public PagenationDto<BaiqiAgentDto> find4Page(PageQueryParams params) {
        return this.baiqiAgentService.find4Page(params);
    }

    public Boolean save(BaiqiAgentSaveDto agentSaveDto) {
        if (agentSaveDto.getId() == null) {
            this.insert(agentSaveDto);
        } else {
            this.update(agentSaveDto);
        }
        return true;
    }

    private void insert(BaiqiAgentSaveDto agentSaveDto) {
        BaiqiAgentEntity entity = (BaiqiAgentEntity)BeanUtils.copy((Object)agentSaveDto, BaiqiAgentEntity.class);
        this.baiqiAgentService.insert(entity);
        List merchantIds = agentSaveDto.getMerchantIds();
        this.insertAgentMerchant(merchantIds, entity.getId());
    }

    private void update(BaiqiAgentSaveDto agentSaveDto) {
        this.baiqiAgentService.update((BaiqiAgentDto)agentSaveDto);
        List merchantIds = agentSaveDto.getMerchantIds();
        this.insertAgentMerchant(merchantIds, agentSaveDto.getId());
    }

    private List<Long> removeAll(List<Long> merchantIds, List<Long> existMerchantIds) {
        ArrayList<Long> list = new ArrayList<Long>();
        for (Long merchantId : merchantIds) {
            if (existMerchantIds.contains(merchantId)) continue;
            list.add(merchantId);
        }
        return list;
    }

    private void insertAgentMerchant(List<Long> merchantIds, Long agentId) {
        List<Long> existMerchantIds;
        List<Long> insertMerchantIds;
        if (CollectionUtils.isNotEmpty(merchantIds) && CollectionUtils.isNotEmpty(insertMerchantIds = CollectionUtils.isNotEmpty(existMerchantIds = this.baiqiAgentMerchantService.findAllMerchantIds()) ? this.removeAll(merchantIds, existMerchantIds) : merchantIds)) {
            ArrayList<BaiqiAgentMerchantRelationEntity> list = new ArrayList<BaiqiAgentMerchantRelationEntity>();
            for (Long id : insertMerchantIds) {
                BaiqiAgentMerchantRelationEntity entity = new BaiqiAgentMerchantRelationEntity();
                entity.setAgentId(agentId);
                entity.setMerchantId(id);
                list.add(entity);
            }
            this.baiqiAgentMerchantService.batchInsert(list);
        }
    }

    public List<MerchantSimpleDto> findAllIdAndNames() {
        List<Long> merchantIds = this.baiqiAgentMerchantService.findAllMerchantIds();
        List<MerchantSimpleDto> merchantSimpleDtos = this.merchantService.findAllIdAndNames();
        if (CollectionUtils.isEmpty(merchantSimpleDtos)) {
            return Collections.emptyList();
        }
        ArrayList<MerchantSimpleDto> list = new ArrayList<MerchantSimpleDto>();
        for (MerchantSimpleDto simpleDto : merchantSimpleDtos) {
            if (merchantIds.contains(simpleDto.getId())) continue;
            list.add(simpleDto);
        }
        return list;
    }

    public List<MerchantSimpleDto> findMerchantsByAgentId(Long agentId) {
        List<Long> merchantIds = this.baiqiAgentMerchantService.findExistMerchantIds(agentId);
        if (CollectionUtils.isEmpty(merchantIds)) {
            return Collections.emptyList();
        }
        return this.merchantService.findIdAndNamesByIds(merchantIds);
    }

    public List<BaiqiAgentDto> findAll() {
        return BeanUtils.copyList(this.baiqiAgentService.findAll(), BaiqiAgentDto.class);
    }
}

