/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.remoteservice.impl.campaign;

import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.fastjson.JSON;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.campaign.ChannelDto;
import com.qiho.center.api.dto.campaign.MediaPlanDto;
import com.qiho.center.api.enums.ResultErrorEnum;
import com.qiho.center.api.params.ChannelParams;
import com.qiho.center.api.params.MediaPlanParams;
import com.qiho.center.api.remoteservice.campaign.RemoteChannelService;
import com.qiho.center.biz.service.ChannelService;
import com.qiho.center.biz.service.MediaPlanService;
import java.util.Collection;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemoteChannelServiceImpl
implements RemoteChannelService {
    private static final Logger logger = LoggerFactory.getLogger(RemoteChannelServiceImpl.class);
    @Resource
    private ChannelService channelService;
    @Resource
    private MediaPlanService mediaPlanService;

    public DubboResult<PagenationDto<ChannelDto>> queryChannelByPage(ChannelParams params, Integer pageNum, Integer pageSize) {
        if (null == params) {
            return DubboResult.failResult((String)ResultErrorEnum.PARAMS_ERROR.getMessage());
        }
        try {
            PagenationDto<ChannelDto> pagenationDto = this.channelService.findByQuery(params, pageNum, pageSize);
            return DubboResult.successResult(pagenationDto);
        }
        catch (Exception e) {
            logger.error("\u6e20\u9053\u5206\u9875\u67e5\u8be2\u5f02\u5e38 params={}", (Object)params.toString(), (Object)e);
            return DubboResult.failResult((String)ResultErrorEnum.SERVICE_ERROR.getMessage());
        }
    }

    public DubboResult<Boolean> deleteChannelById(Long id) {
        if (null == id || id < 0L) {
            return DubboResult.failResult((String)ResultErrorEnum.PARAMS_ERROR.getMessage());
        }
        try {
            ChannelDto resultDto = this.channelService.findById(id);
            if (null == resultDto) {
                return DubboResult.failResult((String)"\u9700\u8981\u5220\u9664\u7684\u6e20\u9053\u4e0d\u5b58\u5728");
            }
            Integer resultIte = this.channelService.deleteChannelById(id);
            if (null != resultIte && resultIte > 0) {
                MediaPlanParams planParams = new MediaPlanParams();
                planParams.setChannelId(id);
                PagenationDto<MediaPlanDto> mediaPlanDtos = this.mediaPlanService.findByQuery(planParams, null, null);
                if (!CollectionUtils.isEmpty((Collection)mediaPlanDtos.getList())) {
                    mediaPlanDtos.getList().stream().forEach(e -> this.mediaPlanService.deleteMediaById(e.getId()));
                }
                return DubboResult.successResult((Object)Boolean.TRUE);
            }
            return DubboResult.failResult((String)ResultErrorEnum.RESULT_ERROR.getMessage());
        }
        catch (Exception e2) {
            logger.error("\u901a\u8fc7id\u5220\u9664\u6e20\u9053\u5931\u8d25 id={}", (Object)id, (Object)e2);
            return DubboResult.failResult((String)ResultErrorEnum.SERVICE_ERROR.getMessage());
        }
    }

    public DubboResult<Boolean> updateChannelByParam(ChannelDto channelDto) {
        if (null == channelDto || null == channelDto.getId() || StringUtils.isBlank((CharSequence)channelDto.getChannelName())) {
            return DubboResult.failResult((String)ResultErrorEnum.PARAMS_ERROR.getMessage());
        }
        try {
            ChannelDto resultDto = this.channelService.findById(channelDto.getId());
            if (null == resultDto) {
                return DubboResult.failResult((String)"\u9700\u8981\u66f4\u65b0\u7684\u6e20\u9053\u4e0d\u5b58\u5728");
            }
            if (this.checkNameRepeat(channelDto).booleanValue()) {
                return DubboResult.failResult((String)"\u6e20\u9053\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
            }
            Integer resultBase = this.channelService.updateChannel(channelDto);
            if (null != resultBase && resultBase > 0) {
                MediaPlanDto mediaPlanDto = new MediaPlanDto();
                mediaPlanDto.setChannelId(channelDto.getId());
                mediaPlanDto.setChannelName(channelDto.getChannelName());
                this.mediaPlanService.updateMediaPlanByChannelId(mediaPlanDto);
                return DubboResult.successResult((Object)Boolean.TRUE);
            }
            return DubboResult.failResult((String)ResultErrorEnum.RESULT_ERROR.getMessage());
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u6e20\u9053\u4fe1\u606f\u5931\u8d25 channelDto={}", (Object)channelDto.getId(), (Object)e);
            return DubboResult.failResult((String)ResultErrorEnum.SERVICE_ERROR.getMessage());
        }
    }

    public DubboResult<Integer> insertChannel(ChannelDto channelDto) {
        if (this.valuteParamsNull(channelDto).booleanValue()) {
            return DubboResult.failResult((String)ResultErrorEnum.PARAMS_ERROR.getMessage());
        }
        if (this.checkNameRepeat(channelDto).booleanValue()) {
            return DubboResult.failResult((String)"\u6e20\u9053\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
        }
        try {
            Integer channelId = this.channelService.insertChannel(channelDto);
            if (null != channelId || channelId > 0) {
                return DubboResult.successResult((Object)channelId);
            }
            return DubboResult.failResult((String)ResultErrorEnum.RESULT_ERROR.getMessage());
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u6e20\u9053\u4fe1\u606f\u5931\u8d25 channelDto={}", (Object)channelDto.getChannelName(), (Object)e);
            return DubboResult.failResult((String)ResultErrorEnum.SERVICE_ERROR.getMessage());
        }
    }

    public DubboResult<Integer> countByParam(ChannelParams params) {
        if (null == params) {
            return DubboResult.failResult((String)"\u67e5\u8be2\u6761\u4ef6\u53c2\u6570\u4e3a\u7a7a");
        }
        try {
            Integer total = this.channelService.countChannelByQuery(params);
            return DubboResult.successResult((Object)total);
        }
        catch (Exception e) {
            logger.error("\u6761\u4ef6\u67e5\u8be2\u8bb0\u5f55\u6570error, params={}", (Object)JSON.toJSONString((Object)params), (Object)e);
            return DubboResult.failResult((String)"\u6761\u4ef6\u67e5\u8be2\u8bb0\u5f55\u6570error");
        }
    }

    private Boolean valuteParamsNull(ChannelDto channelDto) {
        if (null == channelDto) {
            return Boolean.TRUE;
        }
        if (null != channelDto.getId() && channelDto.getId() > 0L) {
            return Boolean.TRUE;
        }
        if (StringUtils.isBlank((CharSequence)channelDto.getChannelName()) || StringUtils.isBlank((CharSequence)channelDto.getCreator())) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private Boolean checkNameRepeat(ChannelDto channelDto) {
        ChannelParams channelParams = new ChannelParams();
        channelParams.setChannelName(channelDto.getChannelName());
        PagenationDto<ChannelDto> channelResult = this.channelService.findByQuery(channelParams, null, null);
        if (CollectionUtils.isEmpty((Collection)channelResult.getList())) {
            return Boolean.FALSE;
        }
        Long resultCopy = channelResult.getList().stream().filter(e -> channelDto.getChannelName().equals(e.getChannelName())).count();
        if (resultCopy <= 0L) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

