/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.remoteservice.impl.merchant;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.SimpleIdAndNameDto;
import com.qiho.center.api.dto.merchant.MerchantDto;
import com.qiho.center.api.dto.merchant.MerchantSimpleDto;
import com.qiho.center.api.dto.merchant.MerchantSpacialDto;
import com.qiho.center.api.enums.account.BaiqiAccountTypeEnum;
import com.qiho.center.api.params.MerchantQueryParams;
import com.qiho.center.api.remoteservice.merchant.RemoteMerchantService;
import com.qiho.center.biz.service.account.BaiqiAccountService;
import com.qiho.center.biz.service.merchant.MerchantService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemoteMerchantServiceImpl
implements RemoteMerchantService {
    @Autowired
    private MerchantService merchantService;
    @Autowired
    private BaiqiAccountService baiqiAccountService;

    public MerchantDto findById(Long merchantId) {
        return this.merchantService.findById(merchantId);
    }

    public Boolean saveMerchant(MerchantDto dto) {
        return this.merchantService.saveMerchant(dto);
    }

    public PagenationDto<MerchantDto> querypage(MerchantQueryParams params) {
        return this.merchantService.queryPage(params);
    }

    public List<MerchantDto> findListByName(String name) {
        return this.merchantService.findByName(name);
    }

    public MerchantDto findByItemId(Long itemId) {
        return this.merchantService.findByItemId(itemId);
    }

    public List<SimpleIdAndNameDto> findAllMerchantSimple() {
        List<MerchantSimpleDto> merchantSimpleDtos = this.merchantService.findAllIdAndNames();
        if (CollectionUtils.isEmpty(merchantSimpleDtos)) {
            return Collections.emptyList();
        }
        ArrayList<SimpleIdAndNameDto> idAndNameDtos = new ArrayList<SimpleIdAndNameDto>(merchantSimpleDtos.size());
        for (MerchantSimpleDto simpleDto : merchantSimpleDtos) {
            SimpleIdAndNameDto idAndNameDto = new SimpleIdAndNameDto();
            idAndNameDto.setId(simpleDto.getId());
            idAndNameDto.setName(simpleDto.getMerchantName());
            idAndNameDtos.add(idAndNameDto);
        }
        return idAndNameDtos;
    }

    public List<SimpleIdAndNameDto> findAllIdAndNames() {
        List<Long> merchantIds = this.baiqiAccountService.findRelationIdsByAccountType(BaiqiAccountTypeEnum.MAIN_ACCOUNT.getCode());
        List<MerchantSimpleDto> merchantSimpleDtos = this.merchantService.findAllIdAndNames();
        if (CollectionUtils.isEmpty(merchantSimpleDtos)) {
            return Collections.emptyList();
        }
        ArrayList<SimpleIdAndNameDto> filterDtos = new ArrayList<SimpleIdAndNameDto>();
        for (MerchantSimpleDto simpleDto : merchantSimpleDtos) {
            if (merchantIds.contains(simpleDto.getId())) continue;
            SimpleIdAndNameDto simple = new SimpleIdAndNameDto();
            simple.setId(simpleDto.getId());
            simple.setName(simpleDto.getMerchantName());
            filterDtos.add(simple);
        }
        return filterDtos;
    }

    public List<MerchantSpacialDto> findAll() {
        return BeanUtils.copyList(this.merchantService.findAll(), MerchantSpacialDto.class);
    }
}

