/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.remoteservice.impl.order;

import cn.com.duiba.wolf.dubbo.DubboResult;
import com.qiho.center.api.dto.AnticheateDto;
import com.qiho.center.api.remoteservice.order.RemoteAnticheateService;
import com.qiho.center.biz.engine.impl.AheadPreventOrderEngine;
import com.qiho.center.biz.service.order.AnticheateService;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemoteAnticheateServiceImpl
implements RemoteAnticheateService {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteAnticheateServiceImpl.class);
    @Autowired
    private AnticheateService anticheateService;
    @Resource
    private AheadPreventOrderEngine aheadPreventOrderEngine;

    public DubboResult<AnticheateDto> findByOrderId(String orderId) {
        try {
            AnticheateDto anticheateDto = this.anticheateService.findByOrderId(orderId);
            return DubboResult.successResult((Object)anticheateDto);
        }
        catch (Exception e) {
            LOG.error("invoke RemoteAnticheateService.findByOrderId failed,orderId={}", (Object)orderId, (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<AnticheateDto>> findByOrderIds(List<String> orderIds) {
        try {
            List<AnticheateDto> anticheateEntities = this.anticheateService.findByOrderIds(orderIds);
            return DubboResult.successResult(anticheateEntities);
        }
        catch (Exception e) {
            LOG.error("invoke RemoteAnticheateService.findByOrderIds failed,orderIds={}", orderIds, (Object)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

