/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.remoteservice.impl.order;

import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.fastjson.JSON;
import com.qiho.center.api.dto.OrderStrategyDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.enums.ChannelStatusEnum;
import com.qiho.center.api.enums.ResultErrorEnum;
import com.qiho.center.api.params.OrderStrategyParams;
import com.qiho.center.api.remoteservice.order.RemoteOrderStrategyService;
import com.qiho.center.biz.service.order.OrderStrategyService;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemoteOrderStrategyServiceImpl
implements RemoteOrderStrategyService {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private OrderStrategyService orderStrategyService;

    public DubboResult<PagenationDto<OrderStrategyDto>> queryStrategyByPage(OrderStrategyParams params, Integer pageNum, Integer pageSize) {
        if (null == params) {
            return DubboResult.failResult((String)ResultErrorEnum.PARAMS_ERROR.getMessage());
        }
        ArrayList<OrderStrategyDto> resultBase = new ArrayList<OrderStrategyDto>();
        PagenationDto<OrderStrategyDto> pagenationDto = new PagenationDto<OrderStrategyDto>();
        try {
            if (null != params.getId()) {
                OrderStrategyDto orderStrategyDto = this.orderStrategyService.findStrategyById(params.getId());
                if (null != orderStrategyDto) {
                    resultBase.add(orderStrategyDto);
                    pagenationDto.setList(resultBase);
                    pagenationDto.setTotal(Integer.valueOf(resultBase.size()));
                }
            } else {
                pagenationDto = this.orderStrategyService.findStrategyByQuery(params, pageNum, pageSize);
            }
            return DubboResult.successResult(pagenationDto);
        }
        catch (Exception e) {
            this.logger.error("\u8e22\u5355\u7b56\u7565\u67e5\u8be2\u5f02\u5e38 params={} msg={}", (Object)params.toString(), (Object)e.getLocalizedMessage());
            return DubboResult.failResult((String)ResultErrorEnum.SERVICE_ERROR.getMessage());
        }
    }

    public DubboResult<Boolean> deleteStrategyById(Long id) {
        if (null == id || id < 0L) {
            return DubboResult.failResult((String)ResultErrorEnum.PARAMS_ERROR.getMessage());
        }
        try {
            OrderStrategyDto resultDto = this.orderStrategyService.findStrategyById(id);
            if (null == resultDto) {
                return DubboResult.failResult((String)(ResultErrorEnum.RESULT_NULL.getMessage() + "\u9700\u66f4\u5220\u9664\u7684\u8bb0\u5f55\u4e3a\u7a7a"));
            }
            Integer resultIte = this.orderStrategyService.deleteStrategyById(id);
            if (null != resultIte && resultIte > 0) {
                return DubboResult.successResult((Object)Boolean.TRUE);
            }
            return DubboResult.failResult((String)ResultErrorEnum.RESULT_ERROR.getMessage());
        }
        catch (Exception e) {
            this.logger.error("\u901a\u8fc7id\u5220\u9664\u5a92\u4f53\u8ba1\u5212\u5931\u8d25 id={}", (Object)id, (Object)e);
            return DubboResult.failResult((String)ResultErrorEnum.SERVICE_ERROR.getMessage());
        }
    }

    public DubboResult<Boolean> updateStrategyByParam(OrderStrategyDto orderStrategyDto) {
        if (null == orderStrategyDto || null == orderStrategyDto.getId() || StringUtils.isBlank((CharSequence)orderStrategyDto.getStrategyName())) {
            return DubboResult.failResult((String)ResultErrorEnum.PARAMS_ERROR.getMessage());
        }
        try {
            OrderStrategyDto resultDto = this.orderStrategyService.findStrategyById(orderStrategyDto.getId());
            if (null == resultDto) {
                return DubboResult.failResult((String)(ResultErrorEnum.RESULT_NULL.getMessage() + "\u9700\u66f4\u65b0\u6570\u636e\u4e3a\u7a7a"));
            }
            Integer resultBase = this.orderStrategyService.updateStrategy(orderStrategyDto);
            if (null != resultBase && resultBase > 0) {
                return DubboResult.successResult((Object)Boolean.TRUE);
            }
            return DubboResult.failResult((String)ResultErrorEnum.RESULT_ERROR.getMessage());
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0\u7b56\u7565\u4fe1\u606f\u5931\u8d25 orderStrategyDto={}", (Object)JSON.toJSONString((Object)orderStrategyDto), (Object)e);
            return DubboResult.failResult((String)ResultErrorEnum.SERVICE_ERROR.getMessage());
        }
    }

    public DubboResult<Integer> insertStrategy(OrderStrategyDto orderStrategyDto) {
        if (!this.valuteParams(orderStrategyDto).booleanValue()) {
            return DubboResult.failResult((String)ResultErrorEnum.PARAMS_ERROR.getMessage());
        }
        try {
            Integer strategyId;
            if (null == orderStrategyDto.getStatus()) {
                orderStrategyDto.setStatus(Integer.valueOf(ChannelStatusEnum.ONLINE.getCode()));
            }
            if (null != (strategyId = this.orderStrategyService.insertStrategy(orderStrategyDto)) || strategyId > 0) {
                return DubboResult.successResult((Object)strategyId);
            }
            return DubboResult.failResult((String)ResultErrorEnum.RESULT_ERROR.getMessage());
        }
        catch (Exception e) {
            this.logger.error("\u65b0\u589e\u7b56\u7565\u4fe1\u606f\u5931\u8d25 orderStrategyDto={}", (Object)JSON.toJSONString((Object)orderStrategyDto), (Object)e);
            return DubboResult.failResult((String)ResultErrorEnum.SERVICE_ERROR.getMessage());
        }
    }

    public DubboResult<Integer> countByParam(OrderStrategyParams params) {
        if (null == params) {
            return DubboResult.failResult((String)"\u67e5\u8be2\u6761\u4ef6\u53c2\u6570\u4e3a\u7a7a");
        }
        try {
            Integer total = this.orderStrategyService.countStrategyByQuery(params);
            return DubboResult.successResult((Object)total);
        }
        catch (Exception e) {
            this.logger.error("\u6761\u4ef6\u67e5\u8be2\u8bb0\u5f55\u6570error,params={}", (Object)JSON.toJSONString((Object)params), (Object)e);
            return DubboResult.failResult((String)"\u6761\u4ef6\u67e5\u8be2\u8bb0\u5f55\u6570error");
        }
    }

    private Boolean valuteParams(OrderStrategyDto orderStrategyDto) {
        if (null == orderStrategyDto) {
            return Boolean.FALSE;
        }
        if (null == orderStrategyDto.getHandlerName()) {
            return Boolean.FALSE;
        }
        if (StringUtils.isBlank((CharSequence)orderStrategyDto.getStrategyName()) || StringUtils.isBlank((CharSequence)orderStrategyDto.getCreator())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

