/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.runnable;

import com.google.common.collect.Lists;
import com.qiho.center.api.enums.ErpStatusEnum;
import com.qiho.center.api.enums.LogisticsOrderStatusEnum;
import com.qiho.center.api.enums.QihoExpressEnum;
import com.qiho.center.api.enums.WdtImportLogisticsNameEnum;
import com.qiho.center.api.enums.YTOLogisticsStatusEnum;
import com.qiho.center.api.params.WdtOrderAuditParams;
import com.qiho.center.biz.bo.KuaiDi100Bo;
import com.qiho.center.biz.service.LogisticsOrderService;
import com.qiho.center.biz.service.order.ErpOrderService;
import com.qiho.center.biz.service.order.OrderService;
import com.qiho.center.common.dao.QihoErpOrderDAO;
import com.qiho.center.common.dao.QihoItemMerchantDAO;
import com.qiho.center.common.dao.QihoLogisticsOrderDAO;
import com.qiho.center.common.dao.QihoOrderSnapshotDAO;
import com.qiho.center.common.entity.logistics.LogisticsOrderEntity;
import com.qiho.center.common.entity.order.QihoErpOrderEntity;
import com.qiho.center.common.entity.order.QihoOrderSnapshotEntity;
import com.qiho.center.common.enums.SeqBizTypeEnum;
import com.qiho.center.common.support.SequenceNoBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class WdtAuditOrderRunnable
implements Runnable {
    private Logger logger = LoggerFactory.getLogger(WdtAuditOrderRunnable.class);
    @Autowired
    private OrderService orderService;
    @Resource(name="stringRedisTemplate")
    private StringRedisTemplate redisTemplate;
    private List<WdtOrderAuditParams> params = Lists.newArrayList();
    private BoundHashOperations<String, String, Object> ops;
    @Autowired
    LogisticsOrderService logisticsOrderService;
    @Autowired
    private QihoLogisticsOrderDAO qihoLogisticsOrderDAO;
    @Autowired
    private SequenceNoBuilder builder;
    @Autowired
    private QihoErpOrderDAO qihoErpOrderDAO;
    @Autowired
    private ErpOrderService erpOrderService;
    @Autowired
    private QihoItemMerchantDAO qihoItemMerchantDAO;
    @Autowired
    private QihoOrderSnapshotDAO qihoOrderSnapshotDAO;
    @Autowired
    KuaiDi100Bo kuaiDi100Bo;
    public String numAndLetterRegEx = "^[A-Za-z0-9]{1,40}$";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.initOps();
        StringBuilder failMsg = new StringBuilder();
        long updateCount = 0L;
        long failCount = 0L;
        long deliveryCount = 0L;
        try {
            for (int i = 0; i < this.params.size(); ++i) {
                int rowNum = i + 1;
                WdtOrderAuditParams param = this.params.get(i);
                try {
                    boolean checkFlag = this.checkParam(param);
                    if (!checkFlag) {
                        ++failCount;
                        failMsg.append(rowNum).append(",");
                        continue;
                    }
                    int result = this.auditOrder(param);
                    if (result == 1) {
                        ++failCount;
                        failMsg.append(rowNum).append(",");
                    }
                    if (result == 0) {
                        ++updateCount;
                    }
                    if (result != 2) continue;
                    ++deliveryCount;
                    continue;
                }
                catch (Exception e) {
                    ++failCount;
                    failMsg.append(rowNum).append(",");
                    this.logger.error("\u65fa\u5e97\u901a\u8ba2\u5355\u5ba1\u6838\u5931\u8d25", (Throwable)e);
                    continue;
                }
                finally {
                    this.ops.increment((Object)"successCount", 1L);
                }
            }
        }
        finally {
            if (failMsg.length() > 0) {
                this.ops.put((Object)"failMsg", (Object)failMsg.substring(0, failMsg.lastIndexOf(",")));
            }
            this.ops.increment((Object)"deliveryCount", deliveryCount);
            this.ops.increment((Object)"updateCount", updateCount);
            this.ops.increment((Object)"failCount", failCount);
            this.ops.increment((Object)"taskCount", -1L);
        }
    }

    private void initOps() {
        this.ops.increment((Object)"deliveryCount", 0L);
        this.ops.increment((Object)"updateCount", 0L);
        this.ops.increment((Object)"failCount", 0L);
    }

    public boolean checkParam(WdtOrderAuditParams param) {
        int count;
        Pattern pat = Pattern.compile(this.numAndLetterRegEx, 2);
        Matcher matcher = pat.matcher(param.getPostId().trim());
        boolean rs = matcher.matches();
        if (!rs) {
            return false;
        }
        if (StringUtils.isBlank((String)param.getPostId()) || StringUtils.isBlank((String)param.getErpId()) || StringUtils.isBlank((String)param.getLogisticsName())) {
            return false;
        }
        if (StringUtils.isNotBlank((String)param.getMerchantId()) && (count = this.qihoItemMerchantDAO.findErpOrderMerchant(param.getErpId(), param.getMerchantId()).intValue()) < 0) {
            return false;
        }
        QihoErpOrderEntity erpOrderEntity = this.qihoErpOrderDAO.findByErpId(param.getErpId());
        return erpOrderEntity != null;
    }

    private int auditOrder(WdtOrderAuditParams param) {
        LogisticsOrderEntity logisticsOrderEntity = this.qihoLogisticsOrderDAO.findByErpId(param.getErpId());
        if (logisticsOrderEntity != null) {
            LogisticsOrderEntity entity = new LogisticsOrderEntity();
            WdtImportLogisticsNameEnum nameEnum = WdtImportLogisticsNameEnum.getByName((String)param.getLogisticsName());
            if (nameEnum == null) {
                return 1;
            }
            QihoExpressEnum qihoExpressEnum = QihoExpressEnum.getByCode((String)nameEnum.getCode());
            entity.setLogisticsCode(qihoExpressEnum.getCode());
            entity.setLogisticsName(qihoExpressEnum.getName());
            entity.setPostId(param.getPostId());
            entity.setErpId(param.getErpId());
            QihoOrderSnapshotEntity orderSnapshot = new QihoOrderSnapshotEntity();
            orderSnapshot.setPostId(param.getPostId());
            orderSnapshot.setLogisticsName(qihoExpressEnum.getName());
            orderSnapshot.setLogisticsCode(qihoExpressEnum.getCode());
            orderSnapshot.setOrderId(logisticsOrderEntity.getOrderId());
            int result = this.qihoLogisticsOrderDAO.updateLogistics(entity);
            this.qihoOrderSnapshotDAO.updateByOrderId(orderSnapshot);
            if (result > 0) {
                ArrayList list = Lists.newArrayList();
                LogisticsOrderEntity logisticsOrderEntity1 = new LogisticsOrderEntity();
                logisticsOrderEntity1.setLogisticsCode(nameEnum.getCode());
                logisticsOrderEntity1.setPostId(param.getPostId());
                list.add(logisticsOrderEntity1);
                this.kuaiDi100Bo.dealpostOrder(list);
                return 0;
            }
            return 1;
        }
        QihoErpOrderEntity erpOrderEntity = this.qihoErpOrderDAO.findByErpId(param.getErpId());
        LogisticsOrderEntity entity = this.getLogisticsEntity(param, erpOrderEntity);
        if (entity == null) {
            return 1;
        }
        this.erpOrderService.updateErpStatus(entity.getErpId(), ErpStatusEnum.SUCCESS, ErpStatusEnum.TO_NOTIFY, null);
        this.logisticsOrderService.createLogisticsOrder(entity);
        return 2;
    }

    private LogisticsOrderEntity getLogisticsEntity(WdtOrderAuditParams wdtOrderAuditParam, QihoErpOrderEntity erpOrder) {
        LogisticsOrderEntity entity = new LogisticsOrderEntity();
        entity.setErpId(wdtOrderAuditParam.getErpId());
        String postId = wdtOrderAuditParam.getPostId();
        int num = postId.indexOf(44);
        if (num > -1) {
            wdtOrderAuditParam.setPostId(postId.substring(0, num).trim());
        } else {
            entity.setPostId(postId.trim());
        }
        WdtImportLogisticsNameEnum nameEnum = WdtImportLogisticsNameEnum.getByName((String)wdtOrderAuditParam.getLogisticsName());
        if (nameEnum == null) {
            return null;
        }
        QihoExpressEnum qihoExpressEnum = QihoExpressEnum.getByCode((String)nameEnum.getCode());
        entity.setLogisticsCode(qihoExpressEnum.getCode());
        entity.setLogisticsName(qihoExpressEnum.getName());
        entity.setLogisticsStatus(YTOLogisticsStatusEnum.ACCEPT.getDesc());
        entity.setOrderStatus(LogisticsOrderStatusEnum.ACCEPT.getCode());
        entity.setConsumerName(erpOrder.getConsumerName());
        entity.setItemId(erpOrder.getItemId());
        entity.setItemName(erpOrder.getItemName());
        entity.setItemNo(erpOrder.getItemNo());
        entity.setLogisticsId(this.builder.createSeqNo(SeqBizTypeEnum.LOGISTICS, erpOrder.getItemId()));
        entity.setMobile(erpOrder.getMobile());
        entity.setOrderId(erpOrder.getOrderId());
        entity.setSkuNo(erpOrder.getSkuNo());
        entity.setProvince(erpOrder.getProvince());
        return entity;
    }

    public void setProgressKey(String progressKey) {
        this.ops = this.redisTemplate.boundHashOps((Object)progressKey);
    }

    public void setParams(List<WdtOrderAuditParams> params) {
        this.params.addAll(params);
    }
}

