/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.runnable;

import cn.com.duiba.wolf.utils.DateUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.biz.service.order.SmsService;
import com.qiho.center.common.dao.QihoTemplateDAO;
import com.qiho.center.common.entity.QihoTemplateEntity;
import com.qiho.center.common.enums.SmsTemplateEnum;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class YunPianNoteSendRunnable
implements Callable<Boolean> {
    private static final Logger LOGGER = LoggerFactory.getLogger(YunPianNoteSendRunnable.class);
    private List<OrderSnapshotDto> orderSnapshotDtos;
    private QihoTemplateEntity noteTemplate;
    @Resource
    private SmsService smsService;
    @Resource
    private QihoTemplateDAO qihoTemplateDAO;

    @PostConstruct
    public void init() {
        QihoTemplateEntity template = this.qihoTemplateDAO.findByCode(SmsTemplateEnum.NOTE_GAIN.getCode());
        if (template.getTemplateEnable().booleanValue()) {
            this.noteTemplate = template;
        }
    }

    @Override
    public Boolean call() throws Exception {
        if (CollectionUtils.isEmpty(this.orderSnapshotDtos) || null == this.noteTemplate) {
            return Boolean.FALSE;
        }
        try {
            for (OrderSnapshotDto orderSnapshotDto : this.orderSnapshotDtos) {
                HashMap context = Maps.newHashMap();
                context.put("name", orderSnapshotDto.getConsumerName());
                context.put("create", DateUtils.getSecondStr((Date)orderSnapshotDto.getGmtCreate()));
                context.put("amt", String.valueOf(orderSnapshotDto.getOrderAmt() / 100));
                context.put("itemName", orderSnapshotDto.getItemShortName());
                this.smsService.singleSend(this.noteTemplate, context, orderSnapshotDto.getMobile());
            }
        }
        catch (Exception e) {
            LOGGER.error("\u77ed\u4fe1\u635e\u5355\u53d1\u9001\u77ed\u4fe1\u5f02\u5e38 params={}", this.orderSnapshotDtos, (Object)e);
        }
        return Boolean.TRUE;
    }

    public List<OrderSnapshotDto> getOrderSnapshotDtos() {
        return this.orderSnapshotDtos;
    }

    public void setOrderSnapshotDtos(List<OrderSnapshotDto> orderSnapshotDtos) {
        this.orderSnapshotDtos = orderSnapshotDtos;
    }

    public void setOrderSnapshotDtos(OrderSnapshotDto orderSnapshotDto) {
        this.orderSnapshotDtos = Lists.newArrayList((Object[])new OrderSnapshotDto[]{orderSnapshotDto});
    }

    public QihoTemplateEntity getNoteTemplate() {
        return this.noteTemplate;
    }

    public void setNoteTemplate(QihoTemplateEntity noteTemplate) {
        this.noteTemplate = noteTemplate;
    }
}

