/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.base.Objects;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.qiho.center.api.dto.ExpressBlackListDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.blackList.BlackListDto;
import com.qiho.center.api.dto.blackList.BlacklistCheckDto;
import com.qiho.center.api.enums.BlackListEnum;
import com.qiho.center.api.enums.ExpressCompanyEnum;
import com.qiho.center.api.enums.QueryBlackListTypeEnum;
import com.qiho.center.api.params.BlackListCheckParams;
import com.qiho.center.api.params.BlackListOperationParams;
import com.qiho.center.api.params.BlackListParams;
import com.qiho.center.api.params.ExpressBlackListPageParams;
import com.qiho.center.api.params.PageQueryParams;
import com.qiho.center.biz.service.BlackListService;
import com.qiho.center.common.dao.QihoBlacklistDAO;
import com.qiho.center.common.dao.QihoStrategyBlacklistDAO;
import com.qiho.center.common.entity.QihoBlacklistEntity;
import com.qiho.center.common.params.BlackListPageParams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BlackListServiceImpl
implements BlackListService {
    private static BiMap<ExpressCompanyEnum, BlackListEnum> blackListTypeMap = HashBiMap.create();
    @Autowired
    private QihoBlacklistDAO qihoBlacklistDAO;
    @Autowired
    private QihoStrategyBlacklistDAO qihoStrategyBlacklistDAO;

    @Override
    public PagenationDto<ExpressBlackListDto> findExpressBlackPage(ExpressBlackListPageParams params) {
        PagenationDto page = new PagenationDto();
        BlackListPageParams daoParams = new BlackListPageParams();
        BeanUtils.copy((Object)params, (Object)daoParams);
        daoParams.setIfPage(Boolean.valueOf(true));
        ArrayList bkTypes = Lists.newArrayList();
        if (Objects.equal((Object)ExpressCompanyEnum.ALL, (Object)params.getExpressCompany())) {
            for (BlackListEnum blackEnum : blackListTypeMap.values()) {
                bkTypes.add(blackEnum.getBkType());
            }
        } else {
            bkTypes.add(((BlackListEnum)blackListTypeMap.get((Object)params.getExpressCompany())).getBkType());
        }
        daoParams.setBkTypeList((List)bkTypes);
        if (StringUtils.isNotBlank((String)params.getAddressCode())) {
            daoParams.setBkValue(params.getAddressCode());
        }
        List list = this.qihoBlacklistDAO.findQihoBlacklistPage((PageQueryParams)daoParams);
        Integer total = this.qihoBlacklistDAO.findQihoBlacklistTotal((PageQueryParams)daoParams);
        List returnList = Lists.transform((List)list, entity -> {
            ExpressBlackListDto dto = new ExpressBlackListDto();
            dto.setExpressCompany((ExpressCompanyEnum)blackListTypeMap.inverse().get((Object)BlackListEnum.getEnumByType((String)entity.getBkType())));
            dto.setAddressCode(entity.getBkValue());
            dto.setId(entity.getId());
            dto.setGmtCreate(entity.getGmtCreate());
            return dto;
        });
        page.setTotal(total);
        page.setList(returnList);
        return page;
    }

    @Override
    public Long findOneBlack(ExpressCompanyEnum expressCompany, String addressCode) {
        QihoBlacklistEntity entity = this.qihoBlacklistDAO.findOneBlacklist((BlackListEnum)blackListTypeMap.get((Object)expressCompany), addressCode);
        if (Objects.equal((Object)entity, null)) {
            return null;
        }
        return entity.getId();
    }

    @Override
    public Boolean deleteById(Long id, QueryBlackListTypeEnum type) {
        int ret = 0;
        switch (type) {
            case EXPRESS_COMPANY: 
            case MANUAL_PHONE_NUMBER: 
            case MANUAL_REGION: 
            case ORDER_PHONE_NUMBER: {
                ret = this.qihoBlacklistDAO.deleteBlackList(id);
                break;
            }
            case STRATEGY_PHONE_NUMBER: 
            case STRATEGY_REGION: {
                ret = this.qihoStrategyBlacklistDAO.deleteBlackList(id);
                break;
            }
            default: {
                return false;
            }
        }
        return ret == 1;
    }

    @Override
    public Integer deleteByValue(BlackListOperationParams params) {
        if (StringUtils.isBlank((String)params.getBkValue())) {
            return 0;
        }
        QihoBlacklistEntity entity = new QihoBlacklistEntity();
        BlackListEnum bkType = this.getBkTypeFromQueryType(params.getType());
        if (bkType == null) {
            return 0;
        }
        entity.setBkType(bkType.getBkType());
        entity.setBkValue(params.getBkValue());
        return this.qihoBlacklistDAO.deleteByValue(entity);
    }

    @Override
    public Integer batchAddExpressBlackList(ExpressCompanyEnum expressCompany, Set<String> addressCodes) {
        BlackListEnum blackListEnum = (BlackListEnum)blackListTypeMap.get((Object)expressCompany);
        List list = this.qihoBlacklistDAO.findExistByTypeAndIdSet(blackListEnum, addressCodes);
        HashSet existSet = Sets.newHashSet((Iterable)list);
        return this.qihoBlacklistDAO.batchAddBlackList((BlackListEnum)blackListTypeMap.get((Object)expressCompany), (Set)Sets.difference(addressCodes, (Set)existSet));
    }

    @Override
    public Integer findBlackListCount(BlackListParams params) {
        BlackListPageParams daoParams = new BlackListPageParams();
        BeanUtils.copy((Object)params, (Object)daoParams);
        if (StringUtils.isNotBlank((String)daoParams.getBkValue())) {
            daoParams.setBklength(daoParams.getBkValue().length());
        }
        Integer total = 0;
        BlackListEnum bkType = this.getBkTypeFromQueryType(params.getType());
        if (bkType == null) {
            return 0;
        }
        daoParams.setBkType(bkType.getBkType());
        switch (params.getType()) {
            case MANUAL_PHONE_NUMBER: 
            case MANUAL_REGION: 
            case ORDER_PHONE_NUMBER: {
                total = this.qihoBlacklistDAO.findQihoBlacklistTotal((PageQueryParams)daoParams);
                break;
            }
            case STRATEGY_PHONE_NUMBER: 
            case STRATEGY_REGION: {
                total = this.qihoStrategyBlacklistDAO.findQihoBlacklistTotal((PageQueryParams)daoParams);
                break;
            }
            default: {
                return 0;
            }
        }
        return total;
    }

    @Override
    public PagenationDto<BlackListDto> queryBlackListPage(BlackListParams params) {
        List list;
        PagenationDto page = new PagenationDto();
        BlackListPageParams daoParams = new BlackListPageParams();
        BeanUtils.copy((Object)params, (Object)daoParams);
        if (StringUtils.isNotBlank((String)daoParams.getBkValue())) {
            daoParams.setBklength(daoParams.getBkValue().length());
        }
        Integer total = 0;
        BlackListEnum bkType = this.getBkTypeFromQueryType(params.getType());
        if (bkType == null) {
            return page;
        }
        daoParams.setBkType(bkType.getBkType());
        switch (params.getType()) {
            case MANUAL_PHONE_NUMBER: 
            case MANUAL_REGION: 
            case ORDER_PHONE_NUMBER: {
                list = this.qihoBlacklistDAO.findQihoBlacklistPage((PageQueryParams)daoParams);
                total = this.qihoBlacklistDAO.findQihoBlacklistTotal((PageQueryParams)daoParams);
                break;
            }
            case STRATEGY_PHONE_NUMBER: 
            case STRATEGY_REGION: {
                list = this.qihoStrategyBlacklistDAO.findQihoBlacklistPage((PageQueryParams)daoParams);
                total = this.qihoStrategyBlacklistDAO.findQihoBlacklistTotal((PageQueryParams)daoParams);
                break;
            }
            default: {
                return page;
            }
        }
        List returnList = Lists.transform((List)list, entity -> (BlackListDto)BeanUtils.copy((Object)entity, BlackListDto.class));
        page.setTotal(total);
        page.setList(returnList);
        return page;
    }

    @Override
    public Integer addBlackValue(BlackListOperationParams params) {
        if (StringUtils.isBlank((String)params.getBkValue())) {
            return 0;
        }
        QihoBlacklistEntity entity = new QihoBlacklistEntity();
        BlackListEnum bkType = this.getBkTypeFromQueryType(params.getType());
        if (bkType == null) {
            return 0;
        }
        entity.setBkType(bkType.getBkType());
        entity.setBkValue(params.getBkValue());
        entity.setRemarks(params.getRemarks());
        return this.qihoBlacklistDAO.insert(entity);
    }

    @Override
    public BlackListDto findOneBlacklist(QueryBlackListTypeEnum type, String bkValue) {
        QihoBlacklistEntity entity;
        BlackListEnum bkType = this.getBkTypeFromQueryType(type);
        switch (type) {
            case EXPRESS_COMPANY: 
            case MANUAL_PHONE_NUMBER: 
            case MANUAL_REGION: 
            case ORDER_PHONE_NUMBER: {
                entity = this.qihoBlacklistDAO.findOneBlacklist(bkType, bkValue);
                break;
            }
            default: {
                return null;
            }
        }
        return (BlackListDto)BeanUtils.copy((Object)entity, BlackListDto.class);
    }

    @Override
    public BlackListDto findOneBlacklist(QueryBlackListTypeEnum type, String bkValue, Date curDate) {
        BlackListEnum bkType = this.getBkTypeFromQueryType(type);
        QihoBlacklistEntity entity = this.qihoStrategyBlacklistDAO.findOneBlacklist(bkType, bkValue, curDate);
        return (BlackListDto)BeanUtils.copy((Object)entity, BlackListDto.class);
    }

    @Override
    public BlackListDto findLatestDateByType(QueryBlackListTypeEnum type) {
        BlackListEnum bkType = this.getBkTypeFromQueryType(type);
        QihoBlacklistEntity qihoBlacklistEntity = this.qihoStrategyBlacklistDAO.findLatestDateByType(bkType);
        return (BlackListDto)BeanUtils.copy((Object)qihoBlacklistEntity, BlackListDto.class);
    }

    private BlackListEnum getBkTypeFromQueryType(QueryBlackListTypeEnum type) {
        switch (type) {
            case EXPRESS_COMPANY: {
                return BlackListEnum.YUAN_TONG_COD;
            }
            case EXPRESS_COMPANY_PUTO: {
                return BlackListEnum.YUAN_TONG_PAIED;
            }
            case MANUAL_PHONE_NUMBER: 
            case STRATEGY_PHONE_NUMBER: {
                return BlackListEnum.PHONE_NUMBER;
            }
            case MANUAL_REGION: 
            case STRATEGY_REGION: {
                return BlackListEnum.REGION;
            }
            case ORDER_PHONE_NUMBER: {
                return BlackListEnum.PHONE_ORDER;
            }
        }
        return null;
    }

    @Override
    public BlacklistCheckDto blacklistCheck(BlackListCheckParams params) {
        BlacklistCheckDto dto = new BlacklistCheckDto();
        if (StringUtils.isBlank((String)params.getBkValue()) || CollectionUtils.isEmpty((Collection)params.getCheckTypes())) {
            return dto;
        }
        List list = this.qihoBlacklistDAO.countByType(params.getBkValue(), params.getCheckTypes());
        HashMap bkTypeMap = Maps.newHashMap();
        this.fillMap(bkTypeMap, list);
        QihoBlacklistEntity qihoBlacklistEntity = this.qihoStrategyBlacklistDAO.findLatestDateByType(BlackListEnum.PHONE_NUMBER);
        Date curDate = qihoBlacklistEntity.getCurDate();
        List strategyList = this.qihoStrategyBlacklistDAO.countByType(params.getBkValue(), params.getCheckTypes(), curDate);
        this.fillMap(bkTypeMap, strategyList);
        dto.setBkValue(params.getBkValue());
        dto.setBkTypeMap((Map)bkTypeMap);
        return dto;
    }

    @Override
    public Integer findExpressBlackNum(ExpressBlackListPageParams params) {
        BlackListPageParams daoParams = new BlackListPageParams();
        BeanUtils.copy((Object)params, (Object)daoParams);
        daoParams.setIfPage(Boolean.valueOf(true));
        ArrayList bkTypes = Lists.newArrayList();
        if (Objects.equal((Object)ExpressCompanyEnum.ALL, (Object)params.getExpressCompany())) {
            for (BlackListEnum blackEnum : blackListTypeMap.values()) {
                bkTypes.add(blackEnum.getBkType());
            }
        } else {
            bkTypes.add(((BlackListEnum)blackListTypeMap.get((Object)params.getExpressCompany())).getBkType());
        }
        daoParams.setBkTypeList((List)bkTypes);
        if (StringUtils.isNotBlank((String)params.getAddressCode())) {
            daoParams.setBkValue(params.getAddressCode());
        }
        return this.qihoBlacklistDAO.findQihoBlacklistTotal((PageQueryParams)daoParams);
    }

    private void fillMap(Map<BlackListEnum, Long> bkTypeMap, List<Map<String, Object>> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            for (Map<String, Object> map : list) {
                BlackListEnum bkType = BlackListEnum.getEnumByType((String)((String)map.get("bkType")));
                Long count = (Long)map.get("count");
                Long icount = bkTypeMap.get(bkType);
                if (icount != null) {
                    count = count + icount;
                }
                bkTypeMap.put(bkType, count);
            }
        }
    }

    static {
        blackListTypeMap.put((Object)ExpressCompanyEnum.YTO, (Object)BlackListEnum.YUAN_TONG_COD);
        blackListTypeMap.put((Object)ExpressCompanyEnum.YTO_PAID, (Object)BlackListEnum.YUAN_TONG_PAIED);
    }
}

