/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.campaign.ChannelDto;
import com.qiho.center.api.params.ChannelParams;
import com.qiho.center.biz.service.ChannelService;
import com.qiho.center.common.dao.QihoChannelDAO;
import com.qiho.center.common.entity.campaign.QihoChannelEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ChannelServiceImpl
implements ChannelService {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private QihoChannelDAO qihoChannelDAO;

    @Override
    public ChannelDto findById(Long id) {
        QihoChannelEntity entity = this.qihoChannelDAO.findById(id);
        if (null == entity) {
            return null;
        }
        return (ChannelDto)BeanUtils.copy((Object)entity, ChannelDto.class);
    }

    @Override
    public PagenationDto<ChannelDto> findByQuery(ChannelParams params, Integer pageNum, Integer pageSize) {
        ArrayList channelDtos = new ArrayList();
        PagenationDto resultBase = new PagenationDto();
        List entities = this.qihoChannelDAO.findByQuery(params, pageNum, pageSize);
        if (CollectionUtils.isEmpty((Collection)entities)) {
            return resultBase;
        }
        entities.stream().forEach(e -> channelDtos.add(BeanUtils.copy((Object)e, ChannelDto.class)));
        resultBase.setList(channelDtos);
        Integer channelCount = this.qihoChannelDAO.countByQuery(params);
        resultBase.setTotal(channelCount);
        return resultBase;
    }

    @Override
    @Transactional(value="QIHO")
    public Integer updateChannel(ChannelDto channelDto) {
        return this.qihoChannelDAO.updateByEntity(channelDto);
    }

    @Override
    @Transactional(value="QIHO")
    public Integer deleteChannelById(Long id) {
        return this.qihoChannelDAO.deleteById(id);
    }

    @Override
    @Transactional(value="QIHO")
    public Integer insertChannel(ChannelDto channelDto) {
        Long result = this.qihoChannelDAO.insert(channelDto);
        return result == null ? null : Integer.valueOf(result.toString());
    }

    @Override
    public Integer countChannelByQuery(ChannelParams params) {
        return this.qihoChannelDAO.countByQuery(params);
    }
}

