/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.DetailRecommendDto;
import com.qiho.center.api.dto.DetailRecommendItemDto;
import com.qiho.center.api.dto.ItemDto;
import com.qiho.center.api.dto.ItemSimpleDto;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.biz.service.DetailRecommendService;
import com.qiho.center.biz.service.ItemSaleCountService;
import com.qiho.center.biz.service.ItemService;
import com.qiho.center.common.dao.QihoItemDAO;
import com.qiho.center.common.daoh.qiho.QihoDetailRecommendMapper;
import com.qiho.center.common.entity.item.QihoItemDetailEntity;
import com.qiho.center.common.entityd.qiho.QihoDetailRecommendEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DetailRecommendServiceImpl
implements DetailRecommendService {
    @Autowired
    private QihoDetailRecommendMapper qihoDetailRecommendMapper;
    @Autowired
    private ItemService itemService;
    @Autowired
    private ItemSaleCountService itemSaleCountService;
    @Autowired
    private QihoItemDAO qihoItemDAO;

    @Override
    public List<DetailRecommendDto> findListByItemId(Long itemId) {
        if (itemId == null || itemId <= 0L) {
            throw new QihoException("\u4f20\u5165\u7684itemId\u4e3a\u7a7a\u6216\u5c0f\u4e8e0");
        }
        List dtoList = BeanUtils.copyList((List)this.qihoDetailRecommendMapper.selectByItemId(itemId), DetailRecommendDto.class);
        if (CollectionUtils.isEmpty((Collection)dtoList)) {
            return dtoList;
        }
        for (DetailRecommendDto dto : dtoList) {
            Set<Long> ids = Stream.of(dto.getRecommendItemIds().split(",")).map(Long::valueOf).collect(Collectors.toSet());
            List itemList = BeanUtils.copyList(this.itemService.findItemDtoByItemIds(ids), DetailRecommendItemDto.class);
            ArrayList idList = Lists.newArrayList();
            idList.addAll(ids);
            Map<Long, Integer> saleNum = this.itemSaleCountService.queryItemSaleNum(idList);
            String[] recommendNames = dto.getRecommendItemNames().split(",");
            int index = 0;
            for (DetailRecommendItemDto item : itemList) {
                item.setSaleNum(saleNum.get(item.getId()));
                item.setRecommendItemName(recommendNames[index]);
                ++index;
            }
            dto.setItemList(itemList);
        }
        return dtoList;
    }

    @Override
    public List<DetailRecommendDto> queryDetailRecommend(Long itemId) {
        List list = this.qihoDetailRecommendMapper.queryListByItemId(itemId);
        ArrayList dtoList = Lists.newArrayList();
        for (QihoDetailRecommendEntity qihoDetailRecommendEntity : list) {
            HashSet<Long> ids = new HashSet<Long>();
            List<String> recommendItemIds = Arrays.asList(qihoDetailRecommendEntity.getRecommendItemIds().split(","));
            for (String recommendItemId : recommendItemIds) {
                ids.add(Long.valueOf(recommendItemId));
            }
            List<ItemDto> itemDtos = this.itemService.findItemDtoByItemIds(ids);
            ArrayList detailRecommendItemDtos = Lists.newArrayList();
            if (qihoDetailRecommendEntity.getRecommendItemNames() != null) {
                String[] names = qihoDetailRecommendEntity.getRecommendItemNames().split(",");
                for (int i = 0; i < itemDtos.size(); ++i) {
                    ItemDto itemDto = itemDtos.get(i);
                    DetailRecommendItemDto detailRecommendItemDto = (DetailRecommendItemDto)BeanUtils.copy((Object)itemDto, DetailRecommendItemDto.class);
                    detailRecommendItemDto.setRecommendItemName(names[i]);
                    detailRecommendItemDtos.add(detailRecommendItemDto);
                }
            }
            DetailRecommendDto dto = (DetailRecommendDto)BeanUtils.copy((Object)qihoDetailRecommendEntity, DetailRecommendDto.class);
            dto.setItemList((List)detailRecommendItemDtos);
            dtoList.add(dto);
        }
        return dtoList;
    }

    @Override
    @Transactional
    public boolean saveDetailRecommend(List<DetailRecommendDto> dtos) {
        List list = BeanUtils.copyList(dtos, QihoDetailRecommendEntity.class);
        int result = 0;
        for (QihoDetailRecommendEntity qihoDetailRecommendEntity : list) {
            int i = qihoDetailRecommendEntity.getId() == null ? this.qihoDetailRecommendMapper.insert(qihoDetailRecommendEntity) : ("ON".equals(qihoDetailRecommendEntity.getIsOpen()) ? this.qihoDetailRecommendMapper.updateByPrimaryKeySelective(qihoDetailRecommendEntity) : this.qihoDetailRecommendMapper.deleteByPrimaryKey(qihoDetailRecommendEntity.getId()));
            result += i;
        }
        return result > 0;
    }

    @Override
    public ItemSimpleDto queryItemDetail(Long itemId) {
        QihoItemDetailEntity qihoItemDetailEntity = this.qihoItemDAO.findById(itemId);
        return (ItemSimpleDto)BeanUtils.copy((Object)qihoItemDetailEntity, ItemSimpleDto.class);
    }
}

