/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl;

import cn.com.duiba.stock.service.api.remoteservice.RemoteStockService;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.api.dto.ItemAdvertDto;
import com.qiho.center.api.dto.ItemDetailDto;
import com.qiho.center.api.dto.ItemDto;
import com.qiho.center.api.dto.ItemSimpleDto;
import com.qiho.center.api.dto.ItemSkuDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.merchant.MerchantDto;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.api.params.item.ItemPageParams;
import com.qiho.center.api.util.StringRandUtil;
import com.qiho.center.biz.event.ItemDeleteEvent;
import com.qiho.center.biz.service.ItemDetailRecordService;
import com.qiho.center.biz.service.ItemService;
import com.qiho.center.biz.service.ItemSkuService;
import com.qiho.center.biz.service.SkuPropertyService;
import com.qiho.center.biz.service.merchant.MerchantService;
import com.qiho.center.common.dao.QihoItemDAO;
import com.qiho.center.common.dao.QihoItemExtDAO;
import com.qiho.center.common.dao.QihoItemMerchantDAO;
import com.qiho.center.common.dao.QihoItemRecommendDAO;
import com.qiho.center.common.dao.QihoItemSkuDAO;
import com.qiho.center.common.entity.item.QihoItemDetailEntity;
import com.qiho.center.common.entity.item.QihoItemEntity;
import com.qiho.center.common.entity.item.QihoItemExtEntity;
import com.qiho.center.common.entity.item.QihoItemSkuEntity;
import com.qiho.center.common.entity.merchant.QihoItemMerchantEntity;
import com.qiho.center.common.entityd.qiho.QihoItemDetailRecordEntity;
import com.qiho.center.common.support.BizEventBus;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.javatuples.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItemServiceImpl
implements ItemService {
    @Autowired
    private QihoItemDAO qihoItemDAO;
    @Autowired
    private QihoItemSkuDAO qihoItemSkuDAO;
    @Autowired
    private QihoItemExtDAO qihoItemExtDAO;
    @Autowired
    private QihoItemRecommendDAO qihoItemRecommendDAO;
    @Autowired
    private SkuPropertyService skuPropertyService;
    @Autowired
    private ItemSkuService itemSkuService;
    @Autowired
    private RemoteStockService remoteStockService;
    @Autowired
    private ItemDetailRecordService itemDetailRecordService;
    @Autowired
    private BizEventBus eventBus;
    @Autowired
    private QihoItemMerchantDAO qihoItemMerchantDAO;
    @Autowired
    private MerchantService merchantService;

    @Override
    public PagenationDto<ItemDto> queryItemPage(ItemDto queryItem, Integer pageNum, Integer pageSize) {
        PagenationDto pagenation = new PagenationDto();
        QihoItemEntity param = (QihoItemEntity)BeanUtils.copy((Object)queryItem, QihoItemEntity.class);
        List list = this.qihoItemDAO.queryByParam(param, pageNum, pageSize);
        int total = this.qihoItemDAO.countByParam(param);
        pagenation.setList(this.convertToItemDto(list));
        pagenation.setTotal(Integer.valueOf(total));
        return pagenation;
    }

    private List<ItemDto> convertToItemDto(List<QihoItemDetailEntity> list) {
        ArrayList itemList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(list)) {
            return itemList;
        }
        ArrayList idList = Lists.newArrayList();
        for (QihoItemDetailEntity entity : list) {
            idList.add(entity.getId());
        }
        List skuList = this.qihoItemSkuDAO.getSkuByItemIds((List)idList);
        ArrayList stockIds = Lists.newArrayList();
        for (QihoItemSkuEntity skuEntity : skuList) {
            stockIds.add(skuEntity.getStockId());
        }
        Map stockMap = (Map)this.remoteStockService.findBatch((List)stockIds).getResult();
        Pair<Map, Map> stockPair = this.getSkuStockInfo(stockMap, skuList);
        Map itemStockMap = (Map)stockPair.getValue0();
        Map itemEnableStockMap = (Map)stockPair.getValue1();
        Pair<Map, Map> pricePair = this.getSkuPriceInfo(skuList);
        Map minPriceMap = (Map)pricePair.getValue0();
        Map minOriginalPriceMap = (Map)pricePair.getValue1();
        Set recommendIds = this.qihoItemRecommendDAO.findAllRecommendItemId();
        for (QihoItemDetailEntity entity : list) {
            ItemDto dto = new ItemDto();
            dto.setDeleted(entity.getDeleted());
            dto.setId(entity.getId());
            dto.setItemName(entity.getItemName());
            dto.setItemShortName(entity.getItemShortName());
            dto.setItemNo(entity.getItemNo());
            dto.setItemStatus(entity.getItemStatus());
            dto.setTopCategoryId(entity.getTopCategoryId());
            dto.setDelivery(entity.getDelivery());
            dto.setStock((Long)itemStockMap.get(entity.getId()));
            Long enableStock = (Long)itemEnableStockMap.get(entity.getId());
            dto.setEnableStock(Long.valueOf(enableStock == null ? 0L : enableStock));
            dto.setMinPrice((Integer)minPriceMap.get(entity.getId()));
            dto.setMinOriginalPrice((Integer)minOriginalPriceMap.get(entity.getId()));
            dto.setIsRecommend(Boolean.valueOf(recommendIds.contains(entity.getId())));
            Map extParam = (Map)JSON.parseObject((String)entity.getExtParam(), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
            dto.setExtParam(extParam);
            itemList.add(dto);
        }
        return itemList;
    }

    private Pair<Map, Map> getSkuPriceInfo(List<QihoItemSkuEntity> skuList) {
        HashMap minPriceMap = Maps.newHashMap();
        HashMap minOriginalPriceMap = Maps.newHashMap();
        for (QihoItemSkuEntity skuEntity : skuList) {
            Long itemId = skuEntity.getItemId();
            Integer minPrice = (Integer)minPriceMap.get(itemId);
            Integer sellingPrice = skuEntity.getSellingPrice() == null ? 0 : skuEntity.getSellingPrice();
            minPriceMap.put(itemId, minPrice == null ? sellingPrice : Math.min(minPrice, sellingPrice));
            Integer minOriginalPrice = (Integer)minOriginalPriceMap.get(itemId);
            Integer originalPrice = skuEntity.getOriginalPrice() == null ? 0 : skuEntity.getOriginalPrice();
            minOriginalPriceMap.put(itemId, minOriginalPrice == null ? originalPrice : Math.min(minOriginalPrice, originalPrice));
        }
        return Pair.with((Object)minPriceMap, (Object)minOriginalPriceMap);
    }

    private Pair<Map, Map> getSkuStockInfo(Map<Long, Long> stockMap, List<QihoItemSkuEntity> skuList) {
        HashMap itemStockMap = Maps.newHashMap();
        HashMap itemEnableStockMap = Maps.newHashMap();
        for (QihoItemSkuEntity skuEntity : skuList) {
            Long itemStock;
            Long itemId;
            Long stock = stockMap.get(skuEntity.getStockId());
            if (stock == null || stock <= 0L) {
                stock = 0L;
            }
            itemStockMap.put(itemId, (itemStock = (Long)itemStockMap.get(itemId = skuEntity.getItemId())) == null ? stock : itemStock + stock);
            if (!skuEntity.getSkuEnable().booleanValue()) continue;
            Long itemEnableStock = (Long)itemEnableStockMap.get(itemId);
            itemEnableStockMap.put(itemId, itemEnableStock == null ? stock : itemEnableStock + stock);
        }
        return Pair.with((Object)itemStockMap, (Object)itemEnableStockMap);
    }

    @Override
    @Transactional(value="QIHO")
    public Long createItem(ItemDetailDto itemDetail) {
        QihoItemEntity item = (QihoItemEntity)BeanUtils.copy((Object)itemDetail, QihoItemEntity.class);
        item.setDeleted(Boolean.valueOf(false));
        this.qihoItemDAO.insert(item);
        QihoItemMerchantEntity qihoItemMerchantEntity = new QihoItemMerchantEntity();
        qihoItemMerchantEntity.setMerchantId(itemDetail.getMerchantDto().getId());
        qihoItemMerchantEntity.setItemId(item.getId());
        qihoItemMerchantEntity.setGmtModifier(itemDetail.getGmtModifier());
        qihoItemMerchantEntity.setGmtCreator(itemDetail.getGmtCreator());
        this.qihoItemMerchantDAO.insert(qihoItemMerchantEntity);
        Long itemId = item.getId();
        QihoItemExtEntity itemExt = new QihoItemExtEntity();
        itemExt.setDetail(itemDetail.getDetail());
        Map extParam = itemDetail.getExtParam();
        Long virStock = this.processVirtailStock(itemDetail, Boolean.TRUE);
        extParam.put("virtualStock", String.valueOf(virStock));
        itemExt.setExtParam(JSON.toJSONString((Object)extParam));
        itemExt.setItemId(itemId);
        this.qihoItemExtDAO.insert(itemExt);
        this.addRecord(itemExt);
        List propertyList = itemDetail.getSkuPropertyList();
        this.skuPropertyService.updateItemId(propertyList, itemId);
        this.skuPropertyService.enableProperty(propertyList, itemId);
        this.itemSkuService.updateItemSku(itemDetail.getSkuList(), itemId);
        return itemId;
    }

    @Override
    @Transactional(value="QIHO")
    public void updateItem(ItemDetailDto itemDetail) {
        QihoItemEntity item = (QihoItemEntity)BeanUtils.copy((Object)itemDetail, QihoItemEntity.class);
        this.qihoItemDAO.update(item);
        QihoItemMerchantEntity qihoItemMerchantEntity = this.qihoItemMerchantDAO.findByItemId(item.getId());
        if (qihoItemMerchantEntity == null || qihoItemMerchantEntity.getMerchantId() != itemDetail.getMerchantDto().getId()) {
            QihoItemMerchantEntity itemMerchantEntity = new QihoItemMerchantEntity();
            itemMerchantEntity.setItemId(item.getId());
            itemMerchantEntity.setMerchantId(itemDetail.getMerchantDto().getId());
            itemMerchantEntity.setGmtModifier(itemDetail.getGmtModifier());
            itemMerchantEntity.setGmtCreator(itemDetail.getGmtModifier());
            this.qihoItemMerchantDAO.insert(itemMerchantEntity);
        }
        Long itemId = itemDetail.getId();
        QihoItemExtEntity itemExt = new QihoItemExtEntity();
        itemExt.setDetail(itemDetail.getDetail());
        Map extParam = itemDetail.getExtParam();
        Long virStock = this.processVirtailStock(itemDetail, Boolean.FALSE);
        extParam.put("virtualStock", String.valueOf(virStock));
        itemExt.setExtParam(JSON.toJSONString((Object)itemDetail.getExtParam()));
        itemExt.setItemId(itemId);
        this.qihoItemExtDAO.updateByItemId(itemExt);
        this.addRecord(itemExt);
        List propertyList = itemDetail.getSkuPropertyList();
        this.skuPropertyService.updateItemId(propertyList, itemId);
        this.skuPropertyService.enableProperty(propertyList, itemId);
        this.itemSkuService.updateItemSku(itemDetail.getSkuList(), itemId);
    }

    @Override
    public ItemDetailDto queryItemDetail(Long itemId) {
        QihoItemDetailEntity qihoItemDetailEntity = this.qihoItemDAO.findById(itemId);
        MerchantDto merchantDto = this.merchantService.findByItemId(itemId);
        if (qihoItemDetailEntity == null) {
            return null;
        }
        ItemDto itemDto = this.convertToItemDto(Lists.newArrayList((Object[])new QihoItemDetailEntity[]{qihoItemDetailEntity})).get(0);
        ItemDetailDto itemDetailDto = (ItemDetailDto)BeanUtils.copy((Object)itemDto, ItemDetailDto.class);
        itemDetailDto.setDetail(qihoItemDetailEntity.getDetail());
        if (merchantDto != null) {
            itemDetailDto.setMerchantDto(merchantDto);
        }
        itemDetailDto.setPriceText(qihoItemDetailEntity.getPriceText());
        itemDetailDto.setGmtCreator(qihoItemDetailEntity.getGmtCreator());
        itemDetailDto.setGmtModifier(qihoItemDetailEntity.getGmtModifier());
        itemDetailDto.setGmtModified(qihoItemDetailEntity.getGmtModified());
        itemDetailDto.setSkuPropertyList(this.skuPropertyService.getSkuPropertyByItemId(itemId));
        itemDetailDto.setSkuList(this.itemSkuService.getSkuByItemId(itemId));
        itemDetailDto.setDeleted(qihoItemDetailEntity.getDeleted());
        return itemDetailDto;
    }

    @Override
    public void updateStatus(List<Long> itemIds, String status) {
        this.qihoItemDAO.updateStatus(itemIds, status);
    }

    @Override
    public void deleteBatch(List<Long> itemIds) {
        this.qihoItemDAO.deleteBatch(itemIds);
        ItemDeleteEvent event = new ItemDeleteEvent();
        event.addAllItemId(itemIds);
        this.eventBus.post((Object)event);
    }

    @Override
    public List<ItemDto> findItemDtoByItemIds(Set<Long> itemIds) {
        List list = this.qihoItemDAO.findByIds((List)Lists.newArrayList(itemIds));
        ArrayList newList = Lists.newArrayList();
        for (QihoItemDetailEntity entity : list) {
            if (entity.getDeleted().booleanValue()) continue;
            newList.add(entity);
        }
        return this.convertToItemDto(newList);
    }

    @Override
    public List<ItemDto> findRecommendIndex() {
        List recommendList = this.qihoItemDAO.findRecommendIndex();
        return this.convertToItemDto(recommendList);
    }

    @Override
    public ItemSimpleDto queryItemSimpleDto(Long itemId) {
        QihoItemEntity entity = this.qihoItemDAO.findSimpleById(itemId);
        return (ItemSimpleDto)BeanUtils.copy((Object)entity, ItemSimpleDto.class);
    }

    @Override
    public List<ItemSimpleDto> queryItemSimpleList(ItemDto queryItem) {
        QihoItemEntity param = (QihoItemEntity)BeanUtils.copy((Object)queryItem, QihoItemEntity.class);
        List list = this.qihoItemDAO.querySimpleListByParam(param);
        return BeanUtils.copyList((List)list, ItemSimpleDto.class);
    }

    @Override
    public void updateExtParamByItemId(ItemAdvertDto dto) {
        QihoItemExtEntity itemExt = (QihoItemExtEntity)BeanUtils.copy((Object)dto, QihoItemExtEntity.class);
        this.qihoItemExtDAO.updateByItemId(itemExt);
        this.addRecord(itemExt);
    }

    @Override
    public ItemAdvertDto queryExtParamByItemId(Long itemId) {
        QihoItemExtEntity qihoItemExtEntity = this.qihoItemExtDAO.queryExtParamByItemId(itemId);
        return (ItemAdvertDto)BeanUtils.copy((Object)qihoItemExtEntity, ItemAdvertDto.class);
    }

    @Override
    public Long queryItemStockByItemId(Long itemId) {
        List idList = Stream.of(itemId).collect(Collectors.toList());
        List skuList = this.qihoItemSkuDAO.getSkuByItemIds(idList);
        ArrayList stockIds = Lists.newArrayList();
        for (QihoItemSkuEntity skuEntity : skuList) {
            stockIds.add(skuEntity.getStockId());
        }
        Map stockMap = (Map)this.remoteStockService.findBatch((List)stockIds).getResult();
        Long stockCount = 0L;
        for (Map.Entry stock : stockMap.entrySet()) {
            stockCount = stockCount + (Long)stock.getValue();
        }
        return stockCount;
    }

    @Override
    public Long updateVirtailStock(Long itemId) {
        Long allStock = this.queryItemStockByItemId(itemId);
        Long virStock = this.cacluateVirStock(allStock);
        QihoItemExtEntity extEntity = this.qihoItemExtDAO.queryExtParamByItemId(itemId);
        String extParam = extEntity.getExtParam();
        JSONObject extJson = StringUtils.isBlank((CharSequence)extParam) ? new JSONObject() : JSONObject.parseObject((String)extParam);
        extJson.put("virtualStock", (Object)virStock);
        QihoItemExtEntity newItemAdvertEntity = new QihoItemExtEntity();
        newItemAdvertEntity.setItemId(itemId);
        newItemAdvertEntity.setExtParam(extJson.toJSONString());
        this.qihoItemExtDAO.updateByItemId(newItemAdvertEntity);
        return virStock;
    }

    @Override
    public PagenationDto<ItemDto> queryItemPage(ItemPageParams params) {
        if (params.getMerchantId() == null || params.getMerchantId() <= 0L) {
            throw new QihoException("\u65e0\u6548\u7684\u5546\u5bb6id");
        }
        PagenationDto page = new PagenationDto();
        int count = this.qihoItemDAO.countSizeByparam(params);
        page.setTotal(Integer.valueOf(count));
        if (count == 0) {
            page.setList((List)Lists.newArrayList());
            return page;
        }
        List list = this.qihoItemDAO.queryByParam(params);
        page.setList(this.convertToItemDto(list));
        return page;
    }

    private Long processVirtailStock(ItemDetailDto itemDetailDto, Boolean flag) {
        List list = itemDetailDto.getSkuList();
        Long allStock = 0L;
        Long changeStock = 0L;
        for (ItemSkuDto itemSkuDto : list) {
            allStock = allStock + itemSkuDto.getStock();
            if (null == itemSkuDto.getStockChanges()) continue;
            changeStock = changeStock + itemSkuDto.getStockChanges();
        }
        if (flag.booleanValue()) {
            return this.cacluateVirStock(allStock);
        }
        Map extParam = itemDetailDto.getExtParam();
        String virStockStr = (String)extParam.get("virtualStock");
        Long virStock = StringUtils.isBlank((CharSequence)virStockStr) ? this.cacluateVirStock(allStock) : Long.valueOf(virStockStr);
        return new BigDecimal(virStock).add(new BigDecimal(changeStock)).longValue();
    }

    private Long cacluateVirStock(Long allStock) {
        Long consumeDefault = StringRandUtil.getRandom((Integer)50, (Integer)30);
        BigDecimal consumeRate = new BigDecimal(consumeDefault).divide(new BigDecimal(100), 2, 4);
        return new BigDecimal(allStock).divide(consumeRate, 0, 4).longValue();
    }

    private void addRecord(QihoItemExtEntity itemExt) {
        QihoItemDetailRecordEntity recordEntity = new QihoItemDetailRecordEntity();
        recordEntity.setItemId(itemExt.getItemId());
        if (StringUtils.isBlank((CharSequence)itemExt.getDetail())) {
            return;
        }
        recordEntity.setDetail(itemExt.getDetail());
        recordEntity.setSourceType(1);
        recordEntity.setSourceId(itemExt.getId());
        this.itemDetailRecordService.addDetailRecord(recordEntity);
    }
}

