/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl;

import cn.com.duiba.stock.service.api.dto.NewStockReqDto;
import cn.com.duiba.stock.service.api.dto.NewStockRespDto;
import cn.com.duiba.stock.service.api.dto.UpdateStockReqDto;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockBackendService;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.api.dto.ItemSkuDto;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.biz.service.ItemSkuService;
import com.qiho.center.common.dao.QihoItemSkuDAO;
import com.qiho.center.common.daoh.qiho.QihoItemSkuMapper;
import com.qiho.center.common.entityd.qiho.QihoItemSkuEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItemSkuServiceImpl
implements ItemSkuService {
    @Autowired
    private QihoItemSkuDAO qihoItemSkuDAO;
    @Autowired
    private RemoteStockService remoteStockService;
    @Autowired
    private RemoteStockBackendService remoteStockBackendService;
    @Autowired
    private QihoItemSkuMapper qihoItemSkuMapper;

    @Override
    public List<ItemSkuDto> getSkuByItemId(Long itemId) {
        List skuEntityList = this.qihoItemSkuDAO.getSkuByItemIds((List)Lists.newArrayList((Object[])new Long[]{itemId}));
        ArrayList skuDtoList = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)skuEntityList)) {
            return skuDtoList;
        }
        ArrayList stockIds = Lists.newArrayList();
        for (com.qiho.center.common.entity.item.QihoItemSkuEntity skuEntity : skuEntityList) {
            stockIds.add(skuEntity.getStockId());
        }
        Map stockMap = (Map)this.remoteStockService.findBatch((List)stockIds).getResult();
        for (com.qiho.center.common.entity.item.QihoItemSkuEntity skuEntity : skuEntityList) {
            ItemSkuDto skuDto = (ItemSkuDto)BeanUtils.copy((Object)skuEntity, ItemSkuDto.class);
            skuDto.setStock((Long)stockMap.get(skuEntity.getStockId()));
            skuDto.setStockId(skuEntity.getStockId());
            skuDtoList.add(skuDto);
        }
        return skuDtoList;
    }

    @Override
    @Transactional(value="QIHO")
    public void updateItemSku(List<ItemSkuDto> skuList, Long itemId) {
        if (CollectionUtils.isEmpty(skuList) || itemId == null) {
            return;
        }
        ArrayList sameList = Lists.newArrayList();
        ArrayList skuIds = Lists.newArrayList();
        ArrayList createSkuList = Lists.newArrayList();
        ArrayList modifySkuList = Lists.newArrayList();
        for (ItemSkuDto skuDto : skuList) {
            if (sameList.contains(skuDto.getSkuNo())) {
                throw new QihoException("\u4e0d\u5141\u8bb8\u5b58\u5728\u76f8\u540c\u7f16\u53f7");
            }
            sameList.add(skuDto.getSkuNo());
            com.qiho.center.common.entity.item.QihoItemSkuEntity skuEntity = (com.qiho.center.common.entity.item.QihoItemSkuEntity)BeanUtils.copy((Object)skuDto, com.qiho.center.common.entity.item.QihoItemSkuEntity.class);
            if (skuDto.getId() != null) {
                skuIds.add(skuDto.getId());
                modifySkuList.add(skuEntity);
                continue;
            }
            skuEntity.setItemId(itemId);
            skuEntity.setDeleted(Boolean.valueOf(false));
            createSkuList.add(skuEntity);
        }
        if (CollectionUtils.isNotEmpty((Collection)skuIds)) {
            this.qihoItemSkuDAO.deleteNotIn((List)skuIds, itemId);
        } else {
            this.qihoItemSkuDAO.deleteByItemId(itemId);
        }
        this.createSku(createSkuList);
        this.modifySku(modifySkuList);
    }

    private void modifySku(List<com.qiho.center.common.entity.item.QihoItemSkuEntity> modifySkuList) {
        if (CollectionUtils.isEmpty(modifySkuList)) {
            return;
        }
        ArrayList decreaseList = Lists.newArrayList();
        ArrayList increaseList = Lists.newArrayList();
        List<String> skuNos = this.getSkuNo(modifySkuList);
        Map skuNoStockMaps = this.qihoItemSkuMapper.selectSkuNoStockIds(skuNos);
        ArrayList stockReqList = Lists.newArrayList();
        HashMap skuMap = Maps.newHashMap();
        this.executeStock(modifySkuList, decreaseList, increaseList, skuNoStockMaps, stockReqList, skuMap);
        if (CollectionUtils.isNotEmpty((Collection)stockReqList)) {
            List stockRespList = (List)this.remoteStockBackendService.newStockBatch((List)stockReqList).getResult();
            for (NewStockRespDto stockResp : stockRespList) {
                com.qiho.center.common.entity.item.QihoItemSkuEntity skuEntity = (com.qiho.center.common.entity.item.QihoItemSkuEntity)skuMap.get(stockResp.getGid());
                skuEntity.setStockId(Long.valueOf(stockResp.getStockId()));
            }
        }
        this.qihoItemSkuDAO.updateBatch(modifySkuList);
        if (CollectionUtils.isNotEmpty((Collection)decreaseList)) {
            this.remoteStockBackendService.decreaseItemStockBatch((List)decreaseList);
        }
        if (CollectionUtils.isNotEmpty((Collection)increaseList)) {
            this.remoteStockBackendService.increaseItemStockBatch((List)increaseList);
        }
    }

    private void executeStock(List<com.qiho.center.common.entity.item.QihoItemSkuEntity> modifySkuList, List<UpdateStockReqDto> decreaseList, List<UpdateStockReqDto> increaseList, Map<String, QihoItemSkuEntity> skuNoStockMaps, List<NewStockReqDto> stockReqList, Map<Long, com.qiho.center.common.entity.item.QihoItemSkuEntity> skuMap) {
        for (com.qiho.center.common.entity.item.QihoItemSkuEntity skuEntity : modifySkuList) {
            if (skuNoStockMaps.containsKey(skuEntity.getSkuNo())) {
                long stockId = skuNoStockMaps.get(skuEntity.getSkuNo()).getStockId();
                skuEntity.setStockId(Long.valueOf(stockId));
                DubboResult stockNum = this.remoteStockBackendService.find(stockId);
                long changeStock = skuEntity.getStock() - (Long)stockNum.getResult();
                if (changeStock == 0L) continue;
                UpdateStockReqDto updateStockReqDto = new UpdateStockReqDto();
                updateStockReqDto.setStockId(stockId);
                updateStockReqDto.setStock(Math.abs(changeStock));
                if (changeStock > 0L) {
                    increaseList.add(updateStockReqDto);
                    continue;
                }
                decreaseList.add(updateStockReqDto);
                continue;
            }
            skuMap.put(skuEntity.getId(), skuEntity);
            NewStockReqDto stockReq = new NewStockReqDto();
            stockReq.setGid(skuEntity.getId().longValue());
            stockReq.setStock(skuEntity.getStock().longValue());
            stockReqList.add(stockReq);
        }
    }

    private void createSku(List<com.qiho.center.common.entity.item.QihoItemSkuEntity> createSkuList) {
        if (CollectionUtils.isEmpty(createSkuList)) {
            return;
        }
        this.qihoItemSkuDAO.insertBatch(createSkuList);
        ArrayList stockReqList = Lists.newArrayList();
        HashMap skuMap = Maps.newHashMap();
        List<String> skuNos = this.getSkuNo(createSkuList);
        Map skuNoStockMaps = this.qihoItemSkuMapper.selectSkuNoStockIds(skuNos);
        ArrayList decreaseList = Lists.newArrayList();
        ArrayList increaseList = Lists.newArrayList();
        this.updateHandlerSku(createSkuList, stockReqList, skuMap, skuNoStockMaps, decreaseList, increaseList);
        if (CollectionUtils.isNotEmpty((Collection)stockReqList)) {
            List stockRespList = (List)this.remoteStockBackendService.newStockBatch((List)stockReqList).getResult();
            for (NewStockRespDto stockResp : stockRespList) {
                com.qiho.center.common.entity.item.QihoItemSkuEntity skuEntity = (com.qiho.center.common.entity.item.QihoItemSkuEntity)skuMap.get(stockResp.getGid());
                skuEntity.setStockId(Long.valueOf(stockResp.getStockId()));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)decreaseList)) {
            this.remoteStockBackendService.decreaseItemStockBatch((List)decreaseList);
        }
        if (CollectionUtils.isNotEmpty((Collection)increaseList)) {
            this.remoteStockBackendService.increaseItemStockBatch((List)increaseList);
        }
        this.qihoItemSkuDAO.updateBatch(createSkuList);
    }

    private void updateHandlerSku(List<com.qiho.center.common.entity.item.QihoItemSkuEntity> createSkuList, List<NewStockReqDto> stockReqList, Map<Long, com.qiho.center.common.entity.item.QihoItemSkuEntity> skuMap, Map<String, QihoItemSkuEntity> skuNoStockMaps, List<UpdateStockReqDto> decreaseList, List<UpdateStockReqDto> increaseList) {
        for (com.qiho.center.common.entity.item.QihoItemSkuEntity skuEntity : createSkuList) {
            if (skuNoStockMaps.containsKey(skuEntity.getSkuNo())) {
                long stockId = skuNoStockMaps.get(skuEntity.getSkuNo()).getStockId();
                skuEntity.setStockId(Long.valueOf(stockId));
                DubboResult stockNum = this.remoteStockBackendService.find(stockId);
                long changeStock = skuEntity.getStock() - (Long)stockNum.getResult();
                if (changeStock == 0L) continue;
                UpdateStockReqDto updateStockReqDto = new UpdateStockReqDto();
                updateStockReqDto.setStockId(stockId);
                updateStockReqDto.setStock(Math.abs(changeStock));
                if (changeStock > 0L) {
                    increaseList.add(updateStockReqDto);
                    continue;
                }
                decreaseList.add(updateStockReqDto);
                continue;
            }
            skuMap.put(skuEntity.getId(), skuEntity);
            NewStockReqDto stockReq = new NewStockReqDto();
            stockReq.setGid(skuEntity.getId().longValue());
            stockReq.setStock(skuEntity.getStock().longValue());
            stockReqList.add(stockReq);
        }
    }

    private List<String> getSkuNo(List<com.qiho.center.common.entity.item.QihoItemSkuEntity> createSkuList) {
        ArrayList<String> result = new ArrayList<String>();
        for (com.qiho.center.common.entity.item.QihoItemSkuEntity qihoItemSkuEntity : createSkuList) {
            result.add(qihoItemSkuEntity.getSkuNo());
        }
        return result;
    }

    @Override
    public ItemSkuDto querySku(Long skuId) {
        com.qiho.center.common.entity.item.QihoItemSkuEntity entity = this.qihoItemSkuDAO.findById(skuId);
        if (entity == null) {
            return null;
        }
        ItemSkuDto sku = (ItemSkuDto)BeanUtils.copy((Object)entity, ItemSkuDto.class);
        DubboResult result = this.remoteStockService.find(entity.getStockId().longValue());
        sku.setStock((Long)result.getResult());
        return sku;
    }
}

