/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.api.dto.ErpOrderDto;
import com.qiho.center.api.dto.FundOrderDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.logistics.ErpLogisticsSyncAckDto;
import com.qiho.center.api.dto.logistics.ErpLogisticsSyncDto;
import com.qiho.center.api.dto.logistics.LogisticsOrderDto;
import com.qiho.center.api.dto.logistics.QueryLogisticsOrderDto;
import com.qiho.center.api.enums.ErpErrorCodeReturnEnum;
import com.qiho.center.api.enums.ErpTypeEnum;
import com.qiho.center.api.enums.FundBizTypeEnum;
import com.qiho.center.api.enums.FundStatusEnum;
import com.qiho.center.api.enums.LogisticsNameEnum;
import com.qiho.center.api.enums.LogisticsOrderStatusEnum;
import com.qiho.center.api.enums.OrderStatusEnum;
import com.qiho.center.api.enums.PayTypeEnum;
import com.qiho.center.api.enums.QihoExpressEnum;
import com.qiho.center.api.enums.YTOLogisticsStatusEnum;
import com.qiho.center.api.params.ResolveDeliverParams;
import com.qiho.center.biz.event.LogisticsInfoUpdateEvent;
import com.qiho.center.biz.event.LogisticsUpdateEvent;
import com.qiho.center.biz.service.LogisticsOrderService;
import com.qiho.center.biz.service.order.ErpOrderService;
import com.qiho.center.biz.service.order.FundOrderService;
import com.qiho.center.common.dao.QihoErpOrderDAO;
import com.qiho.center.common.dao.QihoFundOrderDAO;
import com.qiho.center.common.dao.QihoLogisticsOrderDAO;
import com.qiho.center.common.dao.QihoOrderDAO;
import com.qiho.center.common.dao.QihoOrderSnapshotDAO;
import com.qiho.center.common.entity.fund.QihoFundOrderEntity;
import com.qiho.center.common.entity.logistics.LogisticsOrderEntity;
import com.qiho.center.common.entity.order.QihoErpOrderEntity;
import com.qiho.center.common.entity.order.QihoOrderEntity;
import com.qiho.center.common.entity.order.QihoOrderSnapshotEntity;
import com.qiho.center.common.enums.SeqBizTypeEnum;
import com.qiho.center.common.params.ErpLogisticsOrderParams;
import com.qiho.center.common.params.QueryYTOLogisticProcessParams;
import com.qiho.center.common.support.BizEventBus;
import com.qiho.center.common.support.SequenceNoBuilder;
import com.qiho.center.common.util.AppLogUtil;
import com.qiho.center.common.util.YTOClientUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LogisticsOrderServiceImpl
implements LogisticsOrderService {
    private static final Logger LOG = LoggerFactory.getLogger(LogisticsOrderServiceImpl.class);
    @Autowired
    private QihoLogisticsOrderDAO qihoLogisticsOrderDAO;
    @Autowired
    private SequenceNoBuilder builder;
    @Autowired
    private BizEventBus bizEventBus;
    @Autowired
    private QihoErpOrderDAO qihoErpOrderDAO;
    @Autowired
    private QihoOrderDAO qihoOrderDAO;
    @Autowired
    private QihoOrderSnapshotDAO qihoOrderSnapshotDAO;
    @Autowired
    private QihoFundOrderDAO qihoFundOrderDAO;
    @Autowired
    private FundOrderService fundOrderService;
    @Autowired
    private ErpOrderService erpOrderService;

    @Override
    public void initLogisticsOrder(ErpOrderDto erp, ResolveDeliverParams params) {
        ErpLogisticsSyncDto erpLogisticsSyncDto = new ErpLogisticsSyncDto();
        QihoExpressEnum qihoExpressEnum = params.getQihoExpressEnum();
        erpLogisticsSyncDto.setLogisticsCode(qihoExpressEnum.getCode());
        erpLogisticsSyncDto.setLogisticsName(qihoExpressEnum.getName());
        erpLogisticsSyncDto.setLogisticsNo(params.getExpressCode());
        erpLogisticsSyncDto.setTid(erp.getErpId());
        LogisticsOrderEntity entity = this.convertToLogisticsOrderEntity(erpLogisticsSyncDto, (QihoErpOrderEntity)BeanUtils.copy((Object)erp, QihoErpOrderEntity.class));
        this.createLogisticsOrder(entity);
    }

    @Override
    @Transactional(value="QIHO")
    public void createLogisticsOrder(LogisticsOrderEntity logisticsOrderEntity) {
        this.qihoLogisticsOrderDAO.insert(logisticsOrderEntity);
        this.qihoOrderDAO.updateOrderStatus(logisticsOrderEntity.getOrderId(), OrderStatusEnum.SEND_OUT);
        QihoOrderSnapshotEntity orderSnapshot = new QihoOrderSnapshotEntity();
        orderSnapshot.setOrderId(logisticsOrderEntity.getOrderId());
        orderSnapshot.setPostId(logisticsOrderEntity.getPostId());
        orderSnapshot.setOrderStatus(OrderStatusEnum.SEND_OUT.getCode());
        orderSnapshot.setLogisticsCode(logisticsOrderEntity.getLogisticsCode());
        orderSnapshot.setLogisticsName(logisticsOrderEntity.getLogisticsName());
        orderSnapshot.setLogisticsStatus(logisticsOrderEntity.getLogisticsStatus());
        this.qihoOrderSnapshotDAO.updateByOrderId(orderSnapshot);
        LogisticsInfoUpdateEvent event = (LogisticsInfoUpdateEvent)BeanUtils.copy((Object)logisticsOrderEntity, LogisticsInfoUpdateEvent.class);
        this.bizEventBus.post((Object)event);
    }

    @Override
    public PagenationDto<LogisticsOrderDto> queryLogisticsOrderPage(QueryLogisticsOrderDto queryItem, Integer pageNum, Integer pageSize) {
        PagenationDto pagenation = new PagenationDto();
        LogisticsOrderEntity param = (LogisticsOrderEntity)BeanUtils.copy((Object)queryItem, LogisticsOrderEntity.class);
        int total = this.qihoLogisticsOrderDAO.countLogisticsOrderByParam(param, queryItem.getStartTime(), queryItem.getEndTime());
        List list = null;
        if (total > 0) {
            list = this.qihoLogisticsOrderDAO.queryLogisticsOrderByParam(param, pageNum, pageSize, queryItem.getStartTime(), queryItem.getEndTime());
        }
        pagenation.setList(this.convertToLogisticsOrderDto(list));
        pagenation.setTotal(Integer.valueOf(total));
        return pagenation;
    }

    private List<LogisticsOrderDto> convertToLogisticsOrderDto(List<LogisticsOrderEntity> list) {
        ArrayList logisticsOrderDtoList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(list)) {
            return logisticsOrderDtoList;
        }
        for (LogisticsOrderEntity entity : list) {
            LogisticsOrderDto dto = (LogisticsOrderDto)BeanUtils.copy((Object)entity, LogisticsOrderDto.class);
            logisticsOrderDtoList.add(dto);
        }
        return logisticsOrderDtoList;
    }

    @Override
    @Transactional(value="QIHO")
    public Integer updateBylogisticsId(String logisticsId, String orderStatus) {
        LogisticsOrderDto dto = this.findByLogisticsId(logisticsId);
        if (dto == null || StringUtils.equals((String)dto.getOrderStatus(), (String)LogisticsOrderStatusEnum.RETURN.getCode()) || StringUtils.equals((String)dto.getOrderStatus(), (String)LogisticsOrderStatusEnum.SUCCESS.getCode())) {
            AppLogUtil.info((Logger)LOG, (String)"\u7269\u6d41\u5b50\u8ba2\u5355\u5df2\u7b7e\u6536\uff0c\u6216\u67e5\u8be2\u4e0d\u5230\u3002\u65e0\u6cd5\u4fee\u6539\u8ba2\u5355\u72b6\u6001,logisticsId={}", (Object[])new Object[]{logisticsId});
            return 0;
        }
        String logisticsStatus = StringUtils.equals((String)orderStatus, (String)LogisticsOrderStatusEnum.SUCCESS.getCode()) ? YTOLogisticsStatusEnum.SIGNED.getDesc() : YTOLogisticsStatusEnum.FAILED.getDesc();
        int success = this.qihoLogisticsOrderDAO.updateLogisticsOrderStatus(logisticsId, orderStatus, logisticsStatus);
        this.updateOrderInfo(dto, logisticsStatus, orderStatus);
        return success;
    }

    private void updateOrderInfo(LogisticsOrderDto logisticsOrderDto, String logisticsStatus, String orderStatus) {
        LogisticsOrderStatusEnum logisticsOrderStatusEnum = LogisticsOrderStatusEnum.getByCode((String)orderStatus);
        switch (logisticsOrderStatusEnum) {
            case SUCCESS: {
                this.updateToSuccess(logisticsOrderDto.getOrderId(), logisticsStatus);
                break;
            }
            case RETURN: 
            case FAILED: 
            case REJECTED: {
                this.updateToFailed(logisticsOrderDto.getOrderId(), logisticsStatus, orderStatus);
                break;
            }
            default: {
                QihoOrderSnapshotEntity orderSnapshot = new QihoOrderSnapshotEntity();
                orderSnapshot.setOrderId(logisticsOrderDto.getOrderId());
                orderSnapshot.setLogisticsStatus(logisticsStatus);
                this.qihoOrderSnapshotDAO.updateByOrderId(orderSnapshot);
            }
        }
        if (StringUtils.equals((String)orderStatus, (String)LogisticsOrderStatusEnum.RETURN.getCode())) {
            this.returnAmount(logisticsOrderDto);
            return;
        }
        if (LogisticsNameEnum.JD.getCode().equals(logisticsOrderDto.getLogisticsCode())) {
            return;
        }
        LogisticsUpdateEvent event = new LogisticsUpdateEvent();
        event.setLogisticsStatus(YTOLogisticsStatusEnum.getByName((String)logisticsStatus));
        event.setOrderId(logisticsOrderDto.getOrderId());
        event.setLogisticsOrderStatusEnum(logisticsOrderStatusEnum);
        if (LogisticsNameEnum.YTO.getCode().equals(logisticsOrderDto.getLogisticsCode()) && StringUtils.equals((String)YTOLogisticsStatusEnum.SENT_SCAN.getDesc(), (String)logisticsStatus)) {
            event.setDeliveryMsg(logisticsOrderDto.getDeliveryMsg());
        }
        if (!LogisticsNameEnum.YTO.getCode().equals(logisticsOrderDto.getLogisticsCode())) {
            HashMap<String, String> deliveryMsg = new HashMap<String, String>();
            deliveryMsg.put("logisticsCom", logisticsOrderDto.getLogisticsName());
            event.setDeliveryMsg(deliveryMsg);
        }
        event.setLogisticsCode(logisticsOrderDto.getLogisticsCode());
        this.bizEventBus.post((Object)event);
    }

    @Override
    public List<LogisticsOrderDto> findByOrderId(String orderId) {
        return BeanUtils.copyList((List)this.qihoLogisticsOrderDAO.findByOrderId(orderId), LogisticsOrderDto.class);
    }

    private List<ErpLogisticsSyncAckDto> convertToListReurn(Map<String, ErpLogisticsOrderParams> errorCodeMap) {
        ArrayList<ErpLogisticsSyncAckDto> listReurn = new ArrayList<ErpLogisticsSyncAckDto>();
        for (Map.Entry<String, ErpLogisticsOrderParams> errorMap : errorCodeMap.entrySet()) {
            ErpLogisticsOrderParams erpLogisticsOrderParams = errorMap.getValue();
            listReurn.add(new ErpLogisticsSyncAckDto(erpLogisticsOrderParams.getRecId(), erpLogisticsOrderParams.getErpErrorCodeReturnEnum()));
        }
        return listReurn;
    }

    private LogisticsOrderEntity convertToLogisticsOrderEntity(ErpLogisticsSyncDto erpLogisticsSyncDto, QihoErpOrderEntity erpOrder) {
        LogisticsOrderEntity entity = new LogisticsOrderEntity();
        entity.setErpId(erpLogisticsSyncDto.getTid());
        entity.setPostId(erpLogisticsSyncDto.getLogisticsNo());
        entity.setLogisticsCode(erpLogisticsSyncDto.getLogisticsCode());
        entity.setLogisticsName(erpLogisticsSyncDto.getLogisticsName());
        entity.setLogisticsStatus(YTOLogisticsStatusEnum.ACCEPT.getDesc());
        entity.setOrderStatus(LogisticsOrderStatusEnum.ACCEPT.getCode());
        entity.setConsumerName(erpOrder.getConsumerName());
        entity.setItemId(erpOrder.getItemId());
        entity.setItemName(erpOrder.getItemName());
        entity.setItemNo(erpOrder.getItemNo());
        entity.setLogisticsId(this.builder.createSeqNo(SeqBizTypeEnum.LOGISTICS, erpOrder.getItemId()));
        entity.setMobile(erpOrder.getMobile());
        entity.setOrderId(erpOrder.getOrderId());
        entity.setSkuNo(erpOrder.getSkuNo());
        entity.setProvince(erpOrder.getProvince());
        return entity;
    }

    @Override
    @Transactional(value="QIHO")
    public Integer update(LogisticsOrderDto logisticsOrderDto) {
        LogisticsOrderDto dto = this.findByPostIdCode(logisticsOrderDto.getPostId(), logisticsOrderDto.getLogisticsCode());
        int success = 0;
        if (dto == null || StringUtils.equals((String)dto.getOrderStatus(), (String)LogisticsOrderStatusEnum.RETURN.getCode()) || StringUtils.equals((String)dto.getOrderStatus(), (String)LogisticsOrderStatusEnum.SUCCESS.getCode())) {
            AppLogUtil.info((Logger)LOG, (String)"\u7269\u6d41\u5b50\u8ba2\u5355\u5df2\u7b7e\u6536\uff0c\u6216\u67e5\u8be2\u4e0d\u5230\u3002\u65e0\u6cd5\u4fee\u6539\u8ba2\u5355\u72b6\u6001,postId={}", (Object[])new Object[]{logisticsOrderDto.getPostId()});
            return success;
        }
        if (StringUtils.equals((String)dto.getOrderStatus(), (String)LogisticsOrderStatusEnum.FAILED.getCode()) && !StringUtils.equals((String)logisticsOrderDto.getOrderStatus(), (String)LogisticsOrderStatusEnum.SUCCESS.getCode()) && !StringUtils.equals((String)logisticsOrderDto.getOrderStatus(), (String)LogisticsOrderStatusEnum.RETURN.getCode())) {
            return success;
        }
        LogisticsOrderEntity param = (LogisticsOrderEntity)BeanUtils.copy((Object)logisticsOrderDto, LogisticsOrderEntity.class);
        success = this.qihoLogisticsOrderDAO.update(param);
        if (StringUtils.equals((String)YTOLogisticsStatusEnum.SENT_SCAN.getDesc(), (String)logisticsOrderDto.getLogisticsStatus())) {
            dto.setDeliveryMsg(logisticsOrderDto.getDeliveryMsg());
        }
        this.updateOrderInfo(dto, logisticsOrderDto.getLogisticsStatus(), logisticsOrderDto.getOrderStatus());
        return success;
    }

    private void returnAmount(LogisticsOrderDto logisticsOrderDto) {
        ErpOrderDto erpOrderDto = this.erpOrderService.findErpOrderByErpId(logisticsOrderDto.getErpId());
        if (ErpTypeEnum.SEND.getCode().equals(erpOrderDto.getErpType())) {
            String orderId = logisticsOrderDto.getOrderId();
            List<FundOrderDto> fundOrderDtoList = this.fundOrderService.findByOrderIdAndBizType(orderId, FundBizTypeEnum.PAY.getCode());
            FundOrderDto fundOrder = fundOrderDtoList.get(0);
            if (!StringUtils.equals((String)PayTypeEnum.COD.getCode(), (String)fundOrder.getPayType()) && StringUtils.equals((String)FundStatusEnum.SUCCESS.getCode(), (String)fundOrder.getFundStatus())) {
                this.fundOrderService.refund(orderId, fundOrder.getPayType(), fundOrder.getAmt());
            }
        }
    }

    private void updateToSuccess(String orderId, String logisticsStatus) {
        QihoFundOrderEntity fundOrder;
        QihoOrderEntity updateOrder = new QihoOrderEntity();
        updateOrder.setOrderId(orderId);
        updateOrder.setOrderStatus(OrderStatusEnum.SUCCESS.getCode());
        updateOrder.setRemark(LogisticsOrderStatusEnum.SUCCESS.getDesc());
        this.qihoOrderDAO.updateByOrderId(updateOrder);
        QihoOrderSnapshotEntity orderSnapshot = new QihoOrderSnapshotEntity();
        orderSnapshot.setOrderId(orderId);
        orderSnapshot.setLogisticsStatus(logisticsStatus);
        orderSnapshot.setOrderStatus(OrderStatusEnum.SUCCESS.getCode());
        orderSnapshot.setFundStatus(FundStatusEnum.SUCCESS.getCode());
        orderSnapshot.setRemark(LogisticsOrderStatusEnum.SUCCESS.getDesc());
        this.qihoOrderSnapshotDAO.updateByOrderId(orderSnapshot);
        List list = this.qihoFundOrderDAO.findByOrderIdAndBizType(orderId, FundBizTypeEnum.PAY.getCode());
        if (CollectionUtils.isNotEmpty((Collection)list) && StringUtils.equals((String)(fundOrder = (QihoFundOrderEntity)list.get(0)).getPayType(), (String)PayTypeEnum.COD.getCode())) {
            this.qihoFundOrderDAO.updateFundOrderStatus(fundOrder.getFundId(), FundStatusEnum.SUCCESS.getCode());
        }
    }

    private void updateToFailed(String orderId, String logisticsStatus, String logisticsOrderStatus) {
        QihoFundOrderEntity fundOrder;
        LogisticsOrderStatusEnum logisticsOrderStatusEnum = LogisticsOrderStatusEnum.getByCode((String)logisticsOrderStatus);
        QihoOrderEntity updateOrder = new QihoOrderEntity();
        updateOrder.setOrderId(orderId);
        updateOrder.setOrderStatus(OrderStatusEnum.CLOSED.getCode());
        updateOrder.setRemark(logisticsOrderStatusEnum.getDesc());
        this.qihoOrderDAO.updateByOrderId(updateOrder);
        QihoOrderSnapshotEntity orderSnapshot = new QihoOrderSnapshotEntity();
        orderSnapshot.setOrderId(orderId);
        orderSnapshot.setLogisticsStatus(logisticsStatus);
        orderSnapshot.setOrderStatus(OrderStatusEnum.CLOSED.getCode());
        orderSnapshot.setRemark(logisticsOrderStatusEnum.getDesc());
        List list = this.qihoFundOrderDAO.findByOrderIdAndBizType(orderId, FundBizTypeEnum.PAY.getCode());
        if (CollectionUtils.isNotEmpty((Collection)list) && StringUtils.equals((String)(fundOrder = (QihoFundOrderEntity)list.get(0)).getPayType(), (String)PayTypeEnum.COD.getCode())) {
            this.qihoFundOrderDAO.updateFundOrderStatus(fundOrder.getFundId(), FundStatusEnum.FAILED.getCode());
            orderSnapshot.setFundStatus(FundStatusEnum.FAILED.getCode());
        }
        this.qihoOrderSnapshotDAO.updateByOrderId(orderSnapshot);
    }

    @Override
    public List<ErpLogisticsSyncAckDto> createLogisticsOrderBatch(List<ErpLogisticsSyncDto> list) {
        ArrayList returnList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(list)) {
            return returnList;
        }
        HashMap<String, ErpLogisticsOrderParams> errorCodeMap = new HashMap<String, ErpLogisticsOrderParams>(list.size());
        HashMap syncMap = Maps.newHashMap();
        ArrayList erpIds = Lists.newArrayList();
        for (ErpLogisticsSyncDto erpLogisticsSyncDto : list) {
            errorCodeMap.put(erpLogisticsSyncDto.getTid(), new ErpLogisticsOrderParams(erpLogisticsSyncDto.getRecId(), ErpErrorCodeReturnEnum.ORDER_CODE_NON_ERROR));
            erpIds.add(erpLogisticsSyncDto.getTid());
            syncMap.put(erpLogisticsSyncDto.getTid(), erpLogisticsSyncDto);
        }
        List erpOrderList = this.qihoErpOrderDAO.findByErpIds((List)erpIds);
        if (CollectionUtils.isEmpty((Collection)erpOrderList)) {
            return this.convertToListReurn(errorCodeMap);
        }
        List existList = this.qihoLogisticsOrderDAO.findByErpIds((List)erpIds);
        ArrayList syncErpIds = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)existList)) {
            for (LogisticsOrderEntity logisticsOrder : existList) {
                syncErpIds.add(logisticsOrder.getErpId());
            }
        }
        for (QihoErpOrderEntity erpOrder : erpOrderList) {
            ((ErpLogisticsOrderParams)errorCodeMap.get(erpOrder.getErpId())).setErpErrorCodeReturnEnum(ErpErrorCodeReturnEnum.SUCCESS);
            if (syncErpIds.contains(erpOrder.getErpId())) continue;
            LogisticsOrderEntity logisticsOrderEntity = this.convertToLogisticsOrderEntity((ErpLogisticsSyncDto)syncMap.get(erpOrder.getErpId()), erpOrder);
            this.createLogisticsOrder(logisticsOrderEntity);
        }
        return this.convertToListReurn(errorCodeMap);
    }

    @Override
    public LogisticsOrderDto findByPostIdCode(String postId, String logisticsCode) {
        return (LogisticsOrderDto)BeanUtils.copy((Object)this.qihoLogisticsOrderDAO.findByPostIdCode(postId, logisticsCode), LogisticsOrderDto.class);
    }

    @Override
    public LogisticsOrderDto findByLogisticsId(String logisticsId) {
        return (LogisticsOrderDto)BeanUtils.copy((Object)this.qihoLogisticsOrderDAO.findByLogisticsId(logisticsId), LogisticsOrderDto.class);
    }

    @Override
    public LogisticsOrderDto findByErpId(String erpId) {
        ArrayList erpids = Lists.newArrayList();
        erpids.add(erpId);
        List list = this.qihoLogisticsOrderDAO.findByErpIds((List)erpids);
        return CollectionUtils.isNotEmpty((Collection)list) ? (LogisticsOrderDto)BeanUtils.copy(list.get(0), LogisticsOrderDto.class) : null;
    }

    @Override
    public void syncLogisticsStatus(String logisticsOrderStatus) {
        List list;
        LogisticsOrderEntity param = new LogisticsOrderEntity();
        param.setOrderStatus(logisticsOrderStatus);
        int pageSize = 100;
        int pageNum = 1;
        while (!CollectionUtils.isEmpty((Collection)(list = this.qihoLogisticsOrderDAO.queryLogisticsOrderByParam(param, Integer.valueOf(pageNum), Integer.valueOf(pageSize), null, null)))) {
            this.doSync(list);
            ++pageNum;
        }
    }

    @Override
    public void doSync(List<LogisticsOrderEntity> list) {
        for (LogisticsOrderEntity entity : list) {
            String[] refuseRemark;
            if (!StringUtils.equals((String)entity.getLogisticsCode(), (String)LogisticsNameEnum.YTO.getCode())) continue;
            QueryYTOLogisticProcessParams queryXml = new QueryYTOLogisticProcessParams(new QueryYTOLogisticProcessParams.Result(new QueryYTOLogisticProcessParams.Result.WaybillCode(entity.getPostId())));
            String logisticsString = YTOClientUtil.execute((String)YTOClientUtil.getQueryLogisticsUrl(), (Object)queryXml);
            if (StringUtils.indexOfAny((String)logisticsString, (String[])(refuseRemark = new String[]{"\u7b7e\u6536\u4eba: \u9000\u4ef6", "\u7b7e\u6536\u4eba: \u9000\u56de"})) > 0 && StringUtils.contains((String)logisticsString, (String)"\u3010\u6d59\u6c5f\u7701\u676d\u5dde\u5e02\u5bcc\u9633\u5e02\u516c\u53f8\u3011 \u6d3e\u4ef6\u4eba")) {
                entity.setLogisticsStatus(YTOLogisticsStatusEnum.FAILED.getDesc());
                entity.setOrderStatus(LogisticsOrderStatusEnum.RETURN.getCode());
            } else {
                if (!StringUtils.contains((String)logisticsString, (String)"\u5df2\u7b7e\u6536 \u611f\u8c22\u4f7f\u7528\u5706\u901a\u901f\u9012\uff0c\u671f\u5f85\u518d\u6b21\u4e3a\u60a8\u670d\u52a1")) continue;
                entity.setLogisticsStatus(YTOLogisticsStatusEnum.SIGNED.getDesc());
                entity.setOrderStatus(LogisticsOrderStatusEnum.SUCCESS.getCode());
            }
            LogisticsOrderDto dto = (LogisticsOrderDto)BeanUtils.copy((Object)entity, LogisticsOrderDto.class);
            this.update(dto);
        }
    }

    @Override
    public List<LogisticsOrderEntity> queryListToFix(int pageNum, int pageSize, long minId) {
        return this.qihoLogisticsOrderDAO.queryListToFix(pageNum, pageSize, minId);
    }

    @Override
    public int queryDistributeOverTimeNum() {
        return this.qihoLogisticsOrderDAO.queryDistributeOverTimeNum();
    }

    @Override
    public List<LogisticsOrderDto> queryDistributeOverTimePage(Integer pageNum, Integer pageSize) {
        List list = this.qihoLogisticsOrderDAO.queryDistributeOverTimePage(pageNum, pageSize);
        return BeanUtils.copyList((List)list, LogisticsOrderDto.class);
    }

    @Override
    public Integer updateLogisticsOrderRemark(LogisticsOrderDto param) {
        return this.qihoLogisticsOrderDAO.updateLogisticsOrderRemark(param);
    }

    @Override
    public PagenationDto<LogisticsOrderDto> queryServiceLogisticsOrder(QueryLogisticsOrderDto queryItem, Integer pageNum, Integer pageSize) {
        PagenationDto pagenation = new PagenationDto();
        LogisticsOrderEntity param = (LogisticsOrderEntity)BeanUtils.copy((Object)queryItem, LogisticsOrderEntity.class);
        int total = this.qihoLogisticsOrderDAO.countServiceLogisticsOrder(param, queryItem.getOrderStartTime(), queryItem.getOrderEndTime(), queryItem.getOrderProcessStatus());
        List list = null;
        if (total > 0) {
            list = this.qihoLogisticsOrderDAO.queryServiceLogisticsOrder(param, pageNum, pageSize, queryItem.getOrderStartTime(), queryItem.getOrderEndTime(), queryItem.getOrderProcessStatus());
        }
        pagenation.setList(this.convertToLogisticsOrderDto(list));
        pagenation.setTotal(Integer.valueOf(total));
        return pagenation;
    }

    @Override
    public Long queryMonitorLogisticsOrderCount(String orderStatus, String logisticsCode, Date startTime, Date endTime, List<String> provinceList) {
        return this.qihoLogisticsOrderDAO.queryMonitorLogisticsOrderCount(orderStatus, logisticsCode, startTime, endTime, provinceList);
    }

    @Override
    public String findDeliveryByPostId(String postId) {
        List list = this.qihoOrderSnapshotDAO.findDeliveryByPostId(postId);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return (String)list.get(0);
        }
        return null;
    }
}

