/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.SkinDto;
import com.qiho.center.api.dto.abtest.TestMetadataDto;
import com.qiho.center.api.enums.MetadataTypeEnum;
import com.qiho.center.api.params.QuerySkinParams;
import com.qiho.center.biz.service.SkinService;
import com.qiho.center.biz.service.abtest.TestMetadataService;
import com.qiho.center.common.dao.QihoSkinDAO;
import com.qiho.center.common.entity.QihoSkinEntity;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SkinServiceImpl
implements SkinService {
    private Logger logger = LoggerFactory.getLogger(SkinServiceImpl.class);
    @Autowired
    private QihoSkinDAO skinDAO;
    @Autowired
    private TestMetadataService testMetadataService;

    @Override
    public PagenationDto<SkinDto> queryAllSkin(QuerySkinParams params) {
        List skinDtoList = Lists.transform((List)this.skinDAO.queryAllSkin(params), this::convertDto);
        Integer count = this.skinDAO.countAllSkin(params);
        PagenationDto pagenationDto = new PagenationDto();
        pagenationDto.setList(skinDtoList);
        pagenationDto.setTotal(count);
        return pagenationDto;
    }

    @Override
    public SkinDto querySkinById(Long id) {
        return this.convertDto(this.skinDAO.querySkinById(id));
    }

    @Override
    @Transactional(value="QIHO")
    public Long createSkin(SkinDto entity) {
        if (null == entity) {
            return 0L;
        }
        Long skinId = this.skinDAO.createSkin(this.convertEntity(entity));
        try {
            TestMetadataDto testMetadataDto = new TestMetadataDto();
            testMetadataDto.setItemId(Long.valueOf(0L));
            testMetadataDto.setMetadataKey(MetadataTypeEnum.SKIN.getCode());
            testMetadataDto.setMetadataValue(skinId.toString());
            testMetadataDto.setDataName(entity.getSkinName());
            testMetadataDto.setDataDesc(entity.getSkinName());
            this.testMetadataService.saveMetadata(testMetadataDto);
        }
        catch (Exception e) {
            this.logger.error("SkinServiceImpl createSkin call saveMetadata error,param={}", (Object)JSON.toJSONString((Object)entity), (Object)e);
        }
        return skinId;
    }

    @Override
    @Transactional(value="QIHO")
    public int updateSkin(SkinDto entity) {
        if (null == entity) {
            return 0;
        }
        return this.skinDAO.updateSkin(this.convertEntity(entity));
    }

    @Override
    @Transactional(value="QIHO")
    public int deleteSkin(Long id) {
        this.testMetadataService.deleteSkinTestMetadata(id);
        return this.skinDAO.deleteSkin(id);
    }

    private SkinDto convertDto(QihoSkinEntity entity) {
        if (entity == null) {
            return null;
        }
        SkinDto skinDto = new SkinDto();
        BeanUtils.copyProperties((Object)entity, (Object)skinDto);
        skinDto.setGmtModified(Long.valueOf(entity.getGmtModified().getTime()));
        return skinDto;
    }

    private QihoSkinEntity convertEntity(SkinDto dto) {
        QihoSkinEntity entity = new QihoSkinEntity();
        BeanUtils.copyProperties((Object)dto, (Object)entity);
        return entity;
    }
}

