/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.abtest;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.api.dto.ItemAdvertDto;
import com.qiho.center.api.dto.ItemDetailDto;
import com.qiho.center.api.dto.ItemSimpleDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.abtest.TestMetadataDto;
import com.qiho.center.api.enums.MetadataTypeEnum;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.api.params.TestMetadataQueryParam;
import com.qiho.center.biz.service.ItemDetailRecordService;
import com.qiho.center.biz.service.ItemService;
import com.qiho.center.biz.service.abtest.TestMetadataService;
import com.qiho.center.common.dao.QihoItemDAO;
import com.qiho.center.common.daoh.qiho.QihoMetadataDetailMapper;
import com.qiho.center.common.daoh.qiho.QihoTestMetadataMapper;
import com.qiho.center.common.daoh.qiho.QihoTestPlanMapper;
import com.qiho.center.common.entity.item.QihoItemEntity;
import com.qiho.center.common.entityd.qiho.QihoItemDetailRecordEntity;
import com.qiho.center.common.entityd.qiho.abtest.QihoMetadataDetailEntity;
import com.qiho.center.common.entityd.qiho.abtest.QihoTestMetadataEntity;
import com.qiho.center.common.entityd.qiho.abtest.QihoTestPlanEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TestMetadataServiceImpl
implements TestMetadataService {
    @Resource
    private ItemDetailRecordService itemDetailRecordService;
    @Resource
    QihoTestMetadataMapper qihoTestMetadataMapper;
    @Resource
    QihoMetadataDetailMapper qihoMetadataDetailMappler;
    @Resource
    QihoTestPlanMapper qihoTestPlanMapper;
    @Resource
    ItemService itemService;
    @Resource
    private QihoItemDAO qihoItemDAO;

    @Override
    @Transactional(value="QIHO")
    public int saveMetadata(TestMetadataDto dto) throws BizException {
        MetadataTypeEnum type = MetadataTypeEnum.getByCode((String)dto.getMetadataKey());
        if (null == type) {
            throw new BizException("\u65e0\u6548\u7684\u5143\u6570\u636e\u7c7b\u578b");
        }
        QihoTestMetadataEntity entity = (QihoTestMetadataEntity)BeanUtils.copy((Object)dto, QihoTestMetadataEntity.class);
        this.validateInfo(entity);
        QihoItemDetailRecordEntity detailRecordEntity = null;
        if (type.equals((Object)MetadataTypeEnum.DETAIL)) {
            QihoMetadataDetailEntity detailEntity = new QihoMetadataDetailEntity();
            detailEntity.setItemId(entity.getItemId());
            detailEntity.setDetailText(entity.getMetadataValue());
            this.qihoMetadataDetailMappler.insert(detailEntity);
            entity.setMetadataValue(detailEntity.getId() + "");
            detailRecordEntity = new QihoItemDetailRecordEntity();
            detailRecordEntity.setItemId(entity.getItemId());
            detailRecordEntity.setDetail(detailEntity.getDetailText());
            detailRecordEntity.setSourceType(2);
        }
        int count = this.qihoTestMetadataMapper.insert(entity);
        if (null != detailRecordEntity) {
            detailRecordEntity.setSourceId(entity.getId());
            this.itemDetailRecordService.addDetailRecord(detailRecordEntity);
        }
        return count;
    }

    @Override
    public void validateInfo(QihoTestMetadataEntity entity) throws BizException {
        HashMap param = Maps.newHashMap();
        param.put("dataName", entity.getDataName());
        param.put("metadataKey", entity.getMetadataKey());
        List list = this.qihoTestMetadataMapper.selectListByField((Map)param);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        if (null == entity.getId() || entity.getId() == 0L) {
            throw new BizException("\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
        for (QihoTestMetadataEntity dataEntity : list) {
            if (dataEntity.getId().equals(entity.getId())) continue;
            throw new BizException("\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
    }

    @Override
    @Transactional(value="QIHO")
    public int updateMetadata(TestMetadataDto dto) throws BizException {
        MetadataTypeEnum type = MetadataTypeEnum.getByCode((String)dto.getMetadataKey());
        QihoTestMetadataEntity entity = (QihoTestMetadataEntity)BeanUtils.copy((Object)dto, QihoTestMetadataEntity.class);
        this.validateInfo(entity);
        QihoItemDetailRecordEntity detailRecordEntity = null;
        if (type.equals((Object)MetadataTypeEnum.DETAIL)) {
            QihoTestMetadataEntity oldEntity = this.qihoTestMetadataMapper.selectById(dto.getId());
            QihoMetadataDetailEntity detailEntity = new QihoMetadataDetailEntity();
            detailEntity.setItemId(entity.getItemId());
            detailEntity.setDetailText(entity.getMetadataValue());
            detailEntity.setId(Long.valueOf(oldEntity.getMetadataValue()));
            this.qihoMetadataDetailMappler.update(detailEntity);
            entity.setMetadataValue(detailEntity.getId() + "");
            detailRecordEntity = new QihoItemDetailRecordEntity();
            detailRecordEntity.setItemId(entity.getItemId());
            detailRecordEntity.setDetail(detailEntity.getDetailText());
            detailRecordEntity.setSourceType(2);
        }
        int num = this.qihoTestMetadataMapper.update(entity);
        if (null != detailRecordEntity) {
            detailRecordEntity.setSourceId(entity.getId());
            this.itemDetailRecordService.addDetailRecord(detailRecordEntity);
        }
        return num;
    }

    @Override
    public TestMetadataDto selectById(Long id) {
        QihoTestMetadataEntity entity = this.qihoTestMetadataMapper.selectById(id);
        TestMetadataDto dto = (TestMetadataDto)BeanUtils.copy((Object)entity, TestMetadataDto.class);
        if (Objects.equal((Object)MetadataTypeEnum.DETAIL, (Object)MetadataTypeEnum.getByCode((String)dto.getMetadataKey()))) {
            QihoMetadataDetailEntity detailEntity = this.qihoMetadataDetailMappler.selectById(Long.valueOf(dto.getMetadataValue()));
            dto.setMetadataValue(detailEntity.getDetailText());
            dto.setMetadataDetailId(detailEntity.getId());
        }
        return dto;
    }

    @Override
    public List<TestMetadataDto> selectListByTypeAndItemId(Long itemId, String metadataKey) {
        ArrayList resultList = Lists.newArrayList();
        HashMap param = Maps.newHashMap();
        if (StringUtils.equals((CharSequence)metadataKey, (CharSequence)MetadataTypeEnum.SKIN.getCode())) {
            param.put("itemId", 0L);
        } else {
            param.put("itemId", itemId);
        }
        param.put("metadataKey", metadataKey);
        List list = this.qihoTestMetadataMapper.selectListByField((Map)param);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return resultList;
        }
        list.stream().forEach(entity -> resultList.add(BeanUtils.copy((Object)entity, TestMetadataDto.class)));
        return resultList;
    }

    @Override
    public PagenationDto<TestMetadataDto> queryListByPage(TestMetadataQueryParam param) throws BizException {
        ItemDetailDto itemDetailDto = this.itemService.queryItemDetail(param.getItemId());
        if (null == itemDetailDto) {
            throw new BizException("\u6ca1\u6709\u627e\u5230\u8be5\u5546\u54c1");
        }
        PagenationDto page = new PagenationDto();
        int count = this.qihoTestMetadataMapper.selectListCountByPage(param);
        page.setTotal(Integer.valueOf(count));
        if (count == 0) {
            return page;
        }
        ArrayList pageList = Lists.newArrayList();
        List list = this.qihoTestMetadataMapper.selectListByPage(param);
        list.stream().forEach(entity -> {
            TestMetadataDto dto = (TestMetadataDto)BeanUtils.copy((Object)entity, TestMetadataDto.class);
            dto.setItemName(itemDetailDto.getItemName());
            dto.setPicUrl((String)itemDetailDto.getExtParam().get("image"));
            if (StringUtils.equals((CharSequence)dto.getMetadataKey(), (CharSequence)MetadataTypeEnum.DETAIL.getCode())) {
                QihoMetadataDetailEntity detailEntity = this.qihoMetadataDetailMappler.selectById(Long.valueOf(dto.getMetadataValue()));
                dto.setMetadataValue(detailEntity.getDetailText());
                dto.setMetadataDetailId(detailEntity.getId());
                pageList.add(dto);
            }
        });
        page.setList((List)pageList);
        return page;
    }

    @Override
    public int deleteMetadata(Long id) throws BizException {
        List list = this.qihoTestPlanMapper.selectValidPlanCountByMetadataId(id);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            throw new BizException("\u672c\u8be6\u60c5\u5df2\u88ab\u7528\u4e8e\u6d4b\u8bd5\u65b9\u6848\u3010" + ((QihoTestPlanEntity)list.get(0)).getPlanName() + "\u3011\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        return this.qihoTestMetadataMapper.deleteById(id);
    }

    @Override
    public boolean syncToItemInfo(Long id, Long modifyId) throws BizException {
        QihoTestMetadataEntity entity = this.qihoTestMetadataMapper.selectById(id);
        if (null == entity || entity.getIsDelete() == 1) {
            throw new BizException("\u8bb0\u5f55\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        }
        ItemSimpleDto itemSimpleDto = this.itemService.queryItemSimpleDto(entity.getItemId());
        if (null == itemSimpleDto) {
            throw new BizException("\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        if (StringUtils.equals((CharSequence)entity.getMetadataKey(), (CharSequence)MetadataTypeEnum.DETAIL.getCode())) {
            ItemAdvertDto itemAdvertDto = this.itemService.queryExtParamByItemId(entity.getItemId());
            QihoMetadataDetailEntity detailEntity = this.qihoMetadataDetailMappler.selectById(Long.valueOf(entity.getMetadataValue()));
            itemAdvertDto.setDetail(detailEntity.getDetailText());
            this.itemService.updateExtParamByItemId(itemAdvertDto);
            QihoItemEntity itemEntity = new QihoItemEntity();
            itemEntity.setId(entity.getItemId());
            itemEntity.setGmtModifier(modifyId);
            this.qihoItemDAO.update(itemEntity);
        }
        return true;
    }

    @Override
    public void deleteSkinTestMetadata(Long skinId) {
        HashMap map = Maps.newHashMap();
        map.put("metadataKey", MetadataTypeEnum.SKIN.getCode());
        map.put("metadataValue", skinId.toString());
        List entityList = this.qihoTestMetadataMapper.selectListByField((Map)map);
        if (CollectionUtils.isEmpty((Collection)entityList)) {
            return;
        }
        QihoTestMetadataEntity metadataEntity = (QihoTestMetadataEntity)entityList.get(0);
        List list = this.qihoTestPlanMapper.selectValidPlanCountByMetadataId(metadataEntity.getId());
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            throw new QihoException("\u8be5\u76ae\u80a4\u88ab\u5e94\u7528\u4e8e\u6d4b\u8bd5\u8ba1\u5212[" + ((QihoTestPlanEntity)list.get(0)).getPlanName() + "],\u4e0d\u80fd\u5220\u9664");
        }
        this.qihoTestMetadataMapper.deleteById(metadataEntity.getId());
    }
}

