/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.agent;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.agent.AgentMerchantsDto;
import com.qiho.center.api.params.agent.AgentMerchantPageParams;
import com.qiho.center.biz.service.agent.BaiqiAgentMerchantService;
import com.qiho.center.common.dao.QihoMerchantDAO;
import com.qiho.center.common.daoh.qiho.agent.BaiqiAgentMerchantMapper;
import com.qiho.center.common.entity.merchant.QihoMerchantEntity;
import com.qiho.center.common.entityd.qiho.agent.BaiqiAgentMerchantRelationEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class BaiqiAgentMerchantServiceImpl
implements BaiqiAgentMerchantService {
    @Resource
    private BaiqiAgentMerchantMapper baiqiAgentMerchantMapper;
    @Resource
    private QihoMerchantDAO qihoMerchantDAO;

    @Override
    public List<Long> findExistMerchantIds(Long agentId) {
        return this.baiqiAgentMerchantMapper.findMerchantIdsByAgentId(agentId);
    }

    @Override
    public Boolean batchInsert(List<BaiqiAgentMerchantRelationEntity> list) {
        return this.baiqiAgentMerchantMapper.batchInsert(list) > 0;
    }

    @Override
    public List<Long> findAllMerchantIds() {
        return this.baiqiAgentMerchantMapper.findAllMerchantIds();
    }

    @Override
    public Boolean findByAgentIdAndMerchantId(Long agentId, Long merchantId) {
        return this.baiqiAgentMerchantMapper.findByAgentIdAndMerchantId(agentId, merchantId) == 1;
    }

    @Override
    public PagenationDto<AgentMerchantsDto> findPageByAgentId(AgentMerchantPageParams pageParams) {
        List merchantIds = this.baiqiAgentMerchantMapper.findMerchantIdsPageByAgentId(pageParams);
        PagenationDto pagenationDto = new PagenationDto();
        if (CollectionUtils.isEmpty((Collection)merchantIds)) {
            pagenationDto.setList(Collections.emptyList());
            pagenationDto.setTotal(Integer.valueOf(0));
            return pagenationDto;
        }
        List merchantEntities = this.qihoMerchantDAO.listByIds(merchantIds);
        HashMap<Long, QihoMerchantEntity> merchantMap = new HashMap<Long, QihoMerchantEntity>();
        for (Object entity : merchantEntities) {
            merchantMap.put(entity.getId(), (QihoMerchantEntity)entity);
        }
        merchantIds.sort((o1, o2) -> o1 < o2 ? 1 : -1);
        ArrayList<Object> list = new ArrayList<Object>(merchantIds.size());
        for (Long merchantId : merchantIds) {
            QihoMerchantEntity merchantEntity = (QihoMerchantEntity)merchantMap.get(merchantId);
            list.add(BeanUtils.copy((Object)merchantEntity, AgentMerchantsDto.class));
        }
        Integer total = this.baiqiAgentMerchantMapper.countPageByCondition(pageParams);
        pagenationDto.setList(list);
        pagenationDto.setTotal(total);
        return pagenationDto;
    }
}

