/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.coupon;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.dto.coupon.ActiveDto;
import com.qiho.center.api.params.ActiveQueryParams;
import com.qiho.center.biz.bo.CouponBo;
import com.qiho.center.biz.service.coupon.ActiveService;
import com.qiho.center.common.dao.coupon.QihoActiveDAO;
import com.qiho.center.common.dao.coupon.QihoCouponActiveDAO;
import com.qiho.center.common.entity.coupon.QihoActiveEntity;
import com.qiho.center.common.entity.coupon.QihoCouponActiveEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ActiveServiceImpl
implements ActiveService {
    @Resource
    private QihoActiveDAO qihoActiveDAO;
    @Resource
    private QihoCouponActiveDAO couponActiveDAO;
    @Resource
    private CouponBo couponBo;

    @Override
    @Transactional(value="QIHO")
    public Long insert(ActiveDto dto) {
        QihoActiveEntity activeEntity = (QihoActiveEntity)BeanUtils.copy((Object)dto, QihoActiveEntity.class);
        this.qihoActiveDAO.insert(activeEntity);
        Long activeId = activeEntity.getId();
        List couponIds = dto.getCouponIds();
        if (CollectionUtils.isNotEmpty((Collection)couponIds)) {
            List<QihoCouponActiveEntity> couponActiveEntities = this.idsParseToEntities(activeId, couponIds);
            this.couponBo.batchInsertCouponActive(couponActiveEntities, Boolean.TRUE);
        }
        return activeId;
    }

    @Override
    @Transactional(value="QIHO")
    public Boolean update(ActiveDto dto) {
        this.qihoActiveDAO.update((QihoActiveEntity)BeanUtils.copy((Object)dto, QihoActiveEntity.class));
        Long activeId = dto.getId();
        List changeCouponIds = dto.getCouponIds();
        List oldCouponActives = this.couponActiveDAO.findByActiveId(activeId);
        if (CollectionUtils.isEmpty((Collection)oldCouponActives)) {
            List<QihoCouponActiveEntity> couponActiveEntities = this.idsParseToEntities(activeId, changeCouponIds);
            this.couponBo.batchInsertCouponActive(couponActiveEntities, Boolean.TRUE);
        } else {
            List<Long> oldCouponIds = oldCouponActives.stream().map(QihoCouponActiveEntity::getCouponId).collect(Collectors.toList());
            ArrayList midCoupoIds = new ArrayList();
            midCoupoIds.addAll(changeCouponIds);
            midCoupoIds.retainAll(oldCouponIds);
            changeCouponIds.removeAll(midCoupoIds);
            oldCouponIds.removeAll(midCoupoIds);
            List<QihoCouponActiveEntity> insertEntities = this.idsParseToEntities(activeId, changeCouponIds);
            this.couponBo.batchInsertCouponActive(insertEntities, Boolean.TRUE);
            List<QihoCouponActiveEntity> deleteEntities = this.idsParseToEntities(activeId, oldCouponIds);
            this.couponBo.batchInsertCouponActive(deleteEntities, Boolean.FALSE);
        }
        return Boolean.TRUE;
    }

    @Override
    @Transactional(value="QIHO")
    public Integer delete(Long activeId) {
        this.couponActiveDAO.deleteByActiveId(activeId);
        return this.qihoActiveDAO.delete(activeId);
    }

    @Override
    public ActiveDto findByActiveId(Long activeId) {
        ActiveDto activeDto = (ActiveDto)BeanUtils.copy((Object)this.qihoActiveDAO.findByActiveId(activeId), ActiveDto.class);
        List couponActiveEntities = this.couponActiveDAO.findByActiveId(activeId);
        if (CollectionUtils.isNotEmpty((Collection)couponActiveEntities)) {
            List couponIds = couponActiveEntities.stream().map(QihoCouponActiveEntity::getCouponId).collect(Collectors.toList());
            activeDto.setCouponIds(couponIds);
        }
        return activeDto;
    }

    @Override
    public List<ActiveDto> findActiveByQuery(ActiveQueryParams params) {
        List qihoActiveEntities = this.qihoActiveDAO.findActiveByQuery(params);
        return BeanUtils.copyList((List)qihoActiveEntities, ActiveDto.class);
    }

    @Override
    public Integer countActiveByQuery(ActiveQueryParams params) {
        return this.qihoActiveDAO.countActiveByQuery(params);
    }

    @Override
    public ActiveDto findAbleNewsActive() {
        return (ActiveDto)BeanUtils.copy((Object)this.qihoActiveDAO.findAbleNewsActive(), ActiveDto.class);
    }

    private List<QihoCouponActiveEntity> idsParseToEntities(Long activeId, List<Long> couponIds) {
        if (CollectionUtils.isEmpty(couponIds)) {
            return new ArrayList<QihoCouponActiveEntity>();
        }
        return couponIds.stream().map(e -> {
            QihoCouponActiveEntity couponActiveEntity = new QihoCouponActiveEntity();
            couponActiveEntity.setCouponId(e);
            couponActiveEntity.setActiveId(activeId);
            couponActiveEntity.setDeleted(Boolean.FALSE);
            return couponActiveEntity;
        }).collect(Collectors.toList());
    }
}

