/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.finance;

import cn.com.duiba.wolf.redis.RedisAtomicClient;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.account.BaiqiFinanceRechargeDetailDto;
import com.qiho.center.api.dto.account.BaiqiFinanceRechargeDto;
import com.qiho.center.api.enums.finance.BaiqiCommercialTenantTypeEnum;
import com.qiho.center.api.enums.finance.BaiqiFinanceRechargeStateEnum;
import com.qiho.center.api.enums.finance.FinanceDetailStatusEnum;
import com.qiho.center.api.enums.finance.FinanceOptTypeEnum;
import com.qiho.center.api.params.finance.BaiqiFinanceRechargeQryParam;
import com.qiho.center.biz.service.finance.BaiqiFinanceRechargeService;
import com.qiho.center.common.dao.QihoMerchantDAO;
import com.qiho.center.common.daoh.qiho.agent.BaiqiAgentMapper;
import com.qiho.center.common.daoh.qiho.finance.BaiqiFinanceDetailMapper;
import com.qiho.center.common.daoh.qiho.finance.BaiqiFinanceMapper;
import com.qiho.center.common.daoh.qiho.finance.BaiqiFinanceRechargeMapper;
import com.qiho.center.common.entity.BaseEntity;
import com.qiho.center.common.entity.merchant.QihoMerchantEntity;
import com.qiho.center.common.entityd.qiho.agent.BaiqiAgentEntity;
import com.qiho.center.common.entityd.qiho.finance.BaiqiFinanceDetailEntity;
import com.qiho.center.common.entityd.qiho.finance.BaiqiFinanceEntity;
import com.qiho.center.common.entityd.qiho.finance.BaiqiFinanceRechargeEntity;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="baiqiFinanceRechargeService")
public class BaiqiFinanceRechargeServiceImpl
implements BaiqiFinanceRechargeService {
    @Resource
    private BaiqiFinanceRechargeMapper baiqiFinanceRechargeMapper;
    @Resource
    private BaiqiAgentMapper baiqiAgentMapper;
    @Resource
    private QihoMerchantDAO qihoMerchantDAO;
    @Resource(name="redisTemplate")
    private RedisAtomicClient redisAtomicClient;
    @Resource
    private BaiqiFinanceMapper baiqiFinanceMapper;
    @Resource
    private BaiqiFinanceDetailMapper baiqiFinanceDetailMapper;

    @Override
    public PagenationDto<BaiqiFinanceRechargeDetailDto> find4Page(BaiqiFinanceRechargeQryParam params) {
        PagenationDto page = new PagenationDto();
        if (params.getOffset() == null || params.getMax() == null) {
            page.setTotal(Integer.valueOf(0));
            return page;
        }
        Integer count = this.baiqiFinanceRechargeMapper.count4Page(params);
        page.setTotal(count);
        if (count == 0) {
            return page;
        }
        List list = BeanUtils.copyList((List)this.baiqiFinanceRechargeMapper.query4Page(params), BaiqiFinanceRechargeDetailDto.class);
        this.mergeDto(list);
        page.setList(list);
        return page;
    }

    private void mergeDto(List<BaiqiFinanceRechargeDetailDto> list) {
        ArrayList<Long> agentIds = new ArrayList<Long>();
        ArrayList<Long> merchantIds = new ArrayList<Long>();
        for (BaiqiFinanceRechargeDetailDto dto : list) {
            if (dto.getCommercialTenantType().intValue() == BaiqiCommercialTenantTypeEnum.AGENT.getType()) {
                agentIds.add(dto.getCommercialTenantId());
                continue;
            }
            if (dto.getCommercialTenantType().intValue() != BaiqiCommercialTenantTypeEnum.MERCHANT.getType()) continue;
            merchantIds.add(dto.getCommercialTenantId());
        }
        Map<Long, String> agentMap = this.getAgentMap(agentIds);
        Map<Long, String> merchantMap = this.getMerchantMap(merchantIds);
        if (MapUtils.isNotEmpty(agentMap) || MapUtils.isNotEmpty(merchantMap)) {
            for (BaiqiFinanceRechargeDetailDto dto : list) {
                if (dto.getCommercialTenantType().intValue() == BaiqiCommercialTenantTypeEnum.AGENT.getType()) {
                    dto.setCommercialTenantName(agentMap.get(dto.getCommercialTenantId()));
                    continue;
                }
                if (dto.getCommercialTenantType().intValue() != BaiqiCommercialTenantTypeEnum.MERCHANT.getType()) continue;
                dto.setCommercialTenantName(merchantMap.get(dto.getCommercialTenantId()));
            }
        }
    }

    private Map<Long, String> getMerchantMap(List<Long> merchantIds) {
        List merchantList;
        Map<Long, String> merchantMap = new HashMap<Long, String>();
        if (CollectionUtils.isNotEmpty(merchantIds) && CollectionUtils.isNotEmpty((Collection)(merchantList = this.qihoMerchantDAO.listByIds(merchantIds)))) {
            merchantMap = merchantList.stream().collect(Collectors.toMap(BaseEntity::getId, QihoMerchantEntity::getMerchantName));
        }
        return merchantMap;
    }

    private Map<Long, String> getAgentMap(List<Long> agentIds) {
        List agentList;
        Map<Long, String> agentMap = new HashMap<Long, String>();
        if (CollectionUtils.isNotEmpty(agentIds) && CollectionUtils.isNotEmpty((Collection)(agentList = this.baiqiAgentMapper.findByIds(agentIds)))) {
            agentMap = agentList.stream().collect(Collectors.toMap(BaseEntity::getId, BaiqiAgentEntity::getAgentName));
        }
        return agentMap;
    }

    @Override
    public Boolean insert(BaiqiFinanceRechargeDto dto) {
        dto.setRechargeNo(this.getRechargeNo());
        return this.baiqiFinanceRechargeMapper.insert((BaiqiFinanceRechargeEntity)BeanUtils.copy((Object)dto, BaiqiFinanceRechargeEntity.class)) > 0;
    }

    private Long getRechargeNo() {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyyMMdd");
        String date = dtf.format(LocalDateTime.now());
        Long value = this.redisAtomicClient.incrBy(MessageFormat.format("{0}_recharge_no", date), 1L, 1L, TimeUnit.DAYS);
        return Long.valueOf(date + String.format("%03d", value));
    }

    @Override
    public BaiqiFinanceRechargeDetailDto findByNo(Long rechargeNo) {
        BaiqiAgentEntity agentEntity;
        BaiqiFinanceRechargeDetailDto dto = (BaiqiFinanceRechargeDetailDto)BeanUtils.copy((Object)this.baiqiFinanceRechargeMapper.findByRechargeNo(rechargeNo), BaiqiFinanceRechargeDetailDto.class);
        if (dto.getCommercialTenantType().intValue() == BaiqiCommercialTenantTypeEnum.MERCHANT.getType()) {
            QihoMerchantEntity merchantEntity = this.qihoMerchantDAO.getById(dto.getCommercialTenantId());
            if (merchantEntity != null) {
                dto.setCommercialTenantName(merchantEntity.getMerchantName());
                dto.setCommercialTenantOwner(merchantEntity.getContactName());
            }
        } else if (dto.getCommercialTenantType().intValue() == BaiqiCommercialTenantTypeEnum.AGENT.getType() && (agentEntity = this.baiqiAgentMapper.findById(dto.getCommercialTenantId())) != null) {
            dto.setCommercialTenantName(agentEntity.getAgentName());
            dto.setCommercialTenantOwner(agentEntity.getContactName());
        }
        return dto;
    }

    @Override
    @Transactional(value="QIHO")
    public int updateState(Integer state, Long rechargeNo, String operator) {
        this.baiqiFinanceRechargeMapper.updateState(state.intValue(), rechargeNo.longValue(), operator);
        if (state.intValue() == BaiqiFinanceRechargeStateEnum.SUCCEED.getState()) {
            BaiqiFinanceRechargeEntity rechargeEntity = this.baiqiFinanceRechargeMapper.findByRechargeNo(rechargeNo);
            BaiqiFinanceEntity financeEntity = this.baiqiFinanceMapper.findByRelation(rechargeEntity.getCommercialTenantType().intValue(), rechargeEntity.getCommercialTenantId().longValue());
            financeEntity.setCashAmount(Long.valueOf(rechargeEntity.getCashSum() == null ? financeEntity.getCashAmount() : Long.valueOf(rechargeEntity.getCashSum().intValue()) + financeEntity.getCashAmount()));
            financeEntity.setRebateAmount(Long.valueOf(rechargeEntity.getRebateSum() == null ? financeEntity.getRebateAmount() : Long.valueOf(rechargeEntity.getRebateSum().intValue()) + financeEntity.getRebateAmount()));
            Long incomeTotalAmout = this.getTotalAmount(rechargeEntity.getCashSum(), rechargeEntity.getRebateSum());
            financeEntity.setTotalAmount(Long.valueOf(financeEntity.getTotalAmount() + incomeTotalAmout));
            this.baiqiFinanceMapper.updateAmount(financeEntity);
            BaiqiFinanceDetailEntity financeDetailEntity = new BaiqiFinanceDetailEntity();
            financeDetailEntity.setFinanceId(financeEntity.getId());
            financeDetailEntity.setRelationId(financeEntity.getRelationId());
            financeDetailEntity.setRelationType(financeEntity.getRelationType());
            financeDetailEntity.setIncomeCash(incomeTotalAmout);
            financeDetailEntity.setIncomeCash(rechargeEntity.getCashSum() == null ? null : Long.valueOf(rechargeEntity.getCashSum().intValue()));
            financeDetailEntity.setIncomeRebate(rechargeEntity.getRebateSum() == null ? null : Long.valueOf(rechargeEntity.getRebateSum().intValue()));
            financeDetailEntity.setState(FinanceDetailStatusEnum.SUCCESS.getNum());
            financeDetailEntity.setOperator(Long.valueOf(0L));
            financeDetailEntity.setOperatorType(FinanceOptTypeEnum.OFFLINE_RECHARGE.getNum());
            financeDetailEntity.setIncomeTotal(incomeTotalAmout);
            this.baiqiFinanceDetailMapper.insert(financeDetailEntity);
        }
        return 1;
    }

    private Long getTotalAmount(Integer cashSum, Integer rebateSum) {
        if (cashSum != null && rebateSum != null) {
            return cashSum + rebateSum;
        }
        if (cashSum != null) {
            return (long)cashSum;
        }
        if (rebateSum != null) {
            return (long)rebateSum;
        }
        return null;
    }
}

