/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.finance;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.finance.FinanceDetailDto;
import com.qiho.center.api.dto.merchant.MerchantDto;
import com.qiho.center.api.enums.finance.FinanceDetailStatusEnum;
import com.qiho.center.api.enums.finance.FinanceOptTypeEnum;
import com.qiho.center.api.enums.finance.FinanceTypeEnum;
import com.qiho.center.api.params.finance.BaiqiMerchantFreetextParam;
import com.qiho.center.biz.service.agent.BaiqiAgentService;
import com.qiho.center.biz.service.finance.FinanceDetailService;
import com.qiho.center.biz.service.merchant.MerchantService;
import com.qiho.center.common.daoh.qiho.finance.BaiqiFinanceDetailMapper;
import com.qiho.center.common.entityd.qiho.agent.BaiqiAgentEntity;
import com.qiho.center.common.entityd.qiho.finance.BaiqiFinanceDetailEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FinanceDetailServiceImpl
implements FinanceDetailService {
    @Autowired
    private BaiqiFinanceDetailMapper financeDetailMapper;
    @Resource
    private MerchantService merchantService;
    @Resource
    private BaiqiAgentService baiqiAgentService;

    @Override
    public PagenationDto<FinanceDetailDto> findByParams(BaiqiMerchantFreetextParam params) {
        PagenationDto pagenationDto = new PagenationDto();
        this.splitMerchantOrAgent((PagenationDto<FinanceDetailDto>)pagenationDto, params);
        return pagenationDto;
    }

    @Override
    public Long insert(FinanceDetailDto financeDetailDto) {
        BaiqiFinanceDetailEntity entity = (BaiqiFinanceDetailEntity)BeanUtils.copy((Object)financeDetailDto, BaiqiFinanceDetailEntity.class);
        entity.setOperatorType(financeDetailDto.getOperatorType().getNum());
        entity.setState(financeDetailDto.getState().getNum());
        return this.financeDetailMapper.insert(entity);
    }

    @Override
    public PagenationDto<FinanceDetailDto> findFinanceDetailByMerchantId(BaiqiMerchantFreetextParam pageParam) {
        List list = this.financeDetailMapper.selectFinanceDetailByMerchantId(pageParam);
        ArrayList resultList = Lists.newArrayList();
        for (BaiqiFinanceDetailEntity entity : list) {
            FinanceDetailDto financeDetailDto = (FinanceDetailDto)BeanUtils.copy((Object)entity, FinanceDetailDto.class);
            financeDetailDto.setOperatorType(FinanceOptTypeEnum.getByNum((Integer)entity.getOperatorType()));
            resultList.add(financeDetailDto);
        }
        PagenationDto pagenationDto = new PagenationDto();
        pagenationDto.setList((List)resultList);
        int total = this.financeDetailMapper.countFinanceDetailByMerchantId(pageParam);
        pagenationDto.setTotal(Integer.valueOf(total));
        return pagenationDto;
    }

    private void splitMerchantOrAgent(PagenationDto<FinanceDetailDto> pagenationDto, BaiqiMerchantFreetextParam param) {
        List entities;
        if (param.getRelationType() == 0) {
            param.setRelationType(null);
        }
        if (CollectionUtils.isEmpty((Collection)(entities = this.financeDetailMapper.findByParams(param)))) {
            pagenationDto.setList(Collections.emptyList());
            pagenationDto.setTotal(Integer.valueOf(0));
            return;
        }
        ArrayList<Long> merchantIds = new ArrayList<Long>();
        ArrayList<Long> agentIds = new ArrayList<Long>();
        this.setRelationIds(merchantIds, agentIds, entities);
        Map<Object, Object> merchantDtoMap = new HashMap();
        Map<Object, Object> agentMap = new HashMap();
        if (CollectionUtils.isNotEmpty(merchantIds)) {
            merchantDtoMap = this.merchantService.findByIdList(merchantIds);
        }
        if (CollectionUtils.isNotEmpty(agentIds)) {
            agentMap = this.baiqiAgentService.findByIdsMap(agentIds);
        }
        ArrayList<FinanceDetailDto> detailDtos = new ArrayList<FinanceDetailDto>();
        for (BaiqiFinanceDetailEntity entity : entities) {
            Long relationId = entity.getRelationId();
            int accountType = entity.getRelationType();
            FinanceDetailDto detailDto = this.entityToDto(entity);
            if (accountType == FinanceTypeEnum.AGENT_ACCOUNT.getCode()) {
                BaiqiAgentEntity agentEntity = (BaiqiAgentEntity)agentMap.get(relationId);
                detailDto.setName(agentEntity == null ? null : agentEntity.getAgentName());
            } else {
                MerchantDto merchantDto = (MerchantDto)merchantDtoMap.get(relationId);
                detailDto.setName(merchantDto == null ? null : merchantDto.getMerchantName());
            }
            detailDtos.add(detailDto);
        }
        Integer count = this.financeDetailMapper.count(param);
        pagenationDto.setTotal(count);
        pagenationDto.setList(detailDtos);
    }

    private FinanceDetailDto entityToDto(BaiqiFinanceDetailEntity entity) {
        FinanceDetailDto financeDetailDto = (FinanceDetailDto)BeanUtils.copy((Object)entity, FinanceDetailDto.class);
        financeDetailDto.setRelationType(FinanceTypeEnum.getByCode((Integer)entity.getRelationType()));
        financeDetailDto.setState(FinanceDetailStatusEnum.getByNum((Integer)entity.getState()));
        financeDetailDto.setOperatorType(FinanceOptTypeEnum.getByNum((Integer)entity.getOperatorType()));
        return financeDetailDto;
    }

    private void setRelationIds(List<Long> merchantIds, List<Long> agentIds, List<BaiqiFinanceDetailEntity> entities) {
        for (BaiqiFinanceDetailEntity entity : entities) {
            int accountType = entity.getRelationType();
            Long relationId = entity.getRelationId();
            if (accountType == FinanceTypeEnum.AGENT_ACCOUNT.getCode()) {
                agentIds.add(relationId);
                continue;
            }
            merchantIds.add(relationId);
        }
    }
}

