/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.finance;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.finance.AllocateAmountDto;
import com.qiho.center.api.dto.finance.FinanceDto;
import com.qiho.center.api.dto.merchant.MerchantDto;
import com.qiho.center.api.enums.account.BaiqiAccountTypeEnum;
import com.qiho.center.api.enums.finance.FinanceStatusEnum;
import com.qiho.center.api.enums.finance.FinanceTypeEnum;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.api.params.PageQueryParams;
import com.qiho.center.biz.service.agent.BaiqiAgentService;
import com.qiho.center.biz.service.finance.FinanceService;
import com.qiho.center.biz.service.merchant.MerchantService;
import com.qiho.center.common.daoh.qiho.finance.BaiqiFinanceMapper;
import com.qiho.center.common.entityd.qiho.agent.BaiqiAgentEntity;
import com.qiho.center.common.entityd.qiho.finance.BaiqiFinanceEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class FinanceServiceImpl
implements FinanceService {
    @Resource
    private BaiqiFinanceMapper baiqiFinanceMapper;
    @Resource
    private MerchantService merchantService;
    @Resource
    private BaiqiAgentService baiqiAgentService;

    @Override
    public Boolean insertFinance(FinanceDto dto) {
        if (dto.getRelationType() == null || dto.getRelationId() == null) {
            throw new QihoException("\u8d44\u91d1\u8d26\u6237\u672a\u6307\u5b9a\u5546\u5bb6\u6216\u4ee3\u7406\u5546");
        }
        BaiqiFinanceEntity entity = new BaiqiFinanceEntity();
        entity.setRelationType(Integer.valueOf(dto.getRelationType().getCode()));
        return this.baiqiFinanceMapper.insertAccountFinance(entity) > 0;
    }

    @Override
    public PagenationDto<FinanceDto> findAll(PageQueryParams pageParam) {
        List entities = this.baiqiFinanceMapper.findAll(pageParam);
        Integer count = this.baiqiFinanceMapper.countPageMainAccount(pageParam);
        PagenationDto pagenationDto = new PagenationDto();
        if (CollectionUtils.isEmpty((Collection)entities)) {
            pagenationDto.setList(Collections.emptyList());
            pagenationDto.setTotal(Integer.valueOf(0));
            return pagenationDto;
        }
        pagenationDto.setTotal(Integer.valueOf(entities.size()));
        ArrayList<Long> merchantIds = new ArrayList<Long>();
        ArrayList<Long> agentIds = new ArrayList<Long>();
        this.setRelationIds(merchantIds, agentIds, entities);
        Map<Object, Object> merchantDtoMap = new HashMap();
        Map<Object, Object> agentMap = new HashMap();
        if (CollectionUtils.isNotEmpty(merchantIds)) {
            merchantDtoMap = this.merchantService.findByIdList(merchantIds);
        }
        if (CollectionUtils.isNotEmpty(agentIds)) {
            agentMap = this.baiqiAgentService.findByIdsMap(agentIds);
        }
        ArrayList<FinanceDto> financeDtos = new ArrayList<FinanceDto>();
        for (BaiqiFinanceEntity entity : entities) {
            Long relationId = entity.getRelationId();
            int relationType = entity.getRelationType();
            FinanceDto accountDto = this.entityToDto(entity);
            if (relationType == FinanceTypeEnum.AGENT_ACCOUNT.getCode()) {
                BaiqiAgentEntity agentEntity = (BaiqiAgentEntity)agentMap.get(relationId);
                accountDto.setName(agentEntity == null ? null : agentEntity.getAgentName());
            } else {
                MerchantDto merchantDto = (MerchantDto)merchantDtoMap.get(relationId);
                accountDto.setName(merchantDto == null ? null : merchantDto.getMerchantName());
            }
            financeDtos.add(accountDto);
        }
        pagenationDto.setList(financeDtos);
        pagenationDto.setTotal(count);
        return pagenationDto;
    }

    @Override
    public Boolean allocateAmount(AllocateAmountDto allocateAmountDto) {
        Assert.notNull((Object)allocateAmountDto, (String)"\u4f59\u989d\u5206\u914d\u53c2\u6570\u4e3a\u7a7a");
        Assert.notNull((Object)allocateAmountDto.getIncomeAccountId(), (String)"\u8f6c\u5165\u8d26\u53f7ID\u4e3a\u7a7a");
        Assert.notNull((Object)allocateAmountDto.getExpenditureAccountId(), (String)"\u8f6c\u51fa\u8d26\u53f7ID\u4e3a\u7a7a");
        Assert.notNull((Object)allocateAmountDto.getAmount(), (String)"\u91d1\u989d\u4e3a\u7a7a");
        Assert.notNull((Object)allocateAmountDto.getOperatorType(), (String)"\u64cd\u4f5c\u7c7b\u578b\u4e3a\u7a7a");
        Assert.notNull((Object)allocateAmountDto.getCacheRedisKey(), (String)"\u7f13\u5b58RedisKey\u4e3a\u7a7a");
        return Boolean.FALSE;
    }

    private FinanceDto entityToDto(BaiqiFinanceEntity entity) {
        FinanceDto financeDto = (FinanceDto)BeanUtils.copy((Object)entity, FinanceDto.class);
        financeDto.setRelationType(FinanceTypeEnum.getByCode((Integer)entity.getRelationType()));
        financeDto.setState(FinanceStatusEnum.getByCode((int)entity.getState()));
        return financeDto;
    }

    private void setRelationIds(List<Long> merchantIds, List<Long> agentIds, List<BaiqiFinanceEntity> entities) {
        for (BaiqiFinanceEntity entity : entities) {
            int accountType = entity.getRelationType();
            Long relationId = entity.getRelationId();
            if (accountType == BaiqiAccountTypeEnum.AGENT_ACCOUNT.getCode()) {
                agentIds.add(relationId);
                continue;
            }
            merchantIds.add(relationId);
        }
    }

    @Override
    public FinanceDto findFinanceByMerchantId(long merchantId) {
        BaiqiFinanceEntity entity = this.baiqiFinanceMapper.selectByMerchantId(merchantId);
        return (FinanceDto)BeanUtils.copy((Object)entity, FinanceDto.class);
    }
}

