/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.homepage;

import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.api.dto.ItemDto;
import com.qiho.center.api.dto.homepage.TabItemDto;
import com.qiho.center.api.params.TabItemParams;
import com.qiho.center.api.params.TabItemQueryParam;
import com.qiho.center.biz.service.ItemSaleCountService;
import com.qiho.center.biz.service.ItemService;
import com.qiho.center.biz.service.homepage.TabItemService;
import com.qiho.center.biz.service.order.OrderSnapshotService;
import com.qiho.center.common.dao.QihoTabItemDAO;
import com.qiho.center.common.entity.homepage.QihoTabItemEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TabItemServiceImpl
implements TabItemService {
    @Resource
    private QihoTabItemDAO qihoTabItemDAO;
    @Resource
    private ItemService itemService;
    @Resource
    private OrderSnapshotService orderSnapshotService;
    @Resource
    private ItemSaleCountService itemSaleCountService;

    @Override
    public Integer saveTabItemList(List<TabItemParams> list) {
        if (CollectionUtils.isEmpty(list)) {
            return 0;
        }
        ArrayList entityList = Lists.newArrayList();
        list.stream().forEach(param -> {
            QihoTabItemEntity entity = this.qihoTabItemDAO.queryTabItemByTabIdAndItemId(param.getTabId(), param.getItemId());
            if (null == entity) {
                entity = new QihoTabItemEntity();
                entity.setItemId(param.getItemId());
                entity.setTabId(param.getTabId());
                entity.setDeleted(Integer.valueOf(0));
                entity.setTopPayload(Long.valueOf(0L));
                entity.setRecentlySaleNum(this.queryRecentThreeDaysSaleNum(entity.getItemId()));
                entityList.add(entity);
            }
        });
        if (CollectionUtils.isEmpty((Collection)entityList)) {
            return 0;
        }
        return this.qihoTabItemDAO.batchInsertQihoTabItem((List)entityList);
    }

    private Integer queryRecentThreeDaysSaleNum(Long itemId) {
        Date startTime = DateUtils.getStartTime((Date)DateUtils.daysAddOrSub((Date)new Date(), (int)-3));
        Date endTime = DateUtils.getStartTime((Date)new Date());
        return this.orderSnapshotService.queryItemSaleCount(itemId, startTime, endTime);
    }

    @Override
    public Integer deleteTabItemByIdList(List<Long> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return 0;
        }
        return this.qihoTabItemDAO.deleteQihoTabItem(idList);
    }

    @Override
    @Transactional(value="QIHO")
    public Integer updateTabItemTopPayloadByList(List<Long> idList, Boolean top) {
        if (CollectionUtils.isEmpty(idList)) {
            return 0;
        }
        Long maxValue = null;
        if (top.booleanValue()) {
            Long max = this.qihoTabItemDAO.selectMaxPayload();
            maxValue = null == max ? (long)idList.size() : max + (long)idList.size();
        }
        for (Long id : idList) {
            QihoTabItemEntity entity = new QihoTabItemEntity();
            entity.setId(id);
            entity.setTopPayload(Long.valueOf(top != false ? maxValue : 0L));
            this.qihoTabItemDAO.updateTabItemTopPayload(entity);
            if (!top.booleanValue()) continue;
            Long l = maxValue;
            Long l2 = maxValue = Long.valueOf(maxValue - 1L);
        }
        return idList.size();
    }

    @Override
    public List<TabItemDto> findTabItemList(TabItemQueryParam params) {
        List list = this.qihoTabItemDAO.findQihoTabItemList(params);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        LinkedHashMap map = Maps.newLinkedHashMap();
        for (QihoTabItemEntity it : list) {
            map.put(it.getItemId(), it);
        }
        List<ItemDto> dtoList = this.itemService.findItemDtoByItemIds(map.keySet());
        HashMap itemDtoMap = Maps.newHashMap();
        dtoList.stream().forEach(dto -> itemDtoMap.put(dto.getId(), dto));
        return this.converToResult(list, itemDtoMap);
    }

    private List<TabItemDto> converToResult(List<QihoTabItemEntity> list, Map<Long, ItemDto> itemDtoMap) {
        ArrayList resultList = Lists.newArrayList();
        for (QihoTabItemEntity entity : list) {
            TabItemDto dto = new TabItemDto();
            dto.setId(entity.getId());
            dto.setItemId(entity.getItemId());
            dto.setTabId(entity.getTabId());
            dto.setRecentlySaleNum(entity.getRecentlySaleNum());
            dto.setTopPayload(entity.getTopPayload());
            ItemDto itemDto = itemDtoMap.get(entity.getItemId());
            if (null == itemDto) continue;
            dto.setItemNo(itemDto.getItemNo());
            dto.setImage(itemDto.getExtParamValue("image"));
            dto.setItemName(itemDto.getItemName());
            dto.setItemShortName(itemDto.getItemShortName());
            dto.setMinPrice(itemDto.getMinPrice());
            dto.setStock(itemDto.getStock());
            dto.setItemStatus(itemDto.getItemStatus());
            resultList.add(dto);
        }
        return resultList;
    }

    @Override
    public List<ItemDto> queryTabItemIndex(TabItemQueryParam params) {
        List list = this.qihoTabItemDAO.findQihoTabItemList(params);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        LinkedHashMap map = Maps.newLinkedHashMap();
        ArrayList itemList = Lists.newArrayList();
        for (QihoTabItemEntity it : list) {
            map.put(it.getItemId(), it);
            itemList.add(it.getItemId());
        }
        List<ItemDto> dtoList = this.itemService.findItemDtoByItemIds(map.keySet());
        Map<Long, Integer> saleMap = this.itemSaleCountService.queryItemSaleNum(itemList);
        ArrayList resultList = Lists.newArrayList();
        HashMap resultMap = Maps.newHashMap();
        for (ItemDto item : dtoList) {
            if (StringUtils.equals((CharSequence)"OFF", (CharSequence)item.getItemStatus()) || item.getStock().intValue() <= 0) continue;
            item.setSaleNum(Integer.valueOf(null == saleMap.get(item.getId()) ? 0 : saleMap.get(item.getId())));
            resultMap.put(item.getId(), item);
        }
        map.entrySet().forEach(e -> {
            if (null != resultMap.get(e.getKey())) {
                resultList.add(resultMap.get(e.getKey()));
            }
        });
        return resultList;
    }

    @Override
    public List<QihoTabItemEntity> queryAllItemListByPage(int offSet, int pageSize) {
        return this.qihoTabItemDAO.queryAllItemListByPage(offSet, pageSize);
    }

    @Override
    public Integer updateTabItem(QihoTabItemEntity enitiy) {
        return this.qihoTabItemDAO.updateTabItem(enitiy);
    }
}

