/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.merchant;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.merchant.MerchantDto;
import com.qiho.center.api.dto.merchant.MerchantSimpleDto;
import com.qiho.center.api.dto.merchant.MerchantSpacialDto;
import com.qiho.center.api.enums.finance.BaiqiCommercialTenantTypeEnum;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.api.params.MerchantQueryParams;
import com.qiho.center.biz.service.merchant.MerchantService;
import com.qiho.center.common.dao.QihoMerchantDAO;
import com.qiho.center.common.daoh.qiho.finance.BaiqiFinanceMapper;
import com.qiho.center.common.entity.merchant.QihoMerchantEntity;
import com.qiho.center.common.entityd.qiho.finance.BaiqiFinanceEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MerchantServiceImpl
implements MerchantService {
    @Autowired
    private QihoMerchantDAO qihoMerchantDAO;
    @Resource
    private BaiqiFinanceMapper baiqiFinanceMapper;

    @Override
    public MerchantDto findById(Long merchantId) {
        return (MerchantDto)BeanUtils.copy((Object)this.qihoMerchantDAO.getById(merchantId), MerchantDto.class);
    }

    @Override
    @Transactional(value="QIHO")
    public Boolean saveMerchant(MerchantDto dto) {
        if (null == dto) {
            return Boolean.FALSE;
        }
        QihoMerchantEntity merchantEntity = (QihoMerchantEntity)BeanUtils.copy((Object)dto, QihoMerchantEntity.class);
        if (merchantEntity.getId() == null) {
            this.qihoMerchantDAO.insertMerchant(merchantEntity);
            this.syncCreateFinance(merchantEntity.getId());
        } else {
            this.qihoMerchantDAO.updateMerchant(merchantEntity);
        }
        return Boolean.TRUE;
    }

    private void syncCreateFinance(Long merchantId) {
        BaiqiFinanceEntity financeEntity = new BaiqiFinanceEntity();
        financeEntity.setRelationId(merchantId);
        financeEntity.setRelationType(Integer.valueOf(BaiqiCommercialTenantTypeEnum.MERCHANT.getType()));
        this.baiqiFinanceMapper.insertAccountFinance(financeEntity);
    }

    @Override
    public PagenationDto<MerchantDto> queryPage(MerchantQueryParams params) {
        PagenationDto page = new PagenationDto();
        if (params.getOffset() == null || params.getMax() == null) {
            page.setTotal(Integer.valueOf(0));
            return page;
        }
        Integer count = this.qihoMerchantDAO.countByQuery(params);
        page.setTotal(count);
        if (count == 0) {
            return page;
        }
        List merchantDtoList = BeanUtils.copyList((List)this.qihoMerchantDAO.listByQuery(params), MerchantDto.class);
        page.setList(merchantDtoList);
        return page;
    }

    @Override
    public List<MerchantDto> findByName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return new ArrayList<MerchantDto>();
        }
        return BeanUtils.copyList((List)this.qihoMerchantDAO.listByName(name.trim()), MerchantDto.class);
    }

    @Override
    public MerchantDto findByItemId(Long itemId) {
        if (itemId == null || itemId < 1L) {
            throw new QihoException("\u5546\u54c1id\u65e0\u6548");
        }
        QihoMerchantEntity entity = this.qihoMerchantDAO.getByItemId(itemId);
        return (MerchantDto)BeanUtils.copy((Object)entity, MerchantDto.class);
    }

    @Override
    public Map<Long, MerchantDto> findByIdList(List<Long> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            throw new QihoException("\u4f20\u5165id\u5217\u8868\u4e3a\u7a7a");
        }
        List qihoMerchantEntities = this.qihoMerchantDAO.listByIds(idList);
        HashMap<Long, MerchantDto> map = new HashMap<Long, MerchantDto>();
        if (CollectionUtils.isEmpty((Collection)qihoMerchantEntities)) {
            return map;
        }
        for (QihoMerchantEntity qihoMerchantEntity : qihoMerchantEntities) {
            MerchantDto merchantDto = (MerchantDto)BeanUtils.copy((Object)qihoMerchantEntity, MerchantDto.class);
            map.put(merchantDto.getId(), merchantDto);
        }
        return map;
    }

    @Override
    public List<MerchantSimpleDto> findAllIdAndNames() {
        return this.qihoMerchantDAO.findAllIdAndNames();
    }

    @Override
    public List<MerchantSimpleDto> findIdAndNamesByIds(List<Long> ids) {
        return this.qihoMerchantDAO.findIdAndNamesByIds(ids);
    }

    @Override
    public List<MerchantSpacialDto> findAll() {
        return BeanUtils.copyList((List)this.qihoMerchantDAO.findAll(), MerchantSpacialDto.class);
    }
}

