/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.monitor;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.monitor.LogisticsMonitorPlanDto;
import com.qiho.center.api.dto.monitor.LogisticsMonitorStrategyDto;
import com.qiho.center.api.params.MonitorPlanQueryParam;
import com.qiho.center.biz.service.monitor.LogisticsMonitorPlanService;
import com.qiho.center.common.daoh.qiho.QihoLogisticsMonitorPlanMapper;
import com.qiho.center.common.daoh.qiho.QihoLogisticsMonitorStrategyMapper;
import com.qiho.center.common.entityd.qiho.monitor.LogisticsMonitorPlanEntity;
import com.qiho.center.common.entityd.qiho.monitor.LogisticsMonitorStrategyEntity;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LogisticsMonitorPlanServiceImpl
implements LogisticsMonitorPlanService {
    @Resource
    private QihoLogisticsMonitorPlanMapper qihoLogisticsMonitorPlanMapper;
    @Resource
    private QihoLogisticsMonitorStrategyMapper qihoLogisticsMonitorStrategyMapper;

    @Override
    @Transactional(value="QIHO")
    public int saveLogistMonitorPlan(LogisticsMonitorPlanDto dto) {
        if (null == dto.getId()) {
            return this.createMonitorPlan(dto);
        }
        return this.updateMonitorPlan(dto);
    }

    private int updateMonitorPlan(LogisticsMonitorPlanDto dto) {
        LogisticsMonitorPlanEntity planEntity = (LogisticsMonitorPlanEntity)BeanUtils.copy((Object)dto, LogisticsMonitorPlanEntity.class);
        this.qihoLogisticsMonitorPlanMapper.update(planEntity);
        List strategyList = BeanUtils.copyList((List)dto.getStrategyDtoList(), LogisticsMonitorStrategyEntity.class);
        List strategyOldList = this.qihoLogisticsMonitorStrategyMapper.selectListByPlanId(planEntity.getId());
        HashMap strategyOldMap = Maps.newHashMap();
        ArrayList oldIdList = Lists.newArrayList();
        strategyOldList.stream().forEach(strategy -> {
            strategyOldMap.put(strategy.getId(), strategy);
            oldIdList.add(strategy.getId());
        });
        ArrayList newList = Lists.newArrayList();
        ArrayList updateList = Lists.newArrayList();
        strategyList.forEach(strategy -> {
            if (null == strategy.getId()) {
                strategy.setPlanId(planEntity.getId());
                strategy.setNextExecuteTime(planEntity.getStartTime().before(new Date()) ? new Date() : planEntity.getStartTime());
                newList.add(strategy);
            } else {
                LogisticsMonitorStrategyEntity oldStrategy = (LogisticsMonitorStrategyEntity)strategyOldMap.get(strategy.getId());
                if (null == oldStrategy.getLastExecuteTime()) {
                    strategy.setNextExecuteTime(planEntity.getStartTime().before(new Date()) ? new Date() : planEntity.getStartTime());
                } else {
                    strategy.setNextExecuteTime(DateUtils.addMinutes((Date)oldStrategy.getLastExecuteTime(), (int)strategy.getIntervalNum()));
                }
                updateList.add(strategy);
                oldIdList.remove(strategy.getId());
            }
        });
        this.deleteData(planEntity.getId(), oldIdList);
        this.addNewData(newList);
        this.updateData(updateList);
        return 1;
    }

    private void deleteData(Long id, List<Long> oldIdList) {
        if (CollectionUtils.isNotEmpty(oldIdList)) {
            HashMap param = Maps.newHashMap();
            param.put("planId", id);
            param.put("strategyIdList", oldIdList);
            this.qihoLogisticsMonitorStrategyMapper.deleteByParam((Map)param);
        }
    }

    private void updateData(List<LogisticsMonitorStrategyEntity> updateList) {
        if (CollectionUtils.isNotEmpty(updateList)) {
            this.qihoLogisticsMonitorStrategyMapper.batchUpdate(updateList);
        }
    }

    private void addNewData(List<LogisticsMonitorStrategyEntity> newList) {
        if (CollectionUtils.isNotEmpty(newList)) {
            this.qihoLogisticsMonitorStrategyMapper.batchInsert(newList);
        }
    }

    private int createMonitorPlan(LogisticsMonitorPlanDto dto) {
        LogisticsMonitorPlanEntity planEntity = (LogisticsMonitorPlanEntity)BeanUtils.copy((Object)dto, LogisticsMonitorPlanEntity.class);
        planEntity.setIsDelete(0);
        this.qihoLogisticsMonitorPlanMapper.insert(planEntity);
        List strategyList = BeanUtils.copyList((List)dto.getStrategyDtoList(), LogisticsMonitorStrategyEntity.class);
        strategyList.stream().forEach(strategy -> {
            strategy.setPlanId(planEntity.getId());
            strategy.setNextExecuteTime(planEntity.getStartTime().before(new Date()) ? new Date() : planEntity.getStartTime());
        });
        this.qihoLogisticsMonitorStrategyMapper.batchInsert(strategyList);
        return 1;
    }

    @Override
    public LogisticsMonitorPlanDto getLogisticsMonitorPlanById(Long id) {
        LogisticsMonitorPlanEntity planEntity = this.qihoLogisticsMonitorPlanMapper.selectById(id);
        LogisticsMonitorPlanDto resultDto = (LogisticsMonitorPlanDto)BeanUtils.copy((Object)planEntity, LogisticsMonitorPlanDto.class);
        List strategyList = this.qihoLogisticsMonitorStrategyMapper.selectListByPlanId(planEntity.getId());
        resultDto.setStrategyDtoList(BeanUtils.copyList((List)strategyList, LogisticsMonitorStrategyDto.class));
        return resultDto;
    }

    @Override
    public int deleteMonitorPlan(Long id) {
        return this.qihoLogisticsMonitorPlanMapper.deleteById(id);
    }

    @Override
    public PagenationDto<LogisticsMonitorPlanDto> queryPageList(MonitorPlanQueryParam queryParam) {
        PagenationDto page = new PagenationDto();
        int count = this.qihoLogisticsMonitorPlanMapper.selectPageCount(queryParam);
        page.setTotal(Integer.valueOf(count));
        if (count == 0) {
            page.setList((List)Lists.newArrayList());
            return page;
        }
        List list = this.qihoLogisticsMonitorPlanMapper.selectPageByParam(queryParam);
        page.setList(BeanUtils.copyList((List)list, LogisticsMonitorPlanDto.class));
        return page;
    }

    @Override
    public LogisticsMonitorPlanEntity queryValidMonitorPlan(String logisticsCode) {
        return this.qihoLogisticsMonitorPlanMapper.selectValidMonitorPlan(logisticsCode);
    }

    @Override
    public List<LogisticsMonitorStrategyEntity> selectStrategyListByPlanId(Long planId) {
        return this.qihoLogisticsMonitorStrategyMapper.selectListByPlanId(planId);
    }

    @Override
    public int updateStrategyExecuteTime(LogisticsMonitorStrategyEntity strategyEntity) {
        return this.qihoLogisticsMonitorStrategyMapper.updateExecuteTime(strategyEntity);
    }
}

