/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.order;

import cn.com.duiba.stock.service.api.constant.ConsumeStockTypes;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockBackendService;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.ChannelInfoDto;
import com.qiho.center.api.dto.ItemAdvertDto;
import com.qiho.center.api.dto.ItemDetailDto;
import com.qiho.center.api.dto.ItemSkuDto;
import com.qiho.center.api.dto.OrderDto;
import com.qiho.center.api.dto.OrderItemDto;
import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.enums.ErpStatusEnum;
import com.qiho.center.api.enums.ErpTypeEnum;
import com.qiho.center.api.enums.ExpressCompanyEnum;
import com.qiho.center.api.enums.FundBizTypeEnum;
import com.qiho.center.api.enums.FundStatusEnum;
import com.qiho.center.api.enums.OrderApprovalStatusEnum;
import com.qiho.center.api.enums.OrderStatusEnum;
import com.qiho.center.api.enums.PayTypeEnum;
import com.qiho.center.api.enums.coupon.CouponStatusEnum;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.api.params.CouponConsumerQuery;
import com.qiho.center.api.params.OrderAuditParams;
import com.qiho.center.api.params.OrderConsumerParam;
import com.qiho.center.api.params.OrderItemParam;
import com.qiho.center.biz.event.OrderClosedEvent;
import com.qiho.center.biz.event.OrderCreateEvent;
import com.qiho.center.biz.service.BlackListService;
import com.qiho.center.biz.service.ItemDetailRecordService;
import com.qiho.center.biz.service.ItemService;
import com.qiho.center.biz.service.impl.OrderStockService;
import com.qiho.center.biz.service.order.OrderService;
import com.qiho.center.common.annotations.BizEventListener;
import com.qiho.center.common.dao.QihoChannelInfoDAO;
import com.qiho.center.common.dao.QihoErpOrderDAO;
import com.qiho.center.common.dao.QihoFundOrderDAO;
import com.qiho.center.common.dao.QihoItemDAO;
import com.qiho.center.common.dao.QihoItemSkuDAO;
import com.qiho.center.common.dao.QihoMerchantDAO;
import com.qiho.center.common.dao.QihoOrderDAO;
import com.qiho.center.common.dao.QihoOrderItemInfoDAO;
import com.qiho.center.common.dao.QihoOrderSnapshotDAO;
import com.qiho.center.common.dao.coupon.QihoCouponConsumerDAO;
import com.qiho.center.common.dao.coupon.QihoCouponOrderDAO;
import com.qiho.center.common.entity.coupon.QihoCouponConsumerEntity;
import com.qiho.center.common.entity.coupon.QihoCouponOrderEntity;
import com.qiho.center.common.entity.fund.QihoFundOrderEntity;
import com.qiho.center.common.entity.item.QihoItemDetailEntity;
import com.qiho.center.common.entity.item.QihoItemSkuEntity;
import com.qiho.center.common.entity.merchant.QihoMerchantEntity;
import com.qiho.center.common.entity.order.QihoChannelInfoEntity;
import com.qiho.center.common.entity.order.QihoErpOrderEntity;
import com.qiho.center.common.entity.order.QihoOrderEntity;
import com.qiho.center.common.entity.order.QihoOrderItemInfoEntity;
import com.qiho.center.common.entity.order.QihoOrderSnapshotEntity;
import com.qiho.center.common.entityd.qiho.QihoItemDetailRecordEntity;
import com.qiho.center.common.enums.SeqBizTypeEnum;
import com.qiho.center.common.support.BizEventBus;
import com.qiho.center.common.support.SequenceNoBuilder;
import com.qiho.center.common.util.AppLogUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@BizEventListener
public class OrderServiceImpl
implements OrderService {
    private static final Logger LOG = LoggerFactory.getLogger(OrderServiceImpl.class);
    @Autowired
    private QihoOrderDAO qihoOrderDAO;
    @Autowired
    private QihoOrderItemInfoDAO qihoOrderItemInfoDAO;
    @Autowired
    private QihoItemDAO qihoItemDAO;
    @Autowired
    private QihoItemSkuDAO qihoItemSkuDAO;
    @Autowired
    private QihoOrderSnapshotDAO qihoOrderSnapshotDAO;
    @Autowired
    private QihoChannelInfoDAO qihoChannelInfoDAO;
    @Autowired
    private QihoErpOrderDAO qihoErpOrderDAO;
    @Autowired
    private SequenceNoBuilder sequenceNoBuilder;
    @Autowired
    private RemoteStockService remoteStockService;
    @Autowired
    private RemoteStockBackendService remoteStockBackendService;
    @Autowired
    private BizEventBus eventBus;
    @Autowired
    private BlackListService expressBlackListService;
    @Autowired
    private QihoFundOrderDAO qihoFundOrderDAO;
    @Autowired
    private ItemService itemService;
    @Autowired
    private ItemDetailRecordService itemDetailRecordService;
    @Autowired
    private QihoMerchantDAO qihoMerchantDAO;
    private static final String LIMIT_NUMBER = "limitNumber";
    private static final Integer DEFAULT_LIMIT_NUMBER = 3;
    @Autowired
    private OrderStockService orderStockService;
    @Resource
    private QihoCouponConsumerDAO qihoCouponConsumerDAO;
    @Resource
    private QihoCouponOrderDAO qihoCouponOrderDAO;

    @Override
    @Transactional(value="QIHO")
    public String createOrder(OrderDto order, ChannelInfoDto channelInfo, String payType) {
        OrderItemDto orderItemDto = order.getOrderItem();
        String orderId = this.sequenceNoBuilder.createSeqNo(SeqBizTypeEnum.ORDER, orderItemDto.getItemId());
        QihoItemSkuEntity skuEntity = this.qihoItemSkuDAO.findById(orderItemDto.getSkuId());
        orderItemDto.setCostPrice(skuEntity.getCostPrice());
        DubboResult result = this.remoteStockService.consumeStockNum(ConsumeStockTypes.QihoTakeOrder.getType(), orderId, skuEntity.getStockId(), orderItemDto.getQuantity().intValue());
        if (result.isSuccess() || ((Boolean)result.getResult()).booleanValue()) {
            try {
                this.insertOrder(orderId, order, channelInfo, payType, order.getCouponId());
            }
            catch (Exception e) {
                this.remoteStockService.rollbackStock(ConsumeStockTypes.QihoTakeOrder.getType(), orderId);
                throw new QihoException("\u521b\u5efa\u8ba2\u5355\u5931\u8d25", (Throwable)e);
            }
            return orderId;
        }
        throw new QihoException("\u521b\u5efa\u8ba2\u5355\u5931\u8d25-\u6263\u51cf\u5e93\u5b58\u5931\u8d25");
    }

    private void insertOrder(String orderId, OrderDto order, ChannelInfoDto channelInfoDto, String payType, Long couponId) {
        QihoOrderEntity qihoOrder = (QihoOrderEntity)BeanUtils.copy((Object)order, QihoOrderEntity.class);
        qihoOrder.setOrderId(orderId);
        qihoOrder.setConsumerId(order.getMobile());
        qihoOrder.setOrderStatus(order.getOrderStatus());
        qihoOrder.setOrderApprovalStatus(OrderApprovalStatusEnum.TO_APPROVE.getCode());
        this.qihoOrderDAO.insert(qihoOrder);
        QihoOrderItemInfoEntity qihoOrderItemInfo = (QihoOrderItemInfoEntity)BeanUtils.copy((Object)order.getOrderItem(), QihoOrderItemInfoEntity.class);
        qihoOrderItemInfo.setOrderId(orderId);
        Long detailRecordId = this.itemDetailRecordService.getDetailRecordId(qihoOrderItemInfo.getItemId(), order.getPlanCode());
        qihoOrderItemInfo.setDetailRecordId(detailRecordId);
        this.qihoOrderItemInfoDAO.insert(qihoOrderItemInfo);
        QihoChannelInfoEntity qihoChannelInfo = (QihoChannelInfoEntity)BeanUtils.copy((Object)channelInfoDto, QihoChannelInfoEntity.class);
        qihoChannelInfo.setOrderId(orderId);
        qihoChannelInfo.setTuiaId(order.getTuiaId());
        qihoChannelInfo.setPlanCode(order.getPlanCode());
        this.qihoChannelInfoDAO.insert(qihoChannelInfo);
        QihoItemDetailEntity itemEntity = this.qihoItemDAO.findById(qihoOrderItemInfo.getItemId());
        QihoOrderSnapshotEntity snapshot = (QihoOrderSnapshotEntity)BeanUtils.copy((Object)qihoOrder, QihoOrderSnapshotEntity.class);
        snapshot.setItemName(qihoOrderItemInfo.getItemName());
        snapshot.setItemShortName(qihoOrderItemInfo.getItemShortName());
        snapshot.setItemId(qihoOrderItemInfo.getItemId());
        snapshot.setItemNo(qihoOrderItemInfo.getItemNo());
        snapshot.setDelivery(qihoOrderItemInfo.getDelivery());
        snapshot.setSellingPrice(qihoOrderItemInfo.getSellingPrice());
        snapshot.setOriginalPrice(qihoOrderItemInfo.getOriginalPrice());
        snapshot.setQuantity(qihoOrderItemInfo.getQuantity());
        snapshot.setSkuName(qihoOrderItemInfo.getSkuName());
        snapshot.setSkuNo(qihoOrderItemInfo.getSkuNo());
        snapshot.setChannelId(qihoChannelInfo.getChannelId());
        snapshot.setCountChannelId(qihoChannelInfo.getCountChannelId());
        snapshot.setUrl(qihoChannelInfo.getUrl());
        snapshot.setIp(qihoChannelInfo.getIp());
        snapshot.setUserAgent(qihoChannelInfo.getUserAgent());
        snapshot.setTuiaId(qihoChannelInfo.getTuiaId());
        QihoMerchantEntity qihoMerchantEntity = this.qihoMerchantDAO.getByItemId(qihoOrderItemInfo.getItemId());
        if (qihoMerchantEntity != null) {
            snapshot.setMerchantId(qihoMerchantEntity.getId());
        }
        JSONObject json = JSON.parseObject((String)itemEntity.getExtParam());
        snapshot.setImage(json.getString("image"));
        snapshot.setOrderApprovalStatus(OrderApprovalStatusEnum.TO_APPROVE.getCode());
        snapshot.setItemCost(qihoOrderItemInfo.getCostPrice());
        snapshot.setPayType(payType);
        snapshot.setFundStatus(FundStatusEnum.TO_PAY.getCode());
        this.qihoOrderSnapshotDAO.insert(snapshot);
        QihoFundOrderEntity entity = new QihoFundOrderEntity();
        entity.setOrderId(orderId);
        OrderItemDto item = order.getOrderItem();
        String fundId = this.sequenceNoBuilder.createSeqNo(SeqBizTypeEnum.FUND, item.getItemId());
        entity.setFundId(fundId);
        entity.setPayType(payType);
        entity.setAmt(order.getOrderAmt());
        entity.setFundStatus(FundStatusEnum.TO_PAY.getCode());
        entity.setBizType(FundBizTypeEnum.PAY.getCode());
        this.qihoFundOrderDAO.initFundOrder(entity);
        OrderCreateEvent event = new OrderCreateEvent();
        OrderSnapshotDto orderSnapshotDto = (OrderSnapshotDto)BeanUtils.copy((Object)snapshot, OrderSnapshotDto.class);
        orderSnapshotDto.setCouponId(couponId);
        this.updateCouponBeUse(orderSnapshotDto);
        event.setOrderSnapshot(orderSnapshotDto);
        event.setTokenId(channelInfoDto.getTokenId());
        this.eventBus.post((Object)event);
    }

    private void updateCouponBeUse(OrderSnapshotDto orderSnapshotDto) {
        Long couponId = orderSnapshotDto.getCouponId();
        if (couponId == null) {
            return;
        }
        String orderId = orderSnapshotDto.getOrderId();
        String mobile = orderSnapshotDto.getMobile();
        CouponConsumerQuery query = new CouponConsumerQuery();
        query.setCouponId(couponId);
        query.setMobile(mobile);
        List list = this.qihoCouponConsumerDAO.findByQuery(query);
        if (CollectionUtils.isEmpty((Collection)list)) {
            AppLogUtil.error((Logger)LOG, (String)"\u8ba2\u5355\u6d88\u8d39\u4f18\u60e0\u5238\u5f02\u5e38,\u4f18\u60e0\u5238\u4fe1\u606f\u67e5\u8be2\u4e0d\u5230 orderId={},couponId={}", (Object[])new Object[]{orderId, couponId});
            return;
        }
        QihoCouponConsumerEntity oldEntity = (QihoCouponConsumerEntity)list.get(0);
        QihoCouponConsumerEntity couponConsumer = new QihoCouponConsumerEntity();
        couponConsumer.setCouponStatus(CouponStatusEnum.BE_USE.getVal());
        couponConsumer.setOrderId(orderId);
        couponConsumer.setEmployTime(new Date());
        couponConsumer.setCouponId(couponId);
        couponConsumer.setMobile(mobile);
        this.qihoCouponConsumerDAO.update(couponConsumer);
        QihoCouponOrderEntity couponOrderEntity = new QihoCouponOrderEntity();
        couponOrderEntity.setCouponId(couponId);
        couponOrderEntity.setOrderId(orderId);
        couponOrderEntity.setCouponType(oldEntity.getCouponType());
        couponOrderEntity.setCouponVal(oldEntity.getCouponVal());
        couponOrderEntity.setEmployConditType(oldEntity.getEmployConditType());
        couponOrderEntity.setEmployConditThreshold(oldEntity.getEmployConditThreshold());
        this.qihoCouponOrderDAO.insert(couponOrderEntity);
    }

    @Override
    @Transactional(value="QIHO")
    public Boolean auditOrder(OrderAuditParams params) {
        Integer result;
        QihoOrderEntity order = this.qihoOrderDAO.findByOrderId(params.getOrderId());
        if (!StringUtils.equals((CharSequence)order.getOrderStatus(), (CharSequence)OrderStatusEnum.TO_APPROVE.getCode())) {
            AppLogUtil.warn((Logger)LOG, (String)"\u53ea\u80fd\u5ba1\u6838\u5f85\u5ba1\u6279\u72b6\u6001\u7684\u8ba2\u5355, orderId={}", (Object[])new Object[]{order.getOrderId()});
            return false;
        }
        switch (params.getAuditResult()) {
            case 1: {
                result = this.auditOrderToSuccess(params, order);
                break;
            }
            case 0: {
                result = this.auditOrderToFailed(params);
                break;
            }
            default: {
                throw new QihoException("\u8ba2\u5355\u5ba1\u6838\u53c2\u6570\u5f02\u5e38");
            }
        }
        return result == 1;
    }

    private Integer auditOrderToFailed(OrderAuditParams params) {
        Integer result = this.qihoOrderDAO.auditOrderToFailed(params);
        QihoOrderSnapshotEntity orderSnapshot = new QihoOrderSnapshotEntity();
        orderSnapshot.setOrderId(params.getOrderId());
        orderSnapshot.setRemark(params.getRemark());
        orderSnapshot.setOrderStatus(OrderStatusEnum.CLOSED.getCode());
        orderSnapshot.setOrderApprovalStatus(OrderApprovalStatusEnum.APPROVE_FAILD.getCode());
        orderSnapshot.setFundStatus(FundStatusEnum.FAILED.getCode());
        this.qihoOrderSnapshotDAO.updateByOrderId(orderSnapshot);
        List list = this.qihoFundOrderDAO.findByOrderIdAndBizType(params.getOrderId(), FundBizTypeEnum.PAY.getCode());
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            QihoFundOrderEntity fund = (QihoFundOrderEntity)list.get(0);
            if (StringUtils.equals((CharSequence)PayTypeEnum.COD.getCode(), (CharSequence)fund.getPayType())) {
                this.qihoFundOrderDAO.updateFundOrderStatus(fund.getFundId(), FundStatusEnum.FAILED.getCode());
            }
        }
        if (result == 1) {
            this.orderStockService.returnSkuStockByOrderId(params.getOrderId());
        }
        OrderClosedEvent orderClosedEvent = new OrderClosedEvent();
        orderClosedEvent.setOrderId(params.getOrderId());
        this.eventBus.post((Object)orderClosedEvent);
        return result;
    }

    private Integer auditOrderToSuccess(OrderAuditParams params, QihoOrderEntity order) {
        Integer result = this.qihoOrderDAO.auditOrderToSuccess(params);
        this.qihoOrderSnapshotDAO.updateOrderStatus(params.getOrderId(), params.getRemark(), OrderStatusEnum.TO_SEND, OrderApprovalStatusEnum.APPROVE_SUCCESS, null);
        QihoOrderItemInfoEntity itemEntity = this.qihoOrderItemInfoDAO.findByOrderId(params.getOrderId());
        QihoErpOrderEntity erpOrder = new QihoErpOrderEntity();
        erpOrder.setOrderId(order.getOrderId());
        erpOrder.setDelivery(itemEntity.getDelivery());
        erpOrder.setItemId(itemEntity.getItemId());
        erpOrder.setItemName(itemEntity.getItemName());
        erpOrder.setItemNo(itemEntity.getItemNo());
        erpOrder.setSkuNo(itemEntity.getSkuNo());
        erpOrder.setConsumerName(order.getConsumerName());
        erpOrder.setMobile(order.getMobile());
        erpOrder.setProvince(order.getProvince());
        erpOrder.setCity(order.getCity());
        erpOrder.setDistrict(order.getDistrict());
        erpOrder.setAddress(order.getAddress());
        erpOrder.setErpType(ErpTypeEnum.SEND.getCode());
        erpOrder.setErpId(this.sequenceNoBuilder.createSeqNo(SeqBizTypeEnum.ERP, itemEntity.getItemId()));
        erpOrder.setErpStatus(ErpStatusEnum.TO_NOTIFY.getCode());
        this.qihoErpOrderDAO.createErpOrder(erpOrder);
        return result;
    }

    @Override
    public OrderDto findByOrderId(String orderId) {
        QihoOrderEntity qihoOrderEntity = this.qihoOrderDAO.findByOrderId(orderId);
        OrderDto orderDto = (OrderDto)BeanUtils.copy((Object)qihoOrderEntity, OrderDto.class);
        QihoOrderItemInfoEntity qihoOrderItemInfoEntity = this.qihoOrderItemInfoDAO.findByOrderId(orderId);
        OrderItemDto orderItemDto = (OrderItemDto)BeanUtils.copy((Object)qihoOrderItemInfoEntity, OrderItemDto.class);
        orderDto.setOrderItem(orderItemDto);
        return orderDto;
    }

    @Override
    public void updateOrderItem(OrderItemParam param) {
        QihoOrderEntity order = this.qihoOrderDAO.findByOrderId(param.getOrderId());
        if (!StringUtils.equals((CharSequence)order.getOrderStatus(), (CharSequence)OrderStatusEnum.TO_APPROVE.getCode())) {
            throw new QihoException("\u66f4\u65b0\u8ba2\u5355\u5546\u54c1\u8be6\u60c5\u5931\u8d25\uff0c\u8ba2\u5355\u72b6\u6001\u9519\u8bef\uff0corderId=" + param.getOrderId() + ", status=" + order.getOrderStatus());
        }
        this.checkLimitNumber(param);
        Long decreaseStockId = StringUtils.isBlank((CharSequence)param.getDecreaseStockId()) ? null : Long.valueOf(param.getDecreaseStockId());
        Integer decreaseStock = param.getDecreaseStock();
        Long increaseStockId = StringUtils.isBlank((CharSequence)param.getIncreaseStockId()) ? null : Long.valueOf(param.getIncreaseStockId());
        Integer increaseStock = param.getIncreaseStock();
        if (decreaseStockId != null && decreaseStock != null) {
            this.remoteStockBackendService.decreaseItemStock(decreaseStockId.longValue(), (long)decreaseStock.intValue());
        }
        if (increaseStockId != null && increaseStock != null) {
            this.remoteStockBackendService.increaseItemStock(increaseStockId.longValue(), (long)increaseStock.intValue());
        }
        try {
            this.updateOrderItemInTransaction(param);
        }
        catch (Exception e) {
            if (decreaseStockId != null && decreaseStock != null) {
                this.remoteStockBackendService.increaseItemStock(decreaseStockId.longValue(), (long)decreaseStock.intValue());
            }
            if (increaseStockId != null && increaseStock != null) {
                this.remoteStockBackendService.decreaseItemStock(increaseStockId.longValue(), (long)increaseStock.intValue());
            }
            throw new QihoException("\u66f4\u65b0\u8ba2\u5355\u5546\u54c1\u8be6\u60c5\u5931\u8d25\uff0cparam=" + param, (Throwable)e);
        }
    }

    private void checkLimitNumber(OrderItemParam param) {
        QihoOrderItemInfoEntity qihoOrderItemInfoentity = this.qihoOrderItemInfoDAO.findByOrderId(param.getOrderId());
        ItemDetailDto itemDetailDto = this.itemService.queryItemDetail(qihoOrderItemInfoentity.getItemId());
        Integer limitNumber = itemDetailDto.getExtParam().get(LIMIT_NUMBER) == null ? DEFAULT_LIMIT_NUMBER : Integer.valueOf((String)itemDetailDto.getExtParam().get(LIMIT_NUMBER));
        if (param.getQuantity() > limitNumber) {
            throw new QihoException("\u66f4\u65b0\u8ba2\u5355\u5546\u54c1\u8be6\u60c5\u5931\u8d25\uff0c\u5546\u54c1\u8d2d\u4e70\u6570\u91cf\u8d85\u8fc7\u9650\u8d2d\u4ef6\u6570\uff0corderId=" + param.getOrderId() + ",\u5546\u54c1\u9650\u8d2d" + limitNumber + "\u4ef6");
        }
    }

    @Transactional(value="QIHO")
    public void updateOrderItemInTransaction(OrderItemParam param) {
        QihoOrderItemInfoEntity qihoOrderItemInfo = new QihoOrderItemInfoEntity();
        qihoOrderItemInfo.setOrderId(param.getOrderId());
        qihoOrderItemInfo.setSkuId(param.getSkuId());
        qihoOrderItemInfo.setSkuName(param.getSkuName());
        qihoOrderItemInfo.setSkuNo(param.getSkuNo());
        qihoOrderItemInfo.setSellingPrice(param.getSellingPrice());
        qihoOrderItemInfo.setOriginalPrice(param.getOriginalPrice());
        qihoOrderItemInfo.setQuantity(param.getQuantity());
        this.qihoOrderItemInfoDAO.updateByOrderId(qihoOrderItemInfo);
        Integer orderAmt = param.getSellingPrice() * param.getQuantity();
        this.qihoOrderDAO.updateOrderAmt(param.getOrderId(), orderAmt);
        QihoOrderSnapshotEntity orderSnapshot = (QihoOrderSnapshotEntity)BeanUtils.copy((Object)param, QihoOrderSnapshotEntity.class);
        orderSnapshot.setOrderAmt(orderAmt);
        this.qihoOrderSnapshotDAO.updateByOrderId(orderSnapshot);
    }

    @Override
    @Transactional(value="QIHO")
    public void updateOrderConsumer(OrderConsumerParam param) {
        QihoOrderEntity order = this.qihoOrderDAO.findByOrderId(param.getOrderId());
        if (!StringUtils.equals((CharSequence)order.getOrderStatus(), (CharSequence)OrderStatusEnum.TO_APPROVE.getCode())) {
            LOG.warn("\u66f4\u65b0\u8ba2\u5355\u4e70\u5bb6\u4fe1\u606f\u5931\u8d25\uff0c\u8ba2\u5355\u72b6\u6001\u9519\u8bef\uff0corderId={},status={}", (Object)param.getOrderId(), (Object)order.getOrderStatus());
            throw new QihoException("\u64cd\u4f5c\u5931\u8d25");
        }
        Long blackId = this.expressBlackListService.findOneBlack(ExpressCompanyEnum.YTO, param.getAreaNum());
        if (blackId != null) {
            LOG.warn("\u66f4\u65b0\u8ba2\u5355\u4e70\u5bb6\u4fe1\u606f\u5931\u8d25\uff0c\u5bc4\u9001\u5730\u5740\u4e0d\u5728\u8d27\u5230\u4ed8\u6b3e\u914d\u9001\u533a\u57df\u5185\uff0corderId={}, \u884c\u653f\u533a\u5212\u4ee3\u7801={}", (Object)param.getOrderId(), (Object)param.getAreaNum());
            throw new QihoException("\u4e0b\u5355\u5931\u8d25\uff01\u60a8\u7684\u5bc4\u9001\u5730\u5740\u4e0d\u5728\u8d27\u5230\u4ed8\u6b3e\u914d\u9001\u533a\u57df\u5185\uff0c\u6682\u65f6\u65e0\u6cd5\u4e0b\u5355!");
        }
        QihoOrderEntity updateOrder = (QihoOrderEntity)BeanUtils.copy((Object)param, QihoOrderEntity.class);
        this.qihoOrderDAO.updateByOrderId(updateOrder);
        QihoOrderSnapshotEntity orderSnapshot = (QihoOrderSnapshotEntity)BeanUtils.copy((Object)param, QihoOrderSnapshotEntity.class);
        this.qihoOrderSnapshotDAO.updateByOrderId(orderSnapshot);
    }

    @Override
    public void rejectOrder(String orderId, String remark, OrderApprovalStatusEnum orderApprovalStatusEnum) {
        this.qihoOrderDAO.rejectOrder(orderId, remark, orderApprovalStatusEnum);
    }

    @Override
    public void updateOrderStatus(String orderId, OrderStatusEnum orderStatus) {
        this.qihoOrderDAO.updateOrderStatus(orderId, orderStatus);
    }

    @Override
    @Transactional(value="QIHO")
    public boolean closeOrder(String orderId, String remark, String fundId) {
        boolean result;
        QihoOrderEntity updateOrder = new QihoOrderEntity();
        updateOrder.setOrderId(orderId);
        updateOrder.setOrderStatus(OrderStatusEnum.CLOSED.getCode());
        updateOrder.setRemark(remark);
        int num = this.qihoOrderDAO.updateByOrderId(updateOrder);
        this.qihoOrderSnapshotDAO.updateOrderStatus(orderId, remark, OrderStatusEnum.CLOSED, null, FundStatusEnum.FAILED);
        if (StringUtils.isNotBlank((CharSequence)fundId)) {
            this.qihoFundOrderDAO.updateFundOrderStatus(fundId, FundStatusEnum.FAILED.getCode());
        }
        boolean bl = result = num == 1;
        if (result) {
            this.orderStockService.returnSkuStockByOrderId(orderId);
        }
        OrderClosedEvent orderClosedEvent = new OrderClosedEvent();
        orderClosedEvent.setOrderId(orderId);
        this.eventBus.post((Object)orderClosedEvent);
        return result;
    }

    @Override
    public ItemDetailDto getOrderItemSnapshot(String orderId, Long itemId) {
        ItemDetailDto itemDetailDto = new ItemDetailDto();
        ItemDetailDto itemDetail = this.itemService.queryItemDetail(itemId);
        QihoOrderItemInfoEntity itemInfoEntity = this.qihoOrderItemInfoDAO.findByOrderId(orderId);
        itemDetailDto.setItemName(itemInfoEntity.getItemName());
        itemDetailDto.setItemShortName(itemInfoEntity.getItemShortName());
        itemDetailDto.setId(itemId);
        itemDetailDto.setItemNo(itemInfoEntity.getItemNo());
        if (null == itemInfoEntity.getDetailRecordId()) {
            ItemAdvertDto temAdvertDto = this.itemService.queryExtParamByItemId(itemId);
            itemDetailDto.setDetail(temAdvertDto.getDetail());
        } else {
            QihoItemDetailRecordEntity detailRecordEntity = this.itemDetailRecordService.selectById(itemInfoEntity.getDetailRecordId());
            itemDetailDto.setDetail(detailRecordEntity.getDetail());
        }
        ArrayList skuDtoList = Lists.newArrayList();
        ItemSkuDto skuDto = new ItemSkuDto();
        skuDto.setSellingPrice(itemInfoEntity.getSellingPrice());
        skuDto.setOriginalPrice(itemInfoEntity.getOriginalPrice());
        skuDto.setCostPrice(itemInfoEntity.getCostPrice());
        skuDto.setSkuName(itemInfoEntity.getSkuName());
        skuDto.setId(itemInfoEntity.getSkuId());
        skuDtoList.add(skuDto);
        itemDetailDto.setSkuList((List)skuDtoList);
        itemDetailDto.setPriceText(null == itemDetail ? "" : itemDetail.getPriceText());
        return itemDetailDto;
    }

    @Override
    public Long queryMonitorOrderCount(String orderStatus, Date startTime, Date endTime, List<String> provinceList) {
        Long count = this.qihoOrderDAO.queryMonitorOrderCount(orderStatus, startTime, endTime, provinceList);
        return null == count ? 0L : count;
    }

    @Override
    public OrderDto getLastOrderByMobile(String mobile) {
        if (StringUtils.isBlank((CharSequence)mobile)) {
            throw new QihoException("\u4f20\u5165\u7684\u624b\u673a\u53f7\u7a7a\u767d");
        }
        return (OrderDto)BeanUtils.copy((Object)this.qihoOrderDAO.getLastOrderByMobile(mobile), OrderDto.class);
    }
}

