/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.order;

import cn.com.duiba.stock.service.api.dto.StockDto;
import cn.com.duiba.stock.service.api.dto.UpdateStockReqDto;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockBackendService;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.biz.model.EdbItemStockResponse;
import com.qiho.center.biz.model.ErpStock;
import com.qiho.center.biz.service.impl.OrderStockService;
import com.qiho.center.common.daoh.qiho.QihoItemSkuMapper;
import com.qiho.center.common.daoh.qiho.QihoOrderItemInfoMapper;
import com.qiho.center.common.entityd.qiho.QihoItemSkuEntity;
import com.qiho.center.common.entityd.qiho.QihoOrderItemInfoEntity;
import com.qiho.center.common.enums.InnerLogTypeEnum;
import com.qiho.center.common.log.InnerLog;
import com.qiho.center.common.util.AppLogUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderStockServiceImpl
implements OrderStockService {
    private static final Logger logger = LoggerFactory.getLogger(OrderStockServiceImpl.class);
    @Autowired
    private QihoOrderItemInfoMapper qihoOrderItemInfoMapper;
    @Autowired
    private RemoteStockBackendService remoteStockBackendService;
    @Autowired
    QihoItemSkuMapper qihoItemSkuMapper;
    @Autowired
    private RemoteStockService remoteStockService;

    @Override
    public DubboResult<Boolean> returnSkuStockByOrderId(String orderId) {
        List list = this.qihoOrderItemInfoMapper.selectQihoOrderItemInfosByOrderId(orderId);
        ArrayList increateList = Lists.newArrayList();
        for (QihoOrderItemInfoEntity qihoOrderItemInfo : list) {
            UpdateStockReqDto reqDto = new UpdateStockReqDto();
            reqDto.setStockId(qihoOrderItemInfo.getStockId().longValue());
            reqDto.setStock((long)qihoOrderItemInfo.getQuantity().intValue());
            increateList.add(reqDto);
        }
        DubboResult result = this.remoteStockBackendService.increaseItemStockBatch((List)increateList);
        if (!result.isSuccess()) {
            AppLogUtil.warn((Logger)logger, (String)"\u8ba2\u5355{}:\u5e93\u5b58\u8fd4\u8fd8\u5931\u8d25!", (Object[])new Object[]{orderId});
            throw new QihoException("\u5e93\u5b58\u8fd4\u8fd8\u5931\u8d25!");
        }
        return result;
    }

    @Override
    public void handleEdbErpStocks(List<UpdateStockReqDto> increaseStock, List<UpdateStockReqDto> decreaseStock, List<EdbItemStockResponse> responses) {
        List paramSkuNos = responses.stream().map(EdbItemStockResponse::getBarCode).collect(Collectors.toList());
        List qihoItemSkus = this.qihoItemSkuMapper.selectALLItemSku(paramSkuNos);
        if (qihoItemSkus.isEmpty()) {
            return;
        }
        Map erpQ = this.qihoItemSkuMapper.selectErpOrderQuantityBySkuNo(paramSkuNos);
        Map ordQ = this.qihoItemSkuMapper.selectOrderQuantityBySkuNo(paramSkuNos);
        List<Long> stockIds = this.toConvertStockIds(qihoItemSkus);
        DubboResult stockDs = this.remoteStockService.findBatchByIds(stockIds);
        Map<String, QihoItemSkuEntity> qihoItemSkuMap = this.toConvertSkuMap(qihoItemSkus);
        Map<Long, StockDto> stockMaps = this.toConvertMap((DubboResult<List<StockDto>>)stockDs);
        for (EdbItemStockResponse stock : responses) {
            QihoItemSkuEntity sku = qihoItemSkuMap.get(stock.getBarCode());
            if (sku == null) continue;
            this.handlerEdbErpStock(increaseStock, decreaseStock, erpQ, ordQ, stockMaps, stock, sku);
        }
    }

    @Override
    public void handlerErpStocks(List<UpdateStockReqDto> increaseStock, List<UpdateStockReqDto> decreaseStock, List<ErpStock> stocks) {
        List<String> paramSkuNo = this.toConvert(stocks);
        List qihoItemSkus = this.qihoItemSkuMapper.selectALLItemSku(paramSkuNo);
        if (!qihoItemSkus.isEmpty()) {
            Map erpQ = this.qihoItemSkuMapper.selectErpOrderQuantityBySkuNo(paramSkuNo);
            Map ordQ = this.qihoItemSkuMapper.selectOrderQuantityBySkuNo(paramSkuNo);
            List<Long> stockIds = this.toConvertStockIds(qihoItemSkus);
            DubboResult stockDs = this.remoteStockService.findBatchByIds(stockIds);
            Map<String, QihoItemSkuEntity> qihoItemSkuMap = this.toConvertSkuMap(qihoItemSkus);
            Map<Long, StockDto> stockMaps = this.toConvertMap((DubboResult<List<StockDto>>)stockDs);
            for (ErpStock stock : stocks) {
                QihoItemSkuEntity sku = qihoItemSkuMap.get(stock.getSpecNo());
                if (sku == null) continue;
                this.handlerErpStock(increaseStock, decreaseStock, erpQ, ordQ, stockMaps, stock, sku);
            }
        }
    }

    private void handlerEdbErpStock(List<UpdateStockReqDto> increaseStock, List<UpdateStockReqDto> decreaseStock, Map<String, Map<String, BigDecimal>> erpQ, Map<String, Map<String, BigDecimal>> ordQ, Map<Long, StockDto> stockMaps, EdbItemStockResponse stock, QihoItemSkuEntity sku) {
        long erpNum = 0L;
        long orderNum = 0L;
        String paramSkuNo = stock.getBarCode();
        if (erpQ.get(paramSkuNo) != null) {
            erpNum = erpQ.get(paramSkuNo).get("quantity").longValue();
        }
        if (ordQ.get(paramSkuNo) != null) {
            orderNum = ordQ.get(paramSkuNo).get("quantity").longValue();
        }
        long quantity = erpNum + orderNum;
        long totalSkuNum = stock.getSellStock() - quantity;
        long creaseNum = 0L;
        long stockId = sku.getStockId();
        long remoteStock = stockMaps.get(stockId).getStock();
        if (totalSkuNum >= 0L) {
            creaseNum = totalSkuNum - remoteStock;
        } else {
            creaseNum -= remoteStock;
            logger.warn("\u5e93\u5b58{}\u51fa\u73b0\u8d85\u5356,\u8bf7\u68c0\u67e5\u5e93\u5b58\uff0c\u5e93\u5b58\u5df2\u7f6e\u4e3a0", (Object)stockId);
        }
        this.syncEdbStockLog(stock, quantity, creaseNum, remoteStock);
        if (creaseNum == 0L) {
            return;
        }
        UpdateStockReqDto updateStockReqDto = new UpdateStockReqDto();
        updateStockReqDto.setStockId(stockId);
        updateStockReqDto.setStock(Math.abs(creaseNum));
        if (creaseNum > 0L && this.notExist(updateStockReqDto, increaseStock)) {
            increaseStock.add(updateStockReqDto);
        } else if (creaseNum < 0L && this.notExist(updateStockReqDto, decreaseStock)) {
            decreaseStock.add(updateStockReqDto);
        }
    }

    private boolean notExist(UpdateStockReqDto updateStockReqDto, List<UpdateStockReqDto> list) {
        for (UpdateStockReqDto stockReqDto : list) {
            if (stockReqDto.getStockId() != updateStockReqDto.getStockId()) continue;
            return false;
        }
        return true;
    }

    private void handlerErpStock(List<UpdateStockReqDto> increaseStock, List<UpdateStockReqDto> decreaseStock, Map<String, Map<String, BigDecimal>> erpQ, Map<String, Map<String, BigDecimal>> ordQ, Map<Long, StockDto> stockMaps, ErpStock stock, QihoItemSkuEntity sku) {
        long erpNum = 0L;
        long orderNum = 0L;
        if (erpQ.get(stock.getSpecNo()) != null) {
            erpNum = erpQ.get(stock.getSpecNo()).get("quantity").longValue();
        }
        if (ordQ.get(stock.getSpecNo()) != null) {
            orderNum = ordQ.get(stock.getSpecNo()).get("quantity").longValue();
        }
        long quantity = erpNum + orderNum;
        long totalSkuNum = (long)stock.getStockNum() - quantity;
        long creaseNum = 0L;
        long stockId = sku.getStockId();
        long remoteStock = stockMaps.get(stockId).getStock();
        if (totalSkuNum >= 0L) {
            creaseNum = totalSkuNum - remoteStock;
        } else {
            creaseNum -= remoteStock;
            logger.warn("\u5e93\u5b58{}\u51fa\u73b0\u8d85\u5356,\u8bf7\u68c0\u67e5\u5e93\u5b58\uff0c\u5e93\u5b58\u5df2\u7f6e\u4e3a0", (Object)stockId);
        }
        this.syncStockLog(stock, quantity, creaseNum, remoteStock);
        if (creaseNum == 0L) {
            return;
        }
        UpdateStockReqDto updateStockReqDto = new UpdateStockReqDto();
        updateStockReqDto.setStockId(stockId);
        updateStockReqDto.setStock(Math.abs(creaseNum));
        if (creaseNum > 0L) {
            increaseStock.add(updateStockReqDto);
        } else if (creaseNum < 0L) {
            decreaseStock.add(updateStockReqDto);
        }
    }

    private void syncEdbStockLog(EdbItemStockResponse stock, long quantity, long creaseNum, long remoteStock) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("specNo", (Object)stock.getBarCode());
        jsonObject.put("syncStock", (Object)stock.getSellStock());
        jsonObject.put("quantity", (Object)quantity);
        jsonObject.put("systemStock", (Object)remoteStock);
        jsonObject.put("creaseNum", (Object)creaseNum);
        InnerLog.log((InnerLogTypeEnum)InnerLogTypeEnum.SYNC_STOCK_RULE, (Object)jsonObject.toJSONString());
    }

    private void syncStockLog(ErpStock stock, long quantity, long creaseNum, long remoteStock) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("specNo", (Object)stock.getSpecNo());
        jsonObject.put("syncStock", (Object)stock.getStockNum());
        jsonObject.put("quantity", (Object)quantity);
        jsonObject.put("systemStock", (Object)remoteStock);
        jsonObject.put("creaseNum", (Object)creaseNum);
        InnerLog.log((InnerLogTypeEnum)InnerLogTypeEnum.SYNC_STOCK_RULE, (Object)jsonObject.toJSONString());
    }

    private Map<String, QihoItemSkuEntity> toConvertSkuMap(List<QihoItemSkuEntity> qihoItemSkus) {
        HashMap<String, QihoItemSkuEntity> result = new HashMap<String, QihoItemSkuEntity>();
        for (QihoItemSkuEntity itemSkus : qihoItemSkus) {
            result.put(itemSkus.getSkuNo(), itemSkus);
        }
        return result;
    }

    private List<Long> toConvertStockIds(List<QihoItemSkuEntity> qihoItemSkus) {
        ArrayList<Long> result = new ArrayList<Long>();
        for (QihoItemSkuEntity itemSkus : qihoItemSkus) {
            result.add(itemSkus.getStockId());
        }
        return result;
    }

    private Map<Long, StockDto> toConvertMap(DubboResult<List<StockDto>> stockDs) {
        HashMap<Long, StockDto> result = new HashMap<Long, StockDto>();
        List list = (List)stockDs.getResult();
        for (StockDto stockDto : list) {
            result.put(stockDto.getStockID(), stockDto);
        }
        return result;
    }

    private List<String> toConvert(List<ErpStock> stocks) {
        ArrayList<String> result = new ArrayList<String>();
        for (ErpStock stock : stocks) {
            if (!StringUtils.isNotBlank((CharSequence)stock.getSpecNo())) continue;
            result.add(String.valueOf(stock.getSpecNo()));
        }
        return result;
    }
}

