/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.order;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.dto.ChannelInfoDto;
import com.qiho.center.api.dto.OrderDto;
import com.qiho.center.api.dto.OrderItemDto;
import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.dto.StrategyCheckResultDto;
import com.qiho.center.biz.engine.impl.AheadPreventOrderEngine;
import com.qiho.center.biz.service.order.OrderStrategyCheckService;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class OrderStrategyCheckServiceImpl
implements OrderStrategyCheckService {
    @Resource
    private AheadPreventOrderEngine aheadPreventOrderEngine;

    @Override
    public StrategyCheckResultDto checkStrategyAheadOrder(OrderDto order, ChannelInfoDto channelInfo, String payType) {
        StrategyCheckResultDto result = new StrategyCheckResultDto();
        result.setSuccess(true);
        try {
            OrderSnapshotDto orderSnapshotDto = (OrderSnapshotDto)BeanUtils.copy((Object)order, OrderSnapshotDto.class);
            OrderItemDto orderItemDto = order.getOrderItem();
            orderSnapshotDto.setItemId(orderItemDto.getItemId());
            orderSnapshotDto.setItemName(orderItemDto.getItemName());
            orderSnapshotDto.setItemShortName(orderItemDto.getItemShortName());
            orderSnapshotDto.setItemNo(orderItemDto.getItemNo());
            orderSnapshotDto.setSellingPrice(orderItemDto.getSellingPrice());
            orderSnapshotDto.setOriginalPrice(orderItemDto.getOriginalPrice());
            orderSnapshotDto.setQuantity(orderItemDto.getQuantity());
            orderSnapshotDto.setSkuName(orderItemDto.getSkuName());
            orderSnapshotDto.setSkuNo(orderItemDto.getSkuNo());
            orderSnapshotDto.setChannelId(channelInfo.getChannelId());
            orderSnapshotDto.setCountChannelId(channelInfo.getCountChannelId());
            orderSnapshotDto.setUrl(channelInfo.getUrl());
            orderSnapshotDto.setIp(channelInfo.getIp());
            orderSnapshotDto.setUserAgent(channelInfo.getUserAgent());
            orderSnapshotDto.setTuiaId(order.getTuiaId());
            orderSnapshotDto.setPayType(payType);
            result.setOrderSnapshotDto(orderSnapshotDto);
            return this.aheadPreventOrderEngine.process(result);
        }
        catch (Exception e) {
            return result;
        }
    }
}

