/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.order;

import cn.com.duibaboot.ext.autoconfigure.accesslog.MD5;
import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import com.google.common.eventbus.Subscribe;
import com.qiho.center.api.enums.DeliveryEnum;
import com.qiho.center.api.enums.LogisticsNameEnum;
import com.qiho.center.api.enums.LogisticsOrderStatusEnum;
import com.qiho.center.api.enums.PayTypeEnum;
import com.qiho.center.api.enums.SmsTypeEnum;
import com.qiho.center.api.exception.QihoException;
import com.qiho.center.api.params.YunPianPushParams;
import com.qiho.center.biz.event.FundInfoUpdateEvent;
import com.qiho.center.biz.event.LogisticsUpdateEvent;
import com.qiho.center.biz.process.note.SmsProcess;
import com.qiho.center.biz.process.note.SmsProcessFactory;
import com.qiho.center.biz.service.MediaWhiteListService;
import com.qiho.center.biz.service.logistics.YtoQueryProcessor;
import com.qiho.center.biz.service.order.SmsService;
import com.qiho.center.common.annotations.BizEventListener;
import com.qiho.center.common.dao.QihoOrderDAO;
import com.qiho.center.common.dao.QihoOrderSnapshotDAO;
import com.qiho.center.common.dao.QihoTemplateDAO;
import com.qiho.center.common.entity.QihoTemplateEntity;
import com.qiho.center.common.entity.order.QihoOrderSnapshotEntity;
import com.qiho.center.common.enums.SmsTemplateEnum;
import com.qiho.center.common.util.AppLogUtil;
import com.qiho.center.common.util.ShortUrlUtil;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@BizEventListener
public class SmsServiceImpl
implements SmsService {
    private static final Logger LOG = LoggerFactory.getLogger(SmsServiceImpl.class);
    @Value(value="${yunpian.sms.url}")
    private String smsUrl;
    @Value(value="${yunpian.apikey}")
    private String apikey;
    @Autowired
    private QihoOrderDAO qihoOrderDAO;
    @Autowired
    private QihoOrderSnapshotDAO qihoOrderSnapshotDAO;
    @Autowired
    private QihoTemplateDAO qihoTemplateDAO;
    @Autowired
    private YtoQueryProcessor ytoQueryProcessor;
    @Autowired
    private MediaWhiteListService mediaWhiteListService;
    @Resource
    private SmsProcessFactory smsProcessFactory;

    @Override
    public boolean sendSmsCode(String mobile, String smsCode) {
        HashMap context = Maps.newHashMap();
        context.put("code", smsCode);
        QihoTemplateEntity entity = this.qihoTemplateDAO.findByCode(SmsTemplateEnum.SMS_CODE.getCode());
        if (null != entity && entity.getTemplateEnable().booleanValue()) {
            return this.singleSend(entity, context, mobile);
        }
        return true;
    }

    @Override
    public boolean singleSend(QihoTemplateEntity templateEntity, Map<String, String> context, String mobile) {
        SmsProcess smsProcess = this.getSmsProcessByType(templateEntity);
        if (null == smsProcess) {
            throw new QihoException("\u77ed\u4fe1\u6a21\u677f\u914d\u7f6e\u6709\u8bef,\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u77ed\u4fe1\u6e20\u9053\u5904\u7406\u5668");
        }
        if (null == context) {
            return smsProcess.smsSend(templateEntity, mobile);
        }
        return smsProcess.smsSendByParam(templateEntity, context, mobile);
    }

    @Override
    public boolean singleSend(QihoTemplateEntity entity, String mobile) {
        return this.singleSend(entity, null, mobile);
    }

    @Override
    public boolean checkSign(YunPianPushParams params) {
        String signStr = this.getCheckSignFromParams(params);
        try {
            String sign = MD5.md5((String)signStr);
            return sign.equals(params.getSign());
        }
        catch (Exception e) {
            AppLogUtil.error((Logger)LOG, (String)"MD5\u52a0\u5bc6\u5f02\u5e38", (Object[])new Object[]{e});
            return false;
        }
    }

    private String getCheckSignFromParams(YunPianPushParams params) {
        StringBuilder sb = new StringBuilder();
        sb.append(params.getBaseExtend()).append(",").append(params.getExtend()).append(",").append(params.getId()).append(",").append(params.getMobile()).append(",").append(params.getReplyTime()).append(",").append(params.getText()).append(",").append(this.apikey);
        return sb.toString().trim();
    }

    @Subscribe
    public void updateLogisticsListener(LogisticsUpdateEvent event) {
        String orderId = event.getOrderId();
        QihoOrderSnapshotEntity order = this.qihoOrderSnapshotDAO.findByOrderId(orderId);
        if (Objects.equal(null, (Object)order) || StringUtils.isBlank((CharSequence)order.getMobile())) {
            LOG.info("\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c\u6216\u8005\u624b\u673a\u53f7\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u53d1\u9001\u77ed\u4fe1.orderId={}", (Object)orderId);
            return;
        }
        this.sendSms(event, order);
    }

    private void sendSms(LogisticsUpdateEvent event, QihoOrderSnapshotEntity order) {
        String mobile = order.getMobile();
        LogisticsOrderStatusEnum status = event.getLogisticsOrderStatusEnum();
        switch (status) {
            case SENT_SCAN: {
                SmsTemplateEnum sendTemplate = this.getTemplate(event, order);
                QihoTemplateEntity entity = this.qihoTemplateDAO.findByCode(sendTemplate.getCode());
                if (entity == null || !entity.getTemplateEnable().booleanValue() || null == this.getSmsProcessByType(entity)) break;
                this.getSmsProcessByType(entity).smsSendByParam(entity, event.getDeliveryMsg(), mobile);
                break;
            }
            case SUCCESS: {
                QihoTemplateEntity signedEntity = this.qihoTemplateDAO.findByCode(SmsTemplateEnum.ORDER_RECIVED.getCode());
                if (!signedEntity.getTemplateEnable().booleanValue() || null == this.getSmsProcessByType(signedEntity)) break;
                this.getSmsProcessByType(signedEntity).smsSend(signedEntity, mobile);
                break;
            }
            default: {
                LOG.info("\u4e0d\u9700\u8981\u53d1\u9001\u77ed\u4fe1\u7684\u72b6\u6001\uff0cstatus={}", (Object)status.getCode());
            }
        }
    }

    private SmsTemplateEnum getTemplate(LogisticsUpdateEvent event, QihoOrderSnapshotEntity order) {
        if (DeliveryEnum.ERP.getCode().equals(order.getDelivery()) && LogisticsNameEnum.YTO.getCode().equals(event.getLogisticsCode())) {
            return StringUtils.equals((CharSequence)order.getPayType(), (CharSequence)PayTypeEnum.COD.getCode()) ? SmsTemplateEnum.ORDER_DELIVERY : SmsTemplateEnum.ORDER_DELIVERY_PAID;
        }
        return StringUtils.equals((CharSequence)order.getPayType(), (CharSequence)PayTypeEnum.COD.getCode()) ? SmsTemplateEnum.ORDER_DELIVERY_100 : SmsTemplateEnum.ORDER_DELIVERY_PAID_100;
    }

    @Subscribe
    public void paySuccessListener(FundInfoUpdateEvent event) {
        QihoTemplateEntity paySuccessTemp;
        QihoTemplateEntity template = null;
        template = this.mediaWhiteListService.isInWhiteList(event.getOrderId()) ? this.qihoTemplateDAO.findByCode(SmsTemplateEnum.ORDER_SUCC_400.getCode()) : this.qihoTemplateDAO.findByCode(SmsTemplateEnum.ORDER_SUCCESS.getCode());
        String mobile = null;
        if (null != template && template.getTemplateEnable().booleanValue()) {
            QihoOrderSnapshotEntity order = this.qihoOrderSnapshotDAO.findByOrderId(event.getOrderId());
            mobile = order.getMobile();
            HashMap context = Maps.newHashMap();
            context.put("orderDetailUrl", ShortUrlUtil.getShortUrlByOrderId((String)event.getOrderId()));
            context.put("itemName", order.getItemShortName());
            SmsProcess smsProcess = this.getSmsProcessByType(template);
            if (null != smsProcess) {
                smsProcess.smsSendByParam(template, context, mobile);
            }
        }
        if (null != event.getPayType() && !StringUtils.equals((CharSequence)event.getPayType(), (CharSequence)PayTypeEnum.COD.getCode()) && (paySuccessTemp = this.qihoTemplateDAO.findByCode(SmsTemplateEnum.PAY_SUCCESS.getCode())).getTemplateEnable().booleanValue() && null != this.getSmsProcessByType(paySuccessTemp)) {
            this.getSmsProcessByType(paySuccessTemp).smsSend(paySuccessTemp, mobile);
        }
    }

    private SmsProcess getSmsProcessByType(QihoTemplateEntity templateEntity) {
        String smsType = templateEntity.getSmsType();
        SmsTypeEnum smsTypeEnum = SmsTypeEnum.fromCode((String)smsType);
        return this.smsProcessFactory.decidePayChannel(smsTypeEnum);
    }
}

