/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.orderexport;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.orderexport.OrderExportTemplateDto;
import com.qiho.center.api.params.orderexport.OrderExportTemplateQueryParams;
import com.qiho.center.biz.service.orderexport.OrderExportTemplateService;
import com.qiho.center.common.daoh.qiho.orderexport.QihoOrderExportTemplateFieldMapper;
import com.qiho.center.common.daoh.qiho.orderexport.QihoOrderExportTemplateMapper;
import com.qiho.center.common.entityd.qiho.orderexport.QihoOrderExportTemplateEntity;
import com.qiho.center.common.entityd.qiho.orderexport.QihoOrderExportTemplateFieldEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service(value="orderExportTemplateService")
public class OrderExportTemplateServiceImpl
implements OrderExportTemplateService {
    @Resource
    private QihoOrderExportTemplateMapper orderExportTemplateMapper;
    @Resource
    private QihoOrderExportTemplateFieldMapper orderExportTemplateFieldMapper;

    @Override
    public PagenationDto<OrderExportTemplateDto> find4Page(OrderExportTemplateQueryParams templateQueryParams) {
        String tempName = templateQueryParams.getTempName();
        Integer offset = templateQueryParams.getOffset();
        Integer max = templateQueryParams.getMax();
        PagenationDto result = new PagenationDto();
        List orderExportTemplateList = this.orderExportTemplateMapper.find4Page(tempName, offset, max);
        if (CollectionUtils.isEmpty((Collection)orderExportTemplateList)) {
            return result;
        }
        int count = this.orderExportTemplateMapper.count4Page(tempName);
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)orderExportTemplateList.size());
        orderExportTemplateList.forEach(e -> {
            OrderExportTemplateDto exportTemplateDto = this.buildTempDto((QihoOrderExportTemplateEntity)e);
            resultList.add(exportTemplateDto);
        });
        result.setTotal(Integer.valueOf(count));
        result.setList((List)resultList);
        return result;
    }

    @Override
    public Boolean save(Long id, String tempName) {
        QihoOrderExportTemplateEntity templateEntity = new QihoOrderExportTemplateEntity();
        templateEntity.setTempName(tempName);
        templateEntity.setId(id);
        if (id == null) {
            return this.orderExportTemplateMapper.insert(templateEntity) > 0;
        }
        return this.orderExportTemplateMapper.update(templateEntity) > 0;
    }

    @Override
    public Boolean deleteById(Long id) {
        Preconditions.checkNotNull((Object)id);
        this.orderExportTemplateMapper.deleteById(id);
        this.orderExportTemplateFieldMapper.deleteByTempId(id);
        return true;
    }

    @Override
    public List<OrderExportTemplateDto> findTemp4Select() {
        List allTemp = this.orderExportTemplateMapper.findAllWithIdAndName();
        return BeanUtils.copyList((List)allTemp, OrderExportTemplateDto.class);
    }

    private OrderExportTemplateDto buildTempDto(QihoOrderExportTemplateEntity templateEntity) {
        Long tempId = templateEntity.getId();
        OrderExportTemplateDto result = (OrderExportTemplateDto)BeanUtils.copy((Object)templateEntity, OrderExportTemplateDto.class);
        List templateFieldList = this.orderExportTemplateFieldMapper.findByTempId(tempId);
        if (CollectionUtils.isEmpty((Collection)templateFieldList)) {
            return result;
        }
        String outerNames = templateFieldList.stream().map(QihoOrderExportTemplateFieldEntity::getOuterName).collect(Collectors.joining("|"));
        result.setTempFields(outerNames);
        return result;
    }
}

