/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.impl.tab;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.TabDto;
import com.qiho.center.biz.service.tab.TabService;
import com.qiho.center.common.daoh.qiho.QihoTabMapper;
import com.qiho.center.common.entityd.qiho.QihoTabEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class TabServiceImpl
implements TabService {
    @Resource
    QihoTabMapper qihoTabMapper;

    @Override
    public int add(TabDto tabDto) {
        QihoTabEntity qihoTabEntity = (QihoTabEntity)BeanUtils.copy((Object)tabDto, QihoTabEntity.class);
        qihoTabEntity.setStatus("1");
        int payload = this.qihoTabMapper.findMaxPlayload();
        qihoTabEntity.setPayload(Integer.valueOf(payload + 1));
        return this.qihoTabMapper.insert(qihoTabEntity);
    }

    @Override
    public int deleteList(List<Long> ids) {
        return this.qihoTabMapper.deleteByPrimaryKeys(ids);
    }

    @Override
    public int update(TabDto tabDto) {
        QihoTabEntity tabEntity = (QihoTabEntity)BeanUtils.copy((Object)tabDto, QihoTabEntity.class);
        return this.qihoTabMapper.updateByPrimaryKeySelective(tabEntity);
    }

    @Override
    public TabDto queryDetail(Long id) {
        QihoTabEntity tabEntity = this.qihoTabMapper.selectByPrimaryKey(id);
        return (TabDto)BeanUtils.copy((Object)tabEntity, TabDto.class);
    }

    @Override
    public PagenationDto<TabDto> queryList() {
        PagenationDto pagenation = new PagenationDto();
        List list = this.qihoTabMapper.queryList();
        if (!list.isEmpty()) {
            pagenation.setList(this.convertToTabDto(list));
        } else {
            pagenation.setList(null);
        }
        return pagenation;
    }

    @Override
    public List<TabDto> queryOnList() {
        List list = this.qihoTabMapper.queryOnList();
        return this.convertToTabDto(list);
    }

    @Override
    public void sortByPayLoad(Long sortId, Integer startPayload, Integer endPayload) {
        Integer startParam;
        Integer endParam;
        int offset;
        if (Objects.equal((Object)startPayload, (Object)endPayload)) {
            return;
        }
        if (startPayload > endPayload) {
            offset = 1;
            endParam = startPayload;
            startParam = endPayload;
        } else {
            endParam = endPayload;
            startParam = startPayload;
            offset = -1;
        }
        List list = this.qihoTabMapper.findListBetweenPayload(startParam, endParam);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            QihoTabEntity tab = new QihoTabEntity();
            tab.setId(sortId);
            tab.setPayload(endPayload);
            this.qihoTabMapper.updateByPrimaryKeySelective(tab);
            ArrayList tabs = Lists.newArrayList();
            for (QihoTabEntity qihoTabEntity : list) {
                if (qihoTabEntity.getId() == sortId) continue;
                tabs.add(qihoTabEntity.getId());
            }
            this.qihoTabMapper.updateBatchByOffset((List)tabs, offset);
        }
    }

    private List<TabDto> convertToTabDto(List<QihoTabEntity> list) {
        ArrayList result = Lists.newArrayList();
        for (QihoTabEntity tabEntity : list) {
            TabDto tabDto = (TabDto)BeanUtils.copy((Object)tabEntity, TabDto.class);
            result.add(tabDto);
        }
        return result;
    }
}

