/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.logistics;

import com.google.common.collect.Lists;
import com.jd.open.api.sdk.JdException;
import com.jd.open.api.sdk.domain.etms.TraceQueryJsf.TraceDTO;
import com.jd.open.api.sdk.response.etms.LdopReceiveTraceGetResponse;
import com.qiho.center.api.dto.logistics.LogisticsProcessDto;
import com.qiho.center.api.enums.LogisticsNameEnum;
import com.qiho.center.biz.service.logistics.LogisticsQueryDecider;
import com.qiho.center.biz.service.logistics.LogisticsQueryProcessor;
import com.qiho.center.biz.service.logistics.YtoQueryProcessor;
import com.qiho.center.common.util.JDClientUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JDQueryProcessor
implements LogisticsQueryProcessor,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(YtoQueryProcessor.class);
    private static final String SUCCESS_CODE = "0";
    @Autowired
    private JDClientUtil jdClientUtil;

    @Override
    public List<LogisticsProcessDto> queryWaybillTrace(String postId) {
        ArrayList list = Lists.newArrayList();
        if (StringUtils.isBlank((String)postId)) {
            return list;
        }
        try {
            LdopReceiveTraceGetResponse response = this.jdClientUtil.executeLdopReceiveTrace(postId);
            if (SUCCESS_CODE.equals(response.getCode())) {
                List dtos = response.getQuerytraceResult().getData();
                for (int i = dtos.size() - 1; i >= 0; --i) {
                    TraceDTO dto = (TraceDTO)dtos.get(i);
                    LogisticsProcessDto logisticsProcessDto = new LogisticsProcessDto();
                    logisticsProcessDto.setWaybillNo(dto.getWaybillCode());
                    logisticsProcessDto.setProcessInfo(dto.getOpeRemark());
                    logisticsProcessDto.setUploadTime(dto.getOpeTime());
                    list.add(logisticsProcessDto);
                }
            }
        }
        catch (JdException e) {
            LOG.warn("\u67e5\u8be2\u4eac\u4e1c\u5feb\u9012\u8fd0\u5355\u8d70\u4ef6\u6d41\u7a0b\u5f02\u5e38\uff0c postId = " + postId, (Throwable)e);
        }
        return list;
    }

    public void afterPropertiesSet() throws Exception {
        LogisticsQueryDecider.registLogisticsQueryProcessor(LogisticsNameEnum.JD, this);
    }
}

