/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.menu.impl;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import com.qiho.center.api.dto.menu.AccountMenuDto;
import com.qiho.center.api.params.menu.AccountMenuParams;
import com.qiho.center.api.params.menu.MenuParams;
import com.qiho.center.biz.service.menu.AccountMenuService;
import com.qiho.center.biz.util.AccountMenuUtil;
import com.qiho.center.common.daoh.qiho.menu.BaiqiAccountMenuMapper;
import com.qiho.center.common.daoh.qiho.menu.BaiqiMenuMapper;
import com.qiho.center.common.entityd.qiho.menu.BaiqiAccountMenuEntity;
import com.qiho.center.common.entityd.qiho.menu.BaiqiMenuEntity;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class AccountMenuServiceImpl
implements AccountMenuService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccountMenuServiceImpl.class);
    @Resource
    private BaiqiMenuMapper baiqiMenuMapper;
    @Resource
    private BaiqiAccountMenuMapper baiqiAccountMenuMapper;
    @Resource(name="redisTemplate")
    private AdvancedCacheClient advancedCacheClient;

    @Override
    public Boolean saveAccountMenuList(Long accountId, Integer accountType, String accountName, List<Long> menuIdList) throws BizException {
        AccountMenuUtil.checkMasterAccount(accountType);
        if (CollectionUtils.isEmpty(menuIdList)) {
            throw new BizException("\u83dc\u5355\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        try {
            ArrayList<BaiqiAccountMenuEntity> entityList = new ArrayList<BaiqiAccountMenuEntity>();
            Date curDate = Calendar.getInstance().getTime();
            BaiqiAccountMenuEntity entity = null;
            for (Long menuId : menuIdList) {
                entity = new BaiqiAccountMenuEntity();
                entity.setGmtModified(curDate);
                entity.setGmtCreate(curDate);
                entity.setAccountId(accountId);
                entity.setMenuId(menuId);
                entityList.add(entity);
            }
            this.baiqiAccountMenuMapper.insertBatch(entityList);
            this.removeCacheLoginAndMenu(accountName);
            return Boolean.TRUE;
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u7528\u6237\u6743\u9650\u9519\u8bef\uff01", (Throwable)e);
            return Boolean.FALSE;
        }
    }

    @Override
    public Boolean updateAccountMenuList(Long accountId, Integer accountType, String accountName, List<Long> menuIdList) throws BizException {
        AccountMenuUtil.checkMasterAccount(accountType);
        if (CollectionUtils.isEmpty(menuIdList)) {
            throw new BizException("\u83dc\u5355\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        try {
            this.baiqiAccountMenuMapper.deleteByAccountId(accountId);
            this.saveAccountMenuList(accountId, accountType, accountName, menuIdList);
            return Boolean.TRUE;
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u7528\u6237\u6743\u9650\u9519\u8bef\uff01", (Throwable)e);
            return Boolean.FALSE;
        }
    }

    @Override
    public Integer deleteByAccountId(Long accountId, Integer accountType, String accountName) throws BizException {
        AccountMenuUtil.checkMasterAccount(accountType);
        this.removeCacheLoginAndMenu(accountName);
        return this.baiqiAccountMenuMapper.deleteByAccountId(accountId);
    }

    @Override
    public List<AccountMenuDto> findAll() throws BizException {
        MenuParams params = new MenuParams();
        return AccountMenuUtil.convertMenuEntityToDto(this.baiqiMenuMapper.selectByParam(params));
    }

    @Override
    public List<AccountMenuDto> findByParamAsTree(AccountMenuParams params) throws BizException {
        Assert.notNull((Object)params.getAccountId(), (String)"AccountId\u4e3a\u7a7a");
        return AccountMenuUtil.convertMenuListToTree(this.getMenuListBySubAccount(params));
    }

    private List<AccountMenuDto> getMenuListBySubAccount(AccountMenuParams params) throws BizException {
        List<AccountMenuDto> accountMenuDtoList = this.findAll();
        if (CollectionUtils.isEmpty(accountMenuDtoList)) {
            return Collections.emptyList();
        }
        AccountMenuDto accountMenuDtoAll = null;
        Iterator<AccountMenuDto> iteratorAll = accountMenuDtoList.iterator();
        while (iteratorAll.hasNext()) {
            accountMenuDtoAll = iteratorAll.next();
            if (!this.hideMenuAccountANDMerchant(accountMenuDtoAll).booleanValue()) continue;
            iteratorAll.remove();
        }
        if (-1L == params.getAccountId()) {
            return accountMenuDtoList;
        }
        List<Long> accountMenuEntityList = AccountMenuUtil.convertMenuEntityToListMenuId(this.baiqiAccountMenuMapper.selectByParam(params));
        if (CollectionUtils.isEmpty(accountMenuEntityList)) {
            return accountMenuDtoList;
        }
        for (AccountMenuDto accountMenuDto : accountMenuDtoList) {
            if (accountMenuEntityList.contains(accountMenuDto.getId())) {
                accountMenuDto.setSelected(Boolean.valueOf(true));
                continue;
            }
            accountMenuDto.setSelected(Boolean.valueOf(false));
        }
        return accountMenuDtoList;
    }

    private Boolean hideMenuAccountANDMerchant(AccountMenuDto accountMenuDto) {
        String menuCode = accountMenuDto.getMenuCode();
        if ("Account".equals(menuCode) || "SubAccount".equals(menuCode) || "Merchant".equals(menuCode) || "MerchantList".equals(menuCode)) {
            return true;
        }
        return false;
    }

    @Override
    public boolean isOperationByAccountIdAndMenuId(Long accountId, Integer accountType, Long menuId) {
        if (AccountMenuUtil.isMasterAccount(accountType)) {
            return true;
        }
        String cacheMapKey = this.getCacheMapKey(accountId, menuId);
        Map<String, Boolean> cacheMap = this.getCache(accountId);
        if (null == cacheMap) {
            cacheMap = new HashMap<String, Boolean>();
        } else if (cacheMap.containsKey(cacheMapKey)) {
            return cacheMap.get(cacheMapKey);
        }
        BaiqiMenuEntity menuEntity = this.baiqiMenuMapper.selectById(menuId);
        if (null == menuEntity || 1 == menuEntity.getDeleted()) {
            cacheMap.put(cacheMapKey, Boolean.FALSE);
            this.setCache(accountId, cacheMap);
            return cacheMap.get(cacheMapKey);
        }
        BaiqiAccountMenuEntity accountMenuEntity = this.baiqiAccountMenuMapper.selectByAccountIdAndMenuId(accountId, menuId);
        if (null == accountMenuEntity) {
            cacheMap.put(cacheMapKey, Boolean.FALSE);
            this.setCache(accountId, cacheMap);
            return cacheMap.get(cacheMapKey);
        }
        cacheMap.put(cacheMapKey, Boolean.TRUE);
        this.setCache(accountId, cacheMap);
        return cacheMap.get(cacheMapKey);
    }

    @Override
    public List<AccountMenuDto> findByAccountId(Long accountId, Integer accountType) throws BizException {
        List<AccountMenuDto> accountMenuDtoList = null;
        if (AccountMenuUtil.isMasterAccount(accountType)) {
            accountMenuDtoList = this.findByMainAccount();
        } else if (AccountMenuUtil.isSubAccount(accountType)) {
            accountMenuDtoList = this.findBySubAccount(accountId);
        } else if (AccountMenuUtil.isAgentAccount(accountType)) {
            accountMenuDtoList = this.findByAgentAccount();
        }
        return AccountMenuUtil.convertMenuListToTree(accountMenuDtoList);
    }

    private List<AccountMenuDto> findByMainAccount() throws BizException {
        List<AccountMenuDto> accountMenuDtoList = this.findAll();
        if (CollectionUtils.isEmpty(accountMenuDtoList)) {
            return Collections.emptyList();
        }
        Iterator<AccountMenuDto> iterator = accountMenuDtoList.iterator();
        String menuCode = null;
        while (iterator.hasNext()) {
            menuCode = iterator.next().getMenuCode();
            if (!"Merchant".equals(menuCode) && !"MerchantList".equals(menuCode)) continue;
            iterator.remove();
        }
        return accountMenuDtoList;
    }

    private List<AccountMenuDto> findBySubAccount(Long accountId) {
        AccountMenuParams params = new AccountMenuParams();
        params.setAccountId(accountId);
        List<Long> menuIdList = AccountMenuUtil.convertMenuEntityToListMenuId(this.baiqiAccountMenuMapper.selectByParam(params));
        if (CollectionUtils.isEmpty(menuIdList)) {
            return Collections.emptyList();
        }
        List accountMenuEntityList = this.baiqiMenuMapper.selectByParam(new MenuParams());
        if (CollectionUtils.isEmpty((Collection)accountMenuEntityList)) {
            return Collections.emptyList();
        }
        return AccountMenuUtil.convertMenuEntityToDto(accountMenuEntityList, menuIdList);
    }

    private List<AccountMenuDto> findByAgentAccount() throws BizException {
        List<AccountMenuDto> accountMenuDtoList = this.findAll();
        Iterator<AccountMenuDto> iterator = accountMenuDtoList.iterator();
        AccountMenuDto accountMenuDto = null;
        while (iterator.hasNext()) {
            accountMenuDto = iterator.next();
            if (this.isMenuAgentAccount(accountMenuDto).booleanValue()) continue;
            iterator.remove();
        }
        return accountMenuDtoList;
    }

    private Boolean isMenuAgentAccount(AccountMenuDto accountMenuDto) {
        String menuCode = accountMenuDto.getMenuCode();
        if ("PersonCenter".equals(menuCode) || "ModifyPwd".equals(menuCode) || "Merchant".equals(menuCode) || "MerchantList".equals(menuCode) || "Finance".equals(menuCode) || "FinanceDetail".equals(menuCode) || "FinanceOverview".equals(menuCode)) {
            return true;
        }
        return false;
    }

    private void removeCacheLoginAndMenu(String accountName) {
        this.advancedCacheClient.remove("BAIQI:FERRARI:USER:" + accountName);
    }

    private String getCacheMapKey(Long accountId, Long menuId) {
        return accountId + "_" + menuId;
    }

    private Map<String, Boolean> getCache(Long accountId) {
        return (Map)this.advancedCacheClient.get("BAIQI:FERRARI:USER:MENU:" + accountId);
    }

    private boolean setCache(Long accountId, Map<String, Boolean> value) {
        return this.advancedCacheClient.set("BAIQI:FERRARI:USER:MENU:" + accountId, value, 1, TimeUnit.DAYS);
    }
}

