/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.service.menu.impl;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import com.qiho.center.api.dto.menu.MenuDto;
import com.qiho.center.api.params.menu.MenuParams;
import com.qiho.center.biz.service.account.BaiqiAccountService;
import com.qiho.center.biz.service.menu.MenuService;
import com.qiho.center.common.daoh.qiho.menu.BaiqiMenuMapper;
import com.qiho.center.common.entityd.qiho.menu.BaiqiMenuEntity;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MenuServiceImpl
implements MenuService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MenuServiceImpl.class);
    @Resource
    private BaiqiMenuMapper baiqiMenuMapper;
    @Resource(name="redisTemplate")
    private AdvancedCacheClient advancedCacheClient;
    @Resource
    private BaiqiAccountService baiqiAccountService;

    @Override
    public boolean initMenu() {
        try {
            MenuDto menuDto = this.findByCode("PersonCenter");
            if (null != menuDto) {
                throw new BizException("\u83dc\u5355\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u80fd\u88ab\u521d\u59cb\u5316\u3002");
            }
            MenuDto menuPerson = new MenuDto();
            menuPerson.setParentId(Long.valueOf(0L));
            menuPerson.setMenuCode("PersonCenter");
            menuPerson.setMenuName("\u4e2a\u4eba\u4e2d\u5fc3");
            menuPerson.setRemark("\u4e2a\u4eba\u4e2d\u5fc3");
            menuPerson.setSorted(Integer.valueOf(1));
            this.saveMenu(menuPerson);
            menuPerson = this.findByCode(menuPerson.getMenuCode());
            if (null != menuPerson) {
                MenuDto menuPersonModPwd = new MenuDto();
                menuPersonModPwd.setParentId(menuPerson.getId());
                menuPersonModPwd.setMenuCode("ModifyPwd");
                menuPersonModPwd.setMenuName("\u4fee\u6539\u5bc6\u7801");
                menuPersonModPwd.setRemark("\u4fee\u6539\u5bc6\u7801");
                menuPersonModPwd.setSorted(Integer.valueOf(2));
                this.saveMenu(menuPersonModPwd);
            }
            MenuDto menuGoods = new MenuDto();
            menuGoods.setParentId(Long.valueOf(0L));
            menuGoods.setMenuCode("Goods");
            menuGoods.setMenuName("\u5546\u54c1");
            menuGoods.setRemark("\u5546\u54c1");
            menuGoods.setSorted(Integer.valueOf(3));
            this.saveMenu(menuGoods);
            menuGoods = this.findByCode(menuGoods.getMenuCode());
            if (null != menuGoods) {
                MenuDto menuGoodsManage = new MenuDto();
                menuGoodsManage.setParentId(menuGoods.getId());
                menuGoodsManage.setMenuCode("GoodsManage");
                menuGoodsManage.setMenuName("\u5546\u54c1\u7ba1\u7406");
                menuGoodsManage.setRemark("\u5546\u54c1\u7ba1\u7406");
                menuGoodsManage.setSorted(Integer.valueOf(4));
                this.saveMenu(menuGoodsManage);
            }
            MenuDto menuOrders = new MenuDto();
            menuOrders.setParentId(Long.valueOf(0L));
            menuOrders.setMenuCode("Order");
            menuOrders.setMenuName("\u8ba2\u5355");
            menuOrders.setRemark("\u8ba2\u5355");
            menuOrders.setSorted(Integer.valueOf(5));
            this.saveMenu(menuOrders);
            menuOrders = this.findByCode(menuOrders.getMenuCode());
            if (null != menuOrders) {
                MenuDto menuAllOrder = new MenuDto();
                menuAllOrder.setParentId(menuOrders.getId());
                menuAllOrder.setMenuCode("AllOrder");
                menuAllOrder.setMenuName("\u5168\u90e8\u8ba2\u5355");
                menuAllOrder.setRemark("\u5168\u90e8\u8ba2\u5355");
                menuAllOrder.setSorted(Integer.valueOf(6));
                this.saveMenu(menuAllOrder);
                MenuDto menuExamineOrder = new MenuDto();
                menuExamineOrder.setParentId(menuOrders.getId());
                menuExamineOrder.setMenuCode("ExamineOrder");
                menuExamineOrder.setMenuName("\u5f85\u5ba1\u6838\u8ba2\u5355");
                menuExamineOrder.setRemark("\u5f85\u5ba1\u6838\u8ba2\u5355");
                menuExamineOrder.setSorted(Integer.valueOf(7));
                this.saveMenu(menuExamineOrder);
                MenuDto menuErpSubOrder = new MenuDto();
                menuErpSubOrder.setParentId(menuOrders.getId());
                menuErpSubOrder.setMenuCode("ERPSubOrder");
                menuErpSubOrder.setMenuName("ERP\u5b50\u8ba2\u5355");
                menuErpSubOrder.setRemark("ERP\u5b50\u8ba2\u5355");
                menuErpSubOrder.setSorted(Integer.valueOf(8));
                this.saveMenu(menuErpSubOrder);
                MenuDto menuCustomerService = new MenuDto();
                menuCustomerService.setParentId(menuOrders.getId());
                menuCustomerService.setMenuCode("CustomerServiceOrder");
                menuCustomerService.setMenuName("\u552e\u540e\u5b50\u8ba2\u5355");
                menuCustomerService.setRemark("\u552e\u540e\u5b50\u8ba2\u5355");
                menuCustomerService.setSorted(Integer.valueOf(9));
                this.saveMenu(menuCustomerService);
            }
            MenuDto menuAccount = new MenuDto();
            menuAccount.setParentId(Long.valueOf(0L));
            menuAccount.setMenuCode("Account");
            menuAccount.setMenuName("\u8d26\u53f7");
            menuAccount.setRemark("\u8d26\u53f7");
            menuAccount.setSorted(Integer.valueOf(10));
            this.saveMenu(menuAccount);
            menuAccount = this.findByCode(menuAccount.getMenuCode());
            if (null != menuAccount) {
                MenuDto menuSubAccount = new MenuDto();
                menuSubAccount.setParentId(menuAccount.getId());
                menuSubAccount.setMenuCode("SubAccount");
                menuSubAccount.setMenuName("\u8d26\u53f7\u7ba1\u7406");
                menuSubAccount.setRemark("\u8d26\u53f7\u7ba1\u7406");
                menuSubAccount.setSorted(Integer.valueOf(11));
                this.saveMenu(menuSubAccount);
            }
            return Boolean.TRUE;
        }
        catch (Exception e) {
            LOGGER.error("\u521d\u59cb\u5316\u83dc\u5355\u9519\u8bef", (Throwable)e);
            return Boolean.FALSE;
        }
    }

    @Override
    public boolean initFinanceMenu() {
        try {
            MenuDto menuDto = this.findByCode("Finance");
            if (null != menuDto) {
                throw new BizException("\u8d22\u52a1\u83dc\u5355\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u80fd\u88ab\u521d\u59cb\u5316\u3002");
            }
            MenuDto finance = new MenuDto();
            finance.setParentId(Long.valueOf(0L));
            finance.setMenuCode("Finance");
            finance.setMenuName("\u8d22\u52a1\u4e2d\u5fc3");
            finance.setRemark("\u8d22\u52a1\u4e2d\u5fc3");
            finance.setSorted(Integer.valueOf(12));
            this.saveMenu(finance);
            finance = this.findByCode(finance.getMenuCode());
            if (null != finance) {
                MenuDto financeOverview = new MenuDto();
                financeOverview.setParentId(finance.getId());
                financeOverview.setMenuCode("FinanceOverview");
                financeOverview.setMenuName("\u8d26\u6237\u603b\u89c8");
                financeOverview.setRemark("\u8d26\u6237\u603b\u89c8");
                financeOverview.setSorted(Integer.valueOf(13));
                this.saveMenu(financeOverview);
                MenuDto financeDetail = new MenuDto();
                financeDetail.setParentId(finance.getId());
                financeDetail.setMenuCode("FinanceDetail");
                financeDetail.setMenuName("\u8d26\u6237\u660e\u7ec6");
                financeDetail.setRemark("\u8d26\u6237\u660e\u7ec6");
                financeDetail.setSorted(Integer.valueOf(14));
                this.saveMenu(financeDetail);
            }
            MenuDto merchant = new MenuDto();
            merchant.setParentId(Long.valueOf(0L));
            merchant.setMenuCode("Merchant");
            merchant.setMenuName("\u5546\u5bb6\u7ba1\u7406");
            merchant.setRemark("\u5546\u5bb6\u7ba1\u7406");
            merchant.setSorted(Integer.valueOf(15));
            this.saveMenu(merchant);
            merchant = this.findByCode(merchant.getMenuCode());
            if (null != merchant) {
                MenuDto merchantList = new MenuDto();
                merchantList.setParentId(merchant.getId());
                merchantList.setMenuCode("MerchantList");
                merchantList.setMenuName("\u5546\u5bb6\u5217\u8868");
                merchantList.setRemark("\u5546\u5bb6\u5217\u8868");
                merchantList.setSorted(Integer.valueOf(16));
                this.saveMenu(merchantList);
            }
            return Boolean.TRUE;
        }
        catch (Exception e) {
            LOGGER.error("\u521d\u59cb\u5316\u83dc\u5355\u9519\u8bef", (Throwable)e);
            return Boolean.FALSE;
        }
    }

    @Override
    public Integer saveMenu(MenuDto menuDto) throws BizException {
        BaiqiMenuEntity entity = MenuServiceImpl.menuDtoToEntity(menuDto);
        Integer result = this.baiqiMenuMapper.insert(entity);
        this.removeCacheLogin();
        return result;
    }

    @Override
    public Integer updateMenu(MenuDto menuDto) throws BizException {
        BaiqiMenuEntity entity = MenuServiceImpl.menuDtoToEntity(menuDto);
        if (null == entity) {
            return 0;
        }
        entity.setGmtModified(Calendar.getInstance().getTime());
        if (null != entity.getSorted()) {
            if (entity.getSorted() < 0) {
                entity.setSorted(Integer.valueOf(0));
            } else if (entity.getSorted() > 1000) {
                entity.setSorted(Integer.valueOf(1000));
            }
        }
        Integer result = this.baiqiMenuMapper.updateById(entity);
        this.removeCacheLogin();
        return result;
    }

    @Override
    public Integer deleteById(Long id) throws BizException {
        Integer result = this.baiqiMenuMapper.deleteById(id);
        this.removeCacheLogin();
        return result;
    }

    @Override
    public Integer deleteByCode(String code) throws BizException {
        Integer result = this.baiqiMenuMapper.deleteByCode(code);
        this.removeCacheLogin();
        return result;
    }

    @Override
    public MenuDto findByCode(String code) throws BizException {
        MenuParams params = new MenuParams();
        params.setMenuCode(code);
        List<MenuDto> menuDtoList = this.findByParam(params);
        if (CollectionUtils.isEmpty(menuDtoList)) {
            return null;
        }
        return menuDtoList.get(0);
    }

    @Override
    public List<MenuDto> findByParam(MenuParams menuParams) throws BizException {
        List entityList = this.baiqiMenuMapper.selectByParam(menuParams);
        return MenuServiceImpl.menuEntityToDto(entityList);
    }

    private void removeCacheLogin() {
        List<String> accountList = this.baiqiAccountService.findAllMainAccount();
        if (CollectionUtils.isEmpty(accountList)) {
            return;
        }
        for (String account : accountList) {
            this.advancedCacheClient.remove("BAIQI:FERRARI:USER:" + account);
        }
    }

    public static BaiqiMenuEntity menuDtoToEntity(MenuDto menuDto) {
        if (menuDto == null) {
            return null;
        }
        BaiqiMenuEntity baiqiMenuEntity = new BaiqiMenuEntity();
        baiqiMenuEntity.setId(menuDto.getId());
        baiqiMenuEntity.setParentId(menuDto.getParentId());
        baiqiMenuEntity.setMenuCode(menuDto.getMenuCode());
        baiqiMenuEntity.setMenuName(menuDto.getMenuName());
        baiqiMenuEntity.setRemark(menuDto.getRemark());
        baiqiMenuEntity.setSorted(menuDto.getSorted());
        baiqiMenuEntity.setDeleted(menuDto.getDeleted());
        baiqiMenuEntity.setGmtCreate(menuDto.getGmtCreate());
        baiqiMenuEntity.setGmtModified(menuDto.getGmtModified());
        return baiqiMenuEntity;
    }

    public static MenuDto menuEntityToDto(BaiqiMenuEntity entity) {
        if (entity == null) {
            return null;
        }
        MenuDto menuDto = new MenuDto();
        menuDto.setId(entity.getId());
        menuDto.setParentId(entity.getParentId());
        menuDto.setMenuCode(entity.getMenuCode());
        menuDto.setMenuName(entity.getMenuName());
        menuDto.setRemark(entity.getRemark());
        menuDto.setSorted(entity.getSorted());
        menuDto.setDeleted(entity.getDeleted());
        menuDto.setGmtCreate(entity.getGmtCreate());
        menuDto.setGmtModified(entity.getGmtModified());
        return menuDto;
    }

    public static List<MenuDto> menuEntityToDto(List<BaiqiMenuEntity> entityList) {
        if (null == entityList || entityList.isEmpty()) {
            return Collections.emptyList();
        }
        return entityList.stream().map(MenuServiceImpl::menuEntityToDto).collect(Collectors.toList());
    }
}

