/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.biz.util;

import cn.com.duiba.boot.exception.BizException;
import com.qiho.center.api.dto.menu.AccountMenuDto;
import com.qiho.center.api.enums.account.BaiqiAccountTypeEnum;
import com.qiho.center.common.entityd.qiho.menu.BaiqiAccountMenuEntity;
import com.qiho.center.common.entityd.qiho.menu.BaiqiMenuEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class AccountMenuUtil {
    private AccountMenuUtil() {
    }

    public static void checkMasterAccount(int accountType) throws BizException {
        if (!AccountMenuUtil.isMasterAccount(accountType)) {
            throw new BizException("\u5b50\u8d26\u53f7\u4e0d\u80fd\u64cd\u4f5c\uff01");
        }
    }

    public static boolean isMasterAccount(int accountType) {
        return BaiqiAccountTypeEnum.MAIN_ACCOUNT.getCode() == accountType;
    }

    public static boolean isSubAccount(int accountType) {
        return BaiqiAccountTypeEnum.SUB_ACCOUNT.getCode() == accountType;
    }

    public static boolean isAgentAccount(int accountType) {
        return BaiqiAccountTypeEnum.AGENT_ACCOUNT.getCode() == accountType;
    }

    public static AccountMenuDto convertMenuEntityToDto(BaiqiMenuEntity entity) {
        if (entity == null) {
            return null;
        }
        AccountMenuDto menuDto = new AccountMenuDto();
        menuDto.setId(entity.getId());
        menuDto.setParentId(entity.getParentId());
        menuDto.setMenuCode(entity.getMenuCode());
        menuDto.setMenuName(entity.getMenuName());
        return menuDto;
    }

    public static List<AccountMenuDto> convertMenuEntityToDto(List<BaiqiMenuEntity> entityList) {
        if (null == entityList || entityList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<AccountMenuDto> accountMenuDtoList = new ArrayList<AccountMenuDto>();
        for (BaiqiMenuEntity entity : entityList) {
            accountMenuDtoList.add(AccountMenuUtil.convertMenuEntityToDto(entity));
        }
        return accountMenuDtoList;
    }

    public static List<AccountMenuDto> convertMenuEntityToDto(List<BaiqiMenuEntity> entityList, List<Long> menuIdList) {
        if (CollectionUtils.isEmpty(entityList) || CollectionUtils.isEmpty(menuIdList)) {
            return Collections.emptyList();
        }
        ArrayList<AccountMenuDto> accountMenuDtoList = new ArrayList<AccountMenuDto>();
        AccountMenuDto accountMenuDto = null;
        for (BaiqiMenuEntity entity : entityList) {
            accountMenuDto = AccountMenuUtil.convertMenuEntityToDto(entity);
            if (null == accountMenuDto || !menuIdList.contains(accountMenuDto.getId())) continue;
            accountMenuDtoList.add(accountMenuDto);
        }
        return accountMenuDtoList;
    }

    public static Map<Long, AccountMenuDto> convertMenuMapEntityToDto(List<BaiqiMenuEntity> entityList) {
        if (CollectionUtils.isEmpty(entityList)) {
            return Collections.emptyMap();
        }
        LinkedHashMap<Long, AccountMenuDto> accountMenuDtoMap = new LinkedHashMap<Long, AccountMenuDto>();
        AccountMenuDto accountMenuDto = null;
        for (BaiqiMenuEntity entity : entityList) {
            accountMenuDto = AccountMenuUtil.convertMenuEntityToDto(entity);
            if (null == accountMenuDto) continue;
            accountMenuDto.setSelected(Boolean.valueOf(false));
            accountMenuDtoMap.put(entity.getId(), accountMenuDto);
        }
        return accountMenuDtoMap;
    }

    public static List<Long> convertMenuEntityToListMenuId(List<BaiqiAccountMenuEntity> accountMenuEntityList) {
        if (CollectionUtils.isEmpty(accountMenuEntityList)) {
            return Collections.emptyList();
        }
        ArrayList<Long> menuIdList = new ArrayList<Long>();
        for (BaiqiAccountMenuEntity accountMenuEntity : accountMenuEntityList) {
            menuIdList.add(accountMenuEntity.getMenuId());
        }
        return menuIdList;
    }

    public static List<AccountMenuDto> convertMenuListToTree(List<AccountMenuDto> dataList) {
        List<AccountMenuDto> parentList = AccountMenuUtil.getByParent(0L, dataList);
        if (parentList.isEmpty()) {
            return Collections.emptyList();
        }
        List<AccountMenuDto> subList = null;
        for (AccountMenuDto parentMenu : parentList) {
            subList = AccountMenuUtil.getByParent(parentMenu.getId(), dataList);
            if (CollectionUtils.isEmpty(subList)) continue;
            parentMenu.setSubMenu(subList);
        }
        return parentList;
    }

    private static List<AccountMenuDto> getByParent(Long parentId, List<AccountMenuDto> dataList) {
        ArrayList<AccountMenuDto> result = new ArrayList<AccountMenuDto>();
        Iterator<AccountMenuDto> iterator = dataList.iterator();
        AccountMenuDto accountMenuDto = null;
        while (iterator.hasNext()) {
            accountMenuDto = iterator.next();
            if (null == accountMenuDto || !parentId.equals(accountMenuDto.getParentId())) continue;
            result.add(accountMenuDto);
            iterator.remove();
        }
        return result;
    }
}

