package com.qiho.center.biz.bo;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.qiho.center.api.dto.user.WechatUserDto;
import com.qiho.center.api.enums.user.UserTypeEnum;
import com.qiho.center.biz.service.user.BaiqiUserService;
import com.qiho.center.biz.service.user.WechatUserService;
import com.qiho.center.common.constant.DsConstants;
import com.qiho.center.common.entityd.qiho.user.BaiqiUserEntity;
import com.qiho.center.common.entityd.qiho.user.WechatUserEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

import javax.annotation.Resource;

/**
 * @author peanut.huang
 * @date 2018/1/26.
 */
@Service
public class BaiqiUserBO {

    private static final Logger LOGGER = LoggerFactory.getLogger(BaiqiUserBO.class);

    @Resource
    private WechatUserService     wechatUserService;
    @Resource
    private BaiqiUserService      baiqiUserService;


    @Transactional(value = DsConstants.DATABASE_QIHO, rollbackFor = Exception.class)
    public Boolean insertWechatUser(WechatUserDto wechatUserDto){

        try {

            //open id is not exist
            Long existUserId = wechatUserService.findUserIdByMiniOpenId(wechatUserDto.getMiniOpenId());
            if(existUserId == null){

                BaiqiUserEntity userEntity = new BaiqiUserEntity();
                userEntity.setSourceType(UserTypeEnum.WECHAT.getValue());
                userEntity.setMobile(wechatUserDto.getMobile());

                baiqiUserService.insert(userEntity);

                // new userId
                Long newUserId = userEntity.getId();

                //copy
                WechatUserEntity wechatUserEntity = BeanUtils.copy(wechatUserDto, WechatUserEntity.class);

                wechatUserEntity.setUserId(newUserId);

                wechatUserService.insertUser(wechatUserEntity);
            }

            return true;
        } catch (Exception e) {
            LOGGER.error("insert wechat user faild", e);

            //rollback
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();

            return false;
        }

    }
}
