package com.qiho.center.biz.bo;

import com.qiho.center.biz.runnable.CouponActiveRunnable;
import com.qiho.center.biz.runnable.CouponRunnable;
import com.qiho.center.common.entity.coupon.QihoCouponActiveEntity;
import com.qiho.center.common.entity.coupon.QihoCouponConsumerEntity;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.concurrent.ExecutorService;

/**
 * Created by danke on 2017/11/2.
 * 优惠券的bo类,处理一些批量事件
 */
@Service
public class CouponBo implements ApplicationContextAware {

    private ApplicationContext context;

    @Resource
    private ExecutorService executorService;


    /**
     * 批量添加优惠券实体
     * @param couponConsumerEntityList
     */
    public void batchInsertCoupon(List<QihoCouponConsumerEntity> couponConsumerEntityList){
        if (CollectionUtils.isEmpty(couponConsumerEntityList))
            return;
        CouponRunnable runnable = context.getBean(CouponRunnable.class);
        runnable.setParams(couponConsumerEntityList);
        executorService.submit(runnable);
    }

    /**
     * 批量绑定或删除活动与优惠券模板关系
     * @param couponActiveEntities
     * @Param 表示这次批量操作时新增还是删除 true-insert false-delete
     */
    public void batchInsertCouponActive(List<QihoCouponActiveEntity> couponActiveEntities,Boolean flag){
        if (CollectionUtils.isEmpty(couponActiveEntities))
            return;
        CouponActiveRunnable runnable = context.getBean(CouponActiveRunnable.class);
        runnable.setParams(couponActiveEntities);
        runnable.setFlagInsertOrDelete(flag);
        executorService.submit(runnable);
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext){
        this.context = applicationContext;
    }
}
