package com.qiho.center.biz.bo;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.jd.open.api.sdk.JdException;
import com.jd.open.api.sdk.domain.etms.TraceQueryJsf.TraceDTO;
import com.jd.open.api.sdk.response.etms.LdopReceiveTraceGetResponse;
import com.qiho.center.api.dto.logistics.LogisticsOrderDto;
import com.qiho.center.api.enums.JDLogisticsOrderStatusEnum;
import com.qiho.center.api.enums.LogisticsOrderStatusEnum;
import com.qiho.center.biz.service.impl.LogisticsOrderServiceImpl;
import com.qiho.center.common.dao.QihoLogisticsOrderDAO;
import com.qiho.center.common.entity.logistics.LogisticsOrderEntity;
import com.qiho.center.common.util.JDClientUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created by weny.cai on 2017/10/27.
 */
@Service
public class JDLogisticsSyncBo {

    private static final Logger   logger                = LoggerFactory.getLogger(JDLogisticsSyncBo.class);

    private static final String   RESPONSE_SUCCESS_CODE = "0";                                             // 响应成功

    @Autowired
    JDClientUtil                  jdClientUtil;

    @Autowired
    private QihoLogisticsOrderDAO qihoLogisticsOrderDAO;

    @Autowired
    LogisticsOrderServiceImpl     logisticsOrderService;

    /**
     * 更新京东快递类型 物流子订单状态(除非签收成功|退件成功)
     */
    public void syncLogisticsOrderStatus(List<LogisticsOrderEntity> list) {
        // 循环查询京东物流接口 更新物流子订单状态
        for (LogisticsOrderEntity entity : list) {
            if (StringUtils.isBlank(entity.getPostId())) {
                continue;
            }
            try {
                LdopReceiveTraceGetResponse response = jdClientUtil.executeLdopReceiveTrace(entity.getPostId());
                List<TraceDTO> sendList = response.getQuerytraceResult().getData();
                if (RESPONSE_SUCCESS_CODE.equals(response.getCode()) && CollectionUtils.isNotEmpty(sendList)) {
                    TraceDTO traceDTO = sendList.get(sendList.size() - 1);// 取最后一次物流信息
                    updateJdStatus(entity, traceDTO);
                }
                Thread.sleep(100L);
            } catch (JdException e) {
                logger.warn("京东物流接口调用失败", e);
            } catch (Exception e) {
                logger.warn("系统异常", e);
            }
        }
    }

    /**
     * @author zhanglihui
     * @param entity
     * @param traceDTO
     * @throws JdException
     */
    private void updateJdStatus(LogisticsOrderEntity entity, TraceDTO traceDTO) throws JdException {
        if (traceDTO == null) {
            return;
        }
        JDLogisticsOrderStatusEnum statusEnum = JDLogisticsOrderStatusEnum.getByDesc(traceDTO.getOpeTitle());
        // 物流订单状态
        String orderStatus = statusEnum == null ? null : statusEnum.getCode();
        // 京东物流状态描述
        String logisticsStatusDesc = null;
        if (!traceDTO.getWaybillCode().equals(entity.getPostId())) {// 新运单号为退货
            LdopReceiveTraceGetResponse returnResponse = jdClientUtil.executeLdopReceiveTrace(traceDTO.getWaybillCode());
            List<TraceDTO> returnList = returnResponse.getQuerytraceResult().getData();
            if (RESPONSE_SUCCESS_CODE.equals(returnResponse.getCode()) && CollectionUtils.isNotEmpty(returnList)) {
                TraceDTO returnTraceDTO = returnList.get(returnList.size() - 1);
                logisticsStatusDesc = returnTraceDTO.getOpeTitle();
                if (JDLogisticsOrderStatusEnum.JD_SUCCESS.getDesc().equals(logisticsStatusDesc)) {// 退件成功或者正在途中=拒收
                    orderStatus = LogisticsOrderStatusEnum.RETURN.getCode();
                } else {
                    orderStatus = LogisticsOrderStatusEnum.REJECTED.getCode();
                }
            }
        } else {
            logisticsStatusDesc = traceDTO.getOpeTitle();
        }
        if (!StringUtils.equals(entity.getOrderStatus(), orderStatus)) {// 非相同物流状态进行更新
            entity.setLogisticsStatus(logisticsStatusDesc);
            entity.setOrderStatus(orderStatus);
            LogisticsOrderDto dto = BeanUtils.copy(entity, LogisticsOrderDto.class);
            logisticsOrderService.update(dto);
        }
    }


}
