package com.qiho.center.biz.bo;

import com.qiho.center.biz.service.finance.FinanceService;
import com.qiho.center.biz.service.impl.finance.bean.CashRebateAmountBean;
import com.qiho.center.common.constant.DsConstants;
import com.qiho.center.common.daoh.qiho.finance.BaiqiFinanceDetailMapper;
import com.qiho.center.common.entityd.qiho.finance.BaiqiFinanceDetailEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

import javax.annotation.Resource;

/**
 * 商家广告BO
 *
 * @author peanut.huang
 * @date 2018/1/3.
 */
@Component
public class MerchantAdvertBO {

    private static final Logger LOGGER = LoggerFactory.getLogger(MerchantAdvertBO.class);


    @Resource
    private BaiqiFinanceDetailMapper financeDetailMapper;
    @Resource
    private FinanceService financeService;

    /**
     * 保存流水 + 商家账户扣款
     *
     * @param detailEntity
     * @param amountBean
     */
    @Transactional(rollbackFor = Exception.class, value = DsConstants.DATABASE_QIHO)
    public void saveDetailAndReduceAmount(Long financeId, BaiqiFinanceDetailEntity detailEntity, CashRebateAmountBean amountBean) {

        if(amountBean != null){
            Long id = detailEntity.getId();
            try {
                if(id == null){
                    financeDetailMapper.insert(detailEntity);
                }else {
                    financeDetailMapper.update(detailEntity);
                }

                financeService.updateFinanceAmountById(financeId, amountBean);

            }catch (Exception e){
                LOGGER.error("saveDetailAndReduceAmount failed:", e);

                //rollback
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            }
        }
    }
}
